/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.AbstractDateSelector;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateDocumentHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateTextField;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleDateSelector<D extends DateTextField>
extends AbstractDateSelector<D> {
    private static final Logger logger = Logger.getLogger(SingleDateSelector.class);
    private static Date testDate = Calendar.getInstance().getTime();

    public SingleDateSelector() {
        this(GWCalendarUtils.getTodayWithoutTimeFraction());
    }

    public SingleDateSelector(Calendar theDate) {
        if (theDate == null) {
            throw new IllegalArgumentException("Date can not be NULL");
        }
        this.setDate(theDate);
        this.dateField.setColumns(this.calculateColumnsNumber());
    }

    @Override
    protected DateTextField createDateTextField() {
        return new DateTextField(this.getDateFormat(), new DateDocumentHandler());
    }

    private int calculateColumnsNumber() {
        return this.getDateFormat().format(testDate).length();
    }

    public void setDate(Calendar date) {
        logger.debug((Object)("date: " + DateAndTimeFormattingUtils.calendarToLogString(date)));
        logger.debug((Object)("current date: " + DateAndTimeFormattingUtils.calendarToLogString(this.getCurrentDate())));
        if (date.equals(this.getCurrentDate())) {
            logger.debug((Object)"new date equals with current date");
            return;
        }
        logger.debug((Object)"new date differs with current date");
        this.removeListeners();
        this.calendar.setDate(date);
        this.dateField.setDate(date);
        this.setCurrentDate(date);
        this.addListeners();
    }

    public Calendar getDate() {
        this.dateField.commit();
        return this.dateField.getDate();
    }

    @Override
    protected MonthlyCalendar createCalendar() {
        return new MonthlyCalendar(GWCalendarUtils.getToday(), true, true);
    }

    @Override
    protected void processDateChangeEvent(Calendar newDate) {
        this.fireDateChanged(new DateChangeEvent(newDate, this));
    }

    public void setIcon(ImageIcon theIcon) {
        this.pickerButton.setIcon(theIcon);
    }
}

