/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar;

import com.appframework.Application;
import com.appframework.mvc.Command;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AcceptsDroppedCalendarItems;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemDropTargetListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarComponent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.CommandListener;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.StaticCalendarModel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class StaticMonthlyCalendar
extends MonthlyCalendar
implements AcceptsDroppedCalendarItems {
    private static Logger logger = Logger.getLogger(StaticMonthlyCalendar.class);
    private static final int YEARLY_CELL_WIDTH = PLAFChanger.getFontSize() * 2 - 6;
    private static final int YEARLY_CELL_HEIGHT = PLAFChanger.getFontSize() + 2;
    private static final int YEARLY_LABELS_HEIGHT = PLAFChanger.getFontSize() + 4;
    private ArrayList commandListeners = new ArrayList();

    public StaticMonthlyCalendar(CalendarModel theCalendarModel, boolean multipleSelectionMode) {
        super(theCalendarModel, false);
        this.calendar.setSelectionMode(multipleSelectionMode);
        this.calendar.setDropTarget(new DropTarget(this.calendar, new CalendarItemDropTargetListener(this, Application.getGWMainAppFrame().getController())));
    }

    protected void createCalendar(CalendarModel theCalendarModel) {
        this.calendar = new CalendarComponent(theCalendarModel, YEARLY_CELL_WIDTH, YEARLY_CELL_HEIGHT, YEARLY_LABELS_HEIGHT, false);
    }

    public void modelChanged(CalendarEvent e) {
        this.fireValueChanged(new DateChangeEvent(e.getDate(), this));
    }

    protected void handleClick(Point thePoint, boolean isShiftDown, boolean isDoubleClick) {
        super.handleClick(thePoint, isShiftDown, isDoubleClick);
        if (isDoubleClick) {
            try {
                String userGuid = ControlsUtils.getUserGuid(this);
                CalendarUtils.showCalendarFrame(userGuid, this.getDate().getTime());
            }
            catch (GWCommandException e1) {
                logger.error((Object)e1);
            }
        }
    }

    private void fireCommand(Command theCommand) {
        int nSize = this.commandListeners.size();
        for (int i = 0; i < nSize; ++i) {
            CommandListener listener = (CommandListener)this.commandListeners.get(i);
            listener.perform(theCommand);
        }
    }

    public void addCommandListener(CommandListener theListener) {
        this.commandListeners.add(theListener);
    }

    public void removeCommandListener(CommandListener theListener) {
        this.commandListeners.remove(theListener);
    }

    public void clearSelection() {
        this.calendar.clearSelection();
    }

    public void updateSelection() {
        this.calendar.updateSelection();
    }

    public void validateBusyDays(IItemList itemList) {
        ((StaticCalendarModel)this.calendar.getModel()).validateBusyDays(itemList);
        this.calendar.repaint();
    }

    public void forceInitBusyDays() {
        ((StaticCalendarModel)this.calendar.getModel()).forceInitBusyDays();
    }

    public void requestFocus() {
        super.requestFocus();
    }

    public Date getDragDate() {
        return this.calendar.getDragOverDate();
    }

    public void highlightDragHours(Point theLocation, long theDurationInMinutes) {
        this.calendar.setHighLighted(theLocation);
    }

    public void clearHighlightDragHours() {
        this.calendar.clearHighLight();
    }

    public boolean acceptsDraggableItem(AbstractItem item) {
        return item instanceof AbstractCalendarItem;
    }
}

