/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Day;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.CommandListener;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.StaticCalendarModel;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.StaticMonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.YearlyCalendarLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class YearlyCalendar
extends JComponent
implements DateValueChangeListener,
CommandListener {
    private static Logger logger = Logger.getLogger(YearlyCalendar.class);
    private static final int MAX_ROWS = 4;
    private static final int MAX_COLS = 4;
    private static final int MONTH_COUNT = 12;
    private Calendar current;
    private boolean allowMultipleSelect;
    private YearlyCalendarLayout layout;
    private ArrayList<DateValueChangeListener> listeners;
    private MVCController controller;
    private boolean m_bDirty = false;
    private IItemList itemList;
    private MonthManager monthManager = new MonthManager();
    private static int nextInstanceId = 0;
    private int instanceId = nextInstanceId++;

    public YearlyCalendar(Day day, boolean allowMultipleSelect, MVCController controller, IItemList itemList) {
        this(GWCalendarUtils.convertDayToCalendar(day), allowMultipleSelect, controller, itemList);
    }

    private YearlyCalendar(Calendar theDate, boolean allowMultipleSelect, MVCController theController, IItemList itemList) {
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.current = (Calendar)theDate.clone();
        this.allowMultipleSelect = allowMultipleSelect;
        this.listeners = new ArrayList();
        this.controller = theController;
        this.itemList = itemList;
        this.build();
        this.setCurrentDateToMonth();
    }

    protected void build() {
        this.layout = new YearlyCalendarLayout();
        this.layout.setHgap(5);
        this.layout.setVgap(5);
        this.setLayout(this.layout);
        this.m_bDirty = true;
        this.validateBusyDays(this.itemList);
        this.refreshFocusableMonthes();
        this.addComponentListener(new ResizeListener());
    }

    public void setItemList(IItemList itemList) {
        this.itemList = itemList;
        this.validateBusyDays(itemList);
    }

    public int getPrefferedWidth() {
        return (int)this.monthManager.getMonthlyCalendarSize().getWidth();
    }

    private void handleResize(boolean force) {
        int size;
        int index;
        boolean refreshFocus = this.getSelectedMonth().isFocusOwner();
        Insets insets = this.getInsets();
        int cols = this.calculateVisibleCols(this.getWidth() - insets.left - insets.right);
        int rows = this.calculateVisibleRows(this.getHeight() - insets.top - insets.bottom);
        if (cols == 4 && rows == 4) {
            rows = 3;
        }
        if (!force && this.layout.getColumns() == cols && this.layout.getRows() == rows) {
            return;
        }
        this.layout.setColumns(cols);
        this.layout.setRows(rows);
        this.removeMonthes();
        int count = cols * rows;
        int curr = this.getSelectedMonthIndex();
        if (curr <= 12 - count) {
            index = curr;
            size = curr + count;
        } else {
            index = 12 - count;
            size = 12;
        }
        for (int i = index; i < size; ++i) {
            this.addMonth(i);
        }
        this.validate();
        this.repaint();
        if (refreshFocus) {
            this.getSelectedMonth().requestFocus();
        }
    }

    private void removeMonthes() {
        this.monthManager.clear();
        this.removeAll();
    }

    private void addMonth(int month) {
        StaticMonthlyCalendar monthlyCalendar = this.monthManager.getMonth(month);
        this.add(monthlyCalendar);
    }

    private StaticMonthlyCalendar getSelectedMonth() {
        StaticMonthlyCalendar selectedMonth = this.monthManager.getMonth(this.getSelectedMonthIndex());
        return selectedMonth;
    }

    private int getSelectedMonthIndex() {
        return this.current.get(2);
    }

    private int calculateVisibleRows(int theHeight) {
        return Math.max(Math.min(theHeight / (this.monthManager.getMonthlyCalendarSize().height + 5), 4), 1);
    }

    private int calculateVisibleCols(int theWidth) {
        return Math.max(Math.min(theWidth / (this.monthManager.getMonthlyCalendarSize().width + 5), 4), 1);
    }

    public void valueChanged(DateChangeEvent e) {
        this.setCurrentDate(e.getDate());
    }

    private void refreshFocusableMonthes() {
        StaticMonthlyCalendar selectedMonthlyCalendar = this.getSelectedMonth();
        for (StaticMonthlyCalendar monthlyCalendar : this.monthManager.getAll()) {
            monthlyCalendar.setFocusable(monthlyCalendar == selectedMonthlyCalendar);
        }
    }

    public void setCurrentDate(Day day) {
        this.setCurrentDate(GWCalendarUtils.convertDayToCalendar(day));
    }

    private void setCurrentDate(Calendar newDate) {
        logger.debug((Object)(DateAndTimeFormattingUtils.calendarToLogString(this.current) + " > " + DateAndTimeFormattingUtils.calendarToLogString(newDate) + " (" + this + ')'));
        int mask = GWCalendarUtils.getChangeMask(this.current, newDate);
        if (mask == 0 && !this.monthManager.getAll().isEmpty()) {
            return;
        }
        this.current.setTime(newDate.getTime());
        if ((mask & 4) != 0) {
            this.m_bDirty = true;
            this.validateBusyDays(this.itemList);
            this.handleResize(true);
        }
        StaticMonthlyCalendar selectedMonth = this.getSelectedMonth();
        if ((mask & 2) != 0) {
            this.clear();
            if (!this.isMonthlyCalendarShown(selectedMonth)) {
                this.handleResize(true);
            }
        }
        this.setCurrentDateToMonth();
        this.fireValueChanged(new DateChangeEvent(newDate, this));
    }

    private boolean isMonthlyCalendarShown(StaticMonthlyCalendar monthlyCalendar) {
        return Arrays.asList(this.getComponents()).contains(monthlyCalendar);
    }

    private void setCurrentDateToMonth() {
        StaticMonthlyCalendar selectedMonth = this.getSelectedMonth();
        selectedMonth.setDate(this.current);
        this.refreshFocusableMonthes();
        selectedMonth.updateSelection();
        Component permanentFocusOwner = FocusManager.getCurrentManager().getPermanentFocusOwner();
        if (this.isShowing() && (permanentFocusOwner == null || SwingUtilities.isDescendingFrom(permanentFocusOwner, this))) {
            selectedMonth.requestFocus();
        }
    }

    private void fireValueChanged(DateChangeEvent e) {
        for (DateValueChangeListener listener : this.listeners) {
            listener.valueChanged(e);
        }
    }

    public void addValueChangeListener(DateValueChangeListener theListener) {
        this.listeners.add(theListener);
    }

    public void removeValueChangeListener(DateValueChangeListener theListener) {
        this.listeners.remove(theListener);
    }

    private void clear() {
        StaticMonthlyCalendar selectedMonth = this.getSelectedMonth();
        for (StaticMonthlyCalendar monthlyCalendar : this.monthManager.getAll()) {
            if (monthlyCalendar == selectedMonth) continue;
            monthlyCalendar.clearSelection();
            monthlyCalendar.repaint();
        }
    }

    public void perform(Command theCommand) {
        this.controller.processCommand(theCommand);
    }

    public void setDirty() {
        this.m_bDirty = true;
        for (StaticMonthlyCalendar monthlyCalendar : this.monthManager.getAll()) {
            monthlyCalendar.forceInitBusyDays();
        }
    }

    public void validateBusyDays(IItemList itemList) {
        if (this.m_bDirty && itemList != null) {
            this.m_bDirty = false;
            for (StaticMonthlyCalendar monthlyCalendar : this.monthManager.getAll()) {
                monthlyCalendar.validateBusyDays(itemList);
            }
        }
    }

    public void requestFocus() {
        this.getSelectedMonth().requestFocus();
    }

    public void refreshUIOptions() {
        for (StaticMonthlyCalendar monthlyCalendar : this.monthManager.getAll()) {
            monthlyCalendar.getCalendarComponent().getModel().refreshUIOptions();
            monthlyCalendar.getCalendarComponent().update();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("[instance: ");
        builder.append(this.instanceId);
        builder.append(", parent: ");
        builder.append(this.getParent());
        builder.append(']');
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MonthManager {
        private Map<Integer, StaticMonthlyCalendar> monthes = new HashMap<Integer, StaticMonthlyCalendar>();

        private MonthManager() {
        }

        StaticMonthlyCalendar getMonth(int month) {
            assert (month >= 0 && month < 12) : "invalid month: " + month;
            StaticMonthlyCalendar monthlyCalendar = this.monthes.get(month);
            if (monthlyCalendar == null) {
                monthlyCalendar = this.createMonth(month);
                this.monthes.put(month, monthlyCalendar);
            }
            return monthlyCalendar;
        }

        void clear() {
            for (StaticMonthlyCalendar month : this.monthes.values()) {
                this.destroyMonth(month);
            }
            this.monthes.clear();
        }

        Collection<StaticMonthlyCalendar> getAll() {
            return this.monthes.values();
        }

        Dimension getMonthlyCalendarSize() {
            Dimension size = this.getMonth(YearlyCalendar.this.current.get(2)).getPreferredSize();
            return size;
        }

        private StaticMonthlyCalendar createMonth(int month) {
            YearlyCalendar yearlyCalendar = YearlyCalendar.this;
            String userGuid = ControlsUtils.getUserGuid(yearlyCalendar.controller);
            Calendar calendar = (Calendar)yearlyCalendar.current.clone();
            calendar.set(5, 1);
            calendar.set(2, month);
            StaticCalendarModel calendarModel = new StaticCalendarModel(calendar, userGuid, yearlyCalendar.itemList);
            StaticMonthlyCalendar monthlyCalendar = new StaticMonthlyCalendar(calendarModel, yearlyCalendar.allowMultipleSelect);
            monthlyCalendar.addValueChangeListener(yearlyCalendar);
            monthlyCalendar.addCommandListener(yearlyCalendar);
            monthlyCalendar.setFocusable(false);
            monthlyCalendar.validateBusyDays(yearlyCalendar.itemList);
            return monthlyCalendar;
        }

        private void destroyMonth(StaticMonthlyCalendar monthlyCalendar) {
            YearlyCalendar yearlyCalendar = YearlyCalendar.this;
            monthlyCalendar.removeValueChangeListener(yearlyCalendar);
            monthlyCalendar.removeCommandListener(yearlyCalendar);
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        public void componentResized(ComponentEvent e) {
            YearlyCalendar.this.handleResize(false);
        }
    }
}

