/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcomponent;

import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.gwcomponent.GWComponentClipboardAdapter;
import com.novell.gw.jclient.application.controls.gwcomponent.GWCutCopyPasteUndoPopup;
import com.novell.gw.jclient.application.controls.gwcomponent.GWMouseAdapter;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextArea;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class GWTextArea
extends OrientableTextArea {
    private boolean showCopyPastePopup = true;

    public GWTextArea() {
        this.addMouseListener(new GWTextAreaMouseAdapter());
        this.init();
    }

    public GWTextArea(int rows, int columns) {
        super(rows, columns);
        this.addMouseListener(new GWTextAreaMouseAdapter());
        this.init();
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 9 && e.isControlDown() && e.getID() == 401) {
            this.insert("\t", this.getCaretPosition());
        } else {
            super.processKeyEvent(e);
        }
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
        if (!b) {
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                this.setBackground(new Color(UIManager.getColor("Panel.background").getRGB()));
            } else {
                this.setOpaque(false);
            }
        }
    }

    private void init() {
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>(2);
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.setFocusTraversalKeys(0, keys);
        keys.clear();
        keys.add(KeyStroke.getKeyStroke(9, 64));
        this.setFocusTraversalKeys(1, keys);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.addMouseListener(new GWTextAreaMouseAdapter());
    }

    public boolean isShowCopyPastePopup() {
        return this.showCopyPastePopup;
    }

    public void setShowCopyPastePopup(boolean showCopyPastePopup) {
        this.showCopyPastePopup = showCopyPastePopup;
    }

    private class GWTextAreaMouseAdapter
    extends GWMouseAdapter {
        private GWComponentClipboardAdapter clipboardAdapter;

        public GWTextAreaMouseAdapter() {
            this.clipboardAdapter = new GWComponentClipboardAdapter<GWTextArea>(GWTextArea.this);
        }

        public void showPopup(MouseEvent e) {
            if (GWTextArea.this.showCopyPastePopup) {
                GWCutCopyPasteUndoPopup.getInstance().show(this.clipboardAdapter, e.getX(), e.getY());
            }
        }
    }
}

