/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwtooltips;

import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipSet;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.SwingConstants;

public class GWToolTip
implements SwingConstants {
    private static String KEY_DELIMETER = "%@;";
    private static String VALUE_DELIMETER = "%@&";
    private static int DELIMETER_SIZE = 3;
    public String key = "";
    public String value = "";

    public static String getString(AbstractItem item) {
        ArrayList<GWToolTipSet> al = new ArrayList<GWToolTipSet>();
        if (!item.getSendOptionConcealSubject()) {
            al.add(new GWToolTipSet(StringResources.SUBJECT_C + ' ', GWToolTip.getValue(item.getSubject())));
        }
        al.add(new GWToolTipSet(StringResources.FROM_C + ' ', GWToolTip.getValue(item.getSender().getDisplayText())));
        al.add(new GWToolTipSet(StringResources.TO_C + ' ', GWToolTip.getValue(item.getTo())));
        al.add(new GWToolTipSet(StringResources.CC_C + ' ', GWToolTip.getValue(item.getCc())));
        if (item instanceof ReminderNote) {
            al.add(new GWToolTipSet(StringResources.START_DATE_C + ' ', OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(((AbstractCalendarItem)item).getStartDate())));
        } else if (item instanceof TaskItem) {
            Date startDate = new Date(((TaskItem)item).getDateTaskAssigned());
            al.add(new GWToolTipSet(StringResources.START_DATE_C + ' ', OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(startDate)));
            al.add(new GWToolTipSet(StringResources.DUE_DATE_C + ' ', OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(((AbstractCalendarItem)item).getEndDate())));
            String taskPriority = ((TaskItem)item).getTaskPriority();
            if (taskPriority == null) {
                taskPriority = "";
            }
            al.add(new GWToolTipSet(StringResources.PRIORITY_C + ' ', taskPriority));
        } else if (item instanceof AppointmentItem) {
            al.add(new GWToolTipSet(StringResources.TIME_C + ' ', GWToolTip.buildTimeString((AppointmentItem)item)));
            al.add(new GWToolTipSet(StringResources.PLACE_C + ' ', GWToolTip.getValue(((AppointmentItem)item).getLocation())));
            if (!((AppointmentItem)item).isAllDayEvent()) {
                al.add(new GWToolTipSet(StringResources.START_DATE_C + ' ', OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(((AbstractCalendarItem)item).getStartDate())));
                al.add(new GWToolTipSet(StringResources.END_DATE_C + ' ', OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(((AbstractCalendarItem)item).getEndDate())));
            }
        } else if (item instanceof PhoneItem) {
            al.add(new GWToolTipSet(StringResources.CALLER_C + ' ', GWToolTip.getValue(((PhoneItem)item).getCaller())));
            al.add(new GWToolTipSet(StringResources.COMPANY_C + ' ', GWToolTip.getValue(((PhoneItem)item).getCompany())));
            al.add(new GWToolTipSet(StringResources.PHONE_C + ' ', GWToolTip.getValue(((PhoneItem)item).getPhone())));
        }
        al.add(new GWToolTipSet(StringResources.DATE_SENT_C + ' ', OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(item.getDate())));
        return GWToolTip.getString(al);
    }

    private static String getValue(String theString) {
        if (theString == null) {
            return "";
        }
        return theString;
    }

    public static String getString(List theList) {
        String sTip = "";
        int nSize = theList.size();
        for (int i = 0; i < nSize; ++i) {
            GWToolTipSet set = (GWToolTipSet)theList.get(i);
            sTip = sTip + KEY_DELIMETER + set.getKey() + VALUE_DELIMETER + set.getValue();
        }
        return sTip;
    }

    public static ArrayList getArrayList(String str) {
        int x;
        if (str == null) {
            str = "";
        }
        ArrayList<GWToolTipSet> al = new ArrayList<GWToolTipSet>();
        while (str.length() > 0 && (x = str.indexOf(KEY_DELIMETER)) >= 0) {
            String value;
            str = str.substring(x);
            x = str.indexOf(VALUE_DELIMETER);
            String key = str.substring(DELIMETER_SIZE, x);
            if ((x = (str = str.substring(x)).indexOf(KEY_DELIMETER)) < 0) {
                value = str.substring(DELIMETER_SIZE);
                al.add(new GWToolTipSet(key, value));
                break;
            }
            value = str.substring(DELIMETER_SIZE, x);
            al.add(new GWToolTipSet(key, value));
            str = str.substring(x);
        }
        return al;
    }

    private static String buildTimeString(AppointmentItem appointmentItem) {
        String dateFormat;
        DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
        if (appointmentItem.isAllDayEvent()) {
            dateFormat = dateTimeOptions.getDateFormat();
            if (appointmentItem.getDurationInDays() == 1L) {
                return DateAndTimeFormattingUtils.formatDate(appointmentItem.getStartDate(), dateFormat);
            }
        } else {
            dateFormat = dateTimeOptions.getTimeFormat();
        }
        String startDate = DateAndTimeFormattingUtils.formatDate(appointmentItem.getStartDate(), dateFormat);
        String endDate = DateAndTimeFormattingUtils.formatDate(appointmentItem.getEndDate(), dateFormat);
        return StringResources.formatString(StringResources.TWO_DATES, startDate, endDate);
    }
}

