/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.header.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.application.controls.skinnable.ComponentPropertyManager;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class ActionChangeHeaderFontSize
extends AppAction {
    protected static final Integer[] textSizes = FontOptions.SIZES_PLAINTEXT;
    protected int headerTextSize = (Integer)ComponentPropertyManager.getInstance().getSkinPropertyValue(SkinProperty.HEADER_FONT_SIZE);
    ArrayList menus = new ArrayList();

    public ActionChangeHeaderFontSize(ActionList theAppActionList) {
        this(theAppActionList, ActionKey.CHANGE_HEADER_FONT_SIZE, StringResources.HEADER_FONT_SIZE);
    }

    public ActionChangeHeaderFontSize(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
    }

    protected void selectMenuItem() {
        int nSize = this.menus.size();
        block0: for (int k = 0; k < nSize; ++k) {
            JMenu jMenu = (JMenu)this.menus.get(k);
            for (Component menuComponent : jMenu.getMenuComponents()) {
                JMenuItem menuItem;
                String value;
                if (!(menuComponent instanceof JMenuItem) || !(value = (menuItem = (JMenuItem)menuComponent).getText()).equals(String.valueOf(this.headerTextSize))) continue;
                menuItem.setSelected(true);
                continue block0;
            }
        }
    }

    private JMenu buildSubMenu() {
        ComponentOrientation co = UIUtils.getComponentOrientation();
        GWMenu menu = new GWMenu(this);
        menu.setComponentOrientation(co);
        ButtonGroup group = new ButtonGroup();
        int nCount = textSizes.length;
        for (int i = 0; i < nCount; ++i) {
            JRadioButtonMenuItem menuItem = this.createRadioButtonMenuItem(i);
            group.add(menuItem);
            menu.add(menuItem);
        }
        this.menus.add(menu);
        this.selectMenuItem();
        return menu;
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(int i) {
        OrientableRadioButtonMenuItem menuItem = new OrientableRadioButtonMenuItem(new SubAction(textSizes[i]));
        return menuItem;
    }

    public JMenu getSubMenu() {
        return this.buildSubMenu();
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 590, new HEADER_TEXT_SIZE_CHANGED_EventListener()));
    }

    private class SubAction
    extends AbstractAction {
        private int textSize;

        public SubAction(int value) {
            super(String.valueOf(value));
            this.textSize = value;
        }

        public void actionPerformed(ActionEvent e) {
            GlobalCommand command = new GlobalCommand(590, this.textSize);
            ActionChangeHeaderFontSize.this.getActionList().processCommand(command);
            DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
            dataStoreSettings.setHeaderFontSize(this.textSize);
            dataStoreSettings.setHeaderSettings();
            ComponentPropertyManager.getInstance().updateProperty(SkinProperty.HEADER_FONT_SIZE, this.textSize);
        }
    }

    private class HEADER_TEXT_SIZE_CHANGED_EventListener
    extends AppEventListener {
        private HEADER_TEXT_SIZE_CHANGED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            ActionChangeHeaderFontSize.this.headerTextSize = (Integer)theEvent.getData();
            ActionChangeHeaderFontSize.this.selectMenuItem();
        }
    }
}

