/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.header.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.resources.ImageResources;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.options.AppearanceSettings;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class ActionShowHideFolderList
extends AppAction {
    private AbstractFolder folder;
    private ButtonList buttonList = new ButtonList();

    public ActionShowHideFolderList(ActionList actionList) {
        super(actionList, ActionKey.SHOW_HIDE_FOLDER_LIST, StringResources.FOLDER_LIST, ImageResources.ACT_FOLDER_LIST);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.setToolTipText(StringResources.DISPLAY_OR_HIDE_FOLDER_LIST);
    }

    protected void performAction(ActionEvent e) {
        boolean selected;
        boolean bl = selected = !this.isFolderListVisible();
        if (this.isFolderTreeApplyPerFolder()) {
            this.folder.getDisplaySettings().setFolderTreeVisible(selected);
        } else {
            AppearanceSettings settings = GWCommandManager.getInstance(this.getUserGuid()).getAppearanceSettings();
            settings.setFolderTreeVisible(selected);
        }
        this.setSelected(selected);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.getActionList().getMVCView() instanceof GWMainAppFrame) {
            GWMainAppFrame mainFrame = (GWMainAppFrame)this.getActionList().getMVCView();
            mainFrame.setFolderListVisible(selected);
        }
        this.buttonList.setSelected(selected);
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        this.buttonList.setEnabled(newValue);
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1090, new OPEN_FOLDER_Listener()));
        FOLDER_SETTINGS_CHANGED_listener listener = new FOLDER_SETTINGS_CHANGED_listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1210, listener));
    }

    private boolean isFolderTreeApplyPerFolder() {
        return this.folder != null && this.folder.getDisplaySettings().getFolderTreeApplyPerFolder();
    }

    private boolean isFolderListVisible() {
        if (this.isFolderTreeApplyPerFolder()) {
            return this.folder.getDisplaySettings().isFolderTreeVisible();
        }
        return GWCommandManager.getInstance(this.getUserGuid()).getAppearanceSettings().isFolderTreeVisible();
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttonList.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        JComponent component = super.getToolBarComponent();
        if (component instanceof AbstractButton) {
            this.buttonList.add((AbstractButton)component);
        }
        return component;
    }

    private class FOLDER_SETTINGS_CHANGED_listener
    extends AppEventListener {
        private FOLDER_SETTINGS_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            Object o = theEvent.getData();
            if (o instanceof AbstractFolder) {
                boolean isFolderTreeVisible = EngineCommandManager.getInstance(ActionShowHideFolderList.this.getUserGuid()).getAppearanceSettings().isFolderTreeVisible();
                AbstractFolder folder = (AbstractFolder)o;
                if (folder.getDisplaySettings().getFolderTreeApplyPerFolder()) {
                    ActionShowHideFolderList.this.setSelected(folder.getDisplaySettings().isFolderTreeVisible());
                } else {
                    ActionShowHideFolderList.this.setSelected(isFolderTreeVisible);
                }
            }
        }
    }

    private class OPEN_FOLDER_Listener
    extends AppEventListener {
        private OPEN_FOLDER_Listener() {
        }

        public void handle(AppEvent theEvent) {
            Object o = theEvent.getData();
            if (o instanceof AbstractFolder) {
                ActionShowHideFolderList.this.folder = (AbstractFolder)o;
                ActionShowHideFolderList.this.setEnabled(true);
                ActionShowHideFolderList.this.setSelected(ActionShowHideFolderList.this.isFolderListVisible());
            }
        }
    }
}

