/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelModel;
import java.util.Calendar;
import org.apache.log4j.Logger;

public abstract class RecurringItemEditPanelModel
extends ItemEditPanelModel {
    private static Logger logger = Logger.getLogger(RecurringItemEditPanelModel.class);
    protected Calendar startDay = this.getTodayCalendar();
    protected Calendar[] startDays;
    protected boolean recurring = false;

    public RecurringItemEditPanelModel() {
        GWCalendarUtils.clearTime(this.startDay);
        this.startDays = new Calendar[]{(Calendar)this.startDay.clone()};
    }

    public boolean isRecurring() {
        return this.recurring;
    }

    private void setRecurring(boolean recurring) {
        if (this.recurring != recurring) {
            this.recurring = recurring;
        }
    }

    public void setStartDate(Calendar startDate) {
        if (startDate == null) {
            throw new IllegalArgumentException("startDate is null");
        }
        logger.debug((Object)("startDate: " + startDate.getTime()));
        Calendar oldValue = (Calendar)this.startDay.clone();
        this.startDay = RecurringItemEditPanelModel.cloneAndClearTime(startDate);
        this.setRecurring(false);
        this.processStartDateChanged(oldValue, (Calendar)this.startDay.clone());
    }

    public void setStartDates(Calendar[] startDates) {
        if (startDates == null) {
            throw new IllegalArgumentException("startDates = null");
        }
        if (startDates.length == 0) {
            throw new IllegalArgumentException("startDates is empty array");
        }
        Calendar oldValue = (Calendar)this.startDays[0].clone();
        this.startDays = new Calendar[startDates.length];
        for (int i = 0; i < startDates.length; ++i) {
            this.startDays[i] = RecurringItemEditPanelModel.cloneAndClearTime(startDates[i]);
        }
        this.setRecurring(true);
        this.processStartDateChanged(oldValue, (Calendar)this.startDays[0].clone());
    }

    public Calendar getNonRecurringStartDate() {
        return (Calendar)this.startDay.clone();
    }

    public Calendar[] getStartDates() {
        if (this.recurring) {
            Calendar[] startDates = new Calendar[this.startDays.length];
            for (int i = 0; i < startDates.length; ++i) {
                startDates[i] = (Calendar)this.startDays[i].clone();
            }
            return startDates;
        }
        return new Calendar[]{(Calendar)this.startDay.clone()};
    }

    protected void processStartDateChanged(Calendar oldValue, Calendar newValue) {
    }

    protected String getToStringContent() {
        StringBuilder builder = new StringBuilder();
        builder.append("recurring: ");
        builder.append(this.recurring);
        builder.append(", start date: ");
        builder.append(this.startDay.getTime());
        builder.append(", start date (recurring): ");
        builder.append(this.startDays[0].getTime());
        builder.append(" (0 of ");
        builder.append(this.startDays.length);
        builder.append(')');
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append('[');
        this.getToStringContent();
        builder.append(']');
        return builder.toString();
    }

    protected Calendar getTodayCalendar() {
        return GWCalendarUtils.getToday();
    }

    protected static Calendar cloneAndClearTime(Calendar calendar) {
        calendar = (Calendar)calendar.clone();
        GWCalendarUtils.clearTime(calendar);
        return calendar;
    }

    public void changeStartDate(int daysToAdd) {
        if (this.recurring) {
            Calendar[] dates = this.startDays;
            dates[0].add(6, daysToAdd);
            this.setStartDates(dates);
        } else {
            Calendar date = (Calendar)this.startDay.clone();
            date.add(6, daysToAdd);
            this.setStartDate(date);
        }
    }
}

