/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.appframework.mvc.MVCController;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.ExtendedDateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateSelector;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.FromComponent;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelController;
import com.novell.gw.jclient.application.controls.itemedit.RecurringItemEditPanel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Calendar;
import java.util.Date;
import javax.swing.FocusManager;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class ReminderNoteEditPanel
extends RecurringItemEditPanel {
    private static Logger logger = Logger.getLogger(ReminderNoteEditPanel.class);

    public ReminderNoteEditPanel(MVCController theParentController, ComposeMode composeMode, boolean isModify) {
        super(theParentController, "ATTACHLIST_SPLITPOS_REMNOTE_EDIT", composeMode, isModify);
        this.focusTraversalPolicy = new ReminderFocusPolicy();
    }

    protected ItemEditPanelController createController(MVCController parentController) {
        return new ItemEditPanelController<ReminderNoteEditPanel>(this, parentController);
    }

    public AbstractItem getGWItemComposition() {
        ReminderNote reminderNote = (ReminderNote)this.newItem;
        reminderNote.setSubject(this.tfSubject.getText());
        Date[] dates = GWCalendarUtils.CalendarToDate(this.rsStartDate.getDates());
        reminderNote.setStartDates(dates);
        reminderNote.setEndDate(dates[0]);
        return super.getGWItemComposition();
    }

    public void setGWItemComposition(AbstractItem theNewItem) {
        Calendar[] startDates;
        super.setGWItemComposition(theNewItem);
        ReminderNote reminderNote = (ReminderNote)this.newItem;
        this.tfCC.setRecipients(reminderNote.getCcRecipients());
        this.tfTo.setRecipients(reminderNote.getToRecipients());
        this.tfBC.setRecipients(reminderNote.getBcRecipients());
        for (Calendar dateToFix : startDates = GWCalendarUtils.DateToCalendar(reminderNote.getStartDates())) {
            GWCalendarUtils.clearTime(dateToFix);
        }
        this.rsStartDate.setDates(startDates);
        this.tfSubject.setText(reminderNote.getSubject());
    }

    protected void build() {
        super.build();
        this.contentPanel.setLayout(new BorderLayout());
        this.rsStartDate = new RecuringDateSelector();
        this.rsStartDate.addRecuringDateChangeListener(this);
        this.compFrom = new FromComponent(this);
        this.lbCC = new JMnemonicLabel(StringResources.CC_C, this.tfCC);
        this.lbTo = new JMnemonicLabel(StringResources.TO_C, this.tfTo);
        this.lbBC = new JMnemonicLabel(StringResources.BC_C, this.tfBC);
        this.lbStartDate = new JMnemonicLabel(StringResources.START_DATE_C, (Component)this.rsStartDate.getTextComponent());
        this.lbSubject = new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject);
        OrientablePanel messagePanel = new OrientablePanel(new BorderLayout());
        messagePanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        messagePanel.add((Component)this.messageEditor, "Center");
        OrientablePanel attachmentsPanel = new OrientablePanel(new BorderLayout());
        attachmentsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        attachmentsPanel.add((Component)this.attachmentList, "Center");
        this.messageSplit.setBottomComponent(attachmentsPanel);
        this.messageSplit.setTopComponent(messagePanel);
        this.buildAddressPane();
        this.contentPanel.add((Component)this.addressPane, "North");
        this.contentPanel.add((Component)this.messageSplit, "Center");
    }

    private void buildAddressPane() {
        this.addressPane = new OrientablePanel(new GridBagLayout());
        this.addressPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 8, 10);
        this.addressPane.add((Component)this.compFrom, c);
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.tfFrom, c);
        c.fill = 0;
        c.gridx = 2;
        c.insets = new Insets(0, 15, 8, 25);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbCC, c);
        c.fill = 2;
        c.gridx = 3;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcCC, c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbTo, c);
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcTo, c);
        c.fill = 0;
        c.gridx = 2;
        c.insets = new Insets(0, 15, 8, 25);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbBC, c);
        c.fill = 2;
        c.gridx = 3;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcBC, c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbStartDate, c);
        c.fill = 2;
        c.insets = new Insets(0, 0, 8, 0);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.createEditableTextComponent(this.rsStartDate), c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 10);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbSubject, c);
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 1;
        c.gridwidth = 0;
        this.addressPane.add((Component)this.createEditableTextComponent(this.tfSubject), c);
    }

    public void setAccessRights(FolderSharedEntry sharedEntry, boolean itemExists) {
        boolean hasEditAccess = sharedEntry.getAccessRights().hasEditAccess();
        if (itemExists) {
            this.tfSubject.setEditable(hasEditAccess);
            this.messageEditor.setEditable(hasEditAccess);
            ((ExtendedDateTextField)this.rsStartDate.getTextComponent()).setEditable(hasEditAccess);
        }
    }

    public void valueChanged(RecuringDateChangeEvent event) {
        if (event.isRecuring()) {
            this.lbStartDate.setText(StringResources.AUTO_DATE_C);
        } else {
            this.lbStartDate.setText(StringResources.START_DATE_C);
        }
        super.valueChanged(event);
    }

    private class ReminderFocusPolicy
    extends ItemEditPanel.ItemComposerTraversalPolicy {
        private ReminderFocusPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component component) {
            ReminderNoteEditPanel view = ReminderNoteEditPanel.this;
            Component focusOwner = FocusManager.getCurrentManager().getPermanentFocusOwner();
            if (!component.hasFocus()) {
                return focusOwner;
            }
            if (component.equals(view.tfTo) || component.equals(view.tfTo.getRecipientList())) {
                return view.rsStartDate.getTextComponent();
            }
            if (component.equals(view.tfSubject)) {
                return view.messageEditor.getComponent();
            }
            if (component.equals(ReminderNoteEditPanel.this.messageEditor.getComponent())) {
                return view.attachmentList.getListContent();
            }
            if (component.equals(view.tfCC) || component.equals(view.tfCC.getRecipientList())) {
                return view.tfBC;
            }
            if (component.equals(view.tfBC) || component.equals(view.tfBC.getRecipientList())) {
                return view.tfTo;
            }
            return super.getComponentAfter(focusCycleRoot, component);
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            ReminderNoteEditPanel view = ReminderNoteEditPanel.this;
            if (aComponent.equals(view.tfTo)) {
                return view.tfBC;
            }
            if (aComponent.equals(view.tfBC)) {
                return view.tfCC;
            }
            if (aComponent.equals(view.rsStartDate.getTextComponent())) {
                return this.isPostedCompose ? view.attachmentList.getListContent() : view.tfTo;
            }
            if (ControlsUtils.isComponentInContainer(view.attachmentList, aComponent)) {
                return view.messageEditor.getComponent();
            }
            return super.getComponentBefore(focusCycleRoot, aComponent);
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return ReminderNoteEditPanel.this.getComponentForFocus();
        }
    }
}

