/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level01;

import com.novell.gw.jclient.api.interfaces.IColumnAndSortInfo;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableColumn;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableDetailsColumn;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTable_Level01;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListTableColumnModel_Level01<T extends ItemListTable_Level01>
extends DefaultTableColumnModel {
    private static final Logger logger = Logger.getLogger(ItemListTableColumnModel_Level01.class);
    private IColumnFieldInfo[] columnFieldInfos;
    private IColumnFieldInfo sortedColumnFieldInfo;
    private final T table;

    public ItemListTableColumnModel_Level01(T table) {
        this.table = table;
    }

    public ItemListTableColumnModel_Level01(T table, IColumnAndSortInfo columnAndSortInfo) {
        this(table);
        this.setColumnAndSortInfo(columnAndSortInfo);
    }

    public void refreshColumns() {
        this.removeAllColumns();
        this.createColumnsForColumnInfo();
    }

    public void setColumnAndSortInfo(IColumnAndSortInfo columnAndSortInfo) {
        if (columnAndSortInfo == null) {
            this.setColumnFieldInfos(null);
            this.setSortedColumnFieldInfo(null);
        } else {
            this.setColumnFieldInfos(columnAndSortInfo.getVisibleColumns());
            this.setSortedColumnFieldInfo(columnAndSortInfo.getSortField());
        }
        this.refreshColumns();
    }

    public IColumnFieldInfo getColumnFieldInfoForColumn(int columnIndex) {
        ItemListTableColumn column = this.getColumn(columnIndex);
        if (column instanceof ItemListTableDetailsColumn) {
            return ((ItemListTableDetailsColumn)column).getColumnFieldInfo();
        }
        return null;
    }

    protected void removeAllColumns() {
        while (this.getColumnCount() > 0) {
            this.removeColumn(this.getColumn(0));
        }
    }

    protected void createColumnsForColumnInfo() {
        if (this.columnFieldInfos != null) {
            for (IColumnFieldInfo columnFieldInfo : this.columnFieldInfos) {
                this.addColumn(this.createDefaultTableColumn(this.getColumnCount(), columnFieldInfo));
            }
        }
    }

    @Override
    public int getColumnMargin() {
        return 0;
    }

    public int getEmptyColumnsCount() {
        return 0;
    }

    protected void setEmptyColumnsCount(int emptyColumns) {
    }

    protected TableColumn createDefaultTableColumn(int modelIndex, IColumnFieldInfo columnFieldInfo) {
        return new ItemListTableDetailsColumn(modelIndex, columnFieldInfo);
    }

    @Override
    public ItemListTableColumn getColumn(int columnIndex) {
        return (ItemListTableColumn)super.getColumn(columnIndex);
    }

    @Override
    public void addColumn(TableColumn column) {
        if (!(column instanceof ItemListTableColumn)) {
            throw new IllegalArgumentException();
        }
        super.addColumn(column);
    }

    public T getTable() {
        return this.table;
    }

    public IColumnFieldInfo[] getColumnsFieldInfos() {
        return this.columnFieldInfos;
    }

    public IColumnFieldInfo getSortedColumnFieldInfo() {
        return this.sortedColumnFieldInfo;
    }

    public void setColumnFieldInfos(IColumnFieldInfo[] columnFieldInfos) {
        this.columnFieldInfos = columnFieldInfos;
    }

    public void setSortedColumnFieldInfo(IColumnFieldInfo sortedColumnFieldInfo) {
        this.sortedColumnFieldInfo = sortedColumnFieldInfo;
    }
}

