/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level01;

import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.jclient.api.interfaces.IGroupHeader;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnsUtils;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableColumn;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableDetailsColumn;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTable_Level01;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListTableModel_Level01<T extends ItemListTable_Level01>
extends AbstractTableModel
implements IItemListListener {
    private final IItemList itemList;
    private final T table;
    private final IFolder folder;
    private static final Logger logger = Logger.getLogger(ItemListTableModel_Level01.class);

    public ItemListTableModel_Level01(T table, IFolder folder, IItemList itemList) {
        this.itemList = itemList;
        this.table = table;
        this.folder = folder;
        this.init();
    }

    private void init() {
        if (this.hasItemList()) {
            this.getItemList().addItemListListener(this);
        }
    }

    public ItemListTableModel_Level01(T table) {
        this(table, null, null);
    }

    @Override
    public int getRowCount() {
        if (this.itemList == null) {
            return 0;
        }
        return this.itemList.getSize();
    }

    @Override
    public int getColumnCount() {
        return ((JTable)this.table).getColumnCount();
    }

    public int getColumnFieldID(int columnIndex) {
        int fieldID = -1;
        ItemListTableColumn column = ((ItemListTable_Level01)this.getTable()).getColumnModel().getColumn(columnIndex);
        if (column instanceof ItemListTableDetailsColumn) {
            return TableColumnsUtils.getColumnFieldID(((ItemListTableDetailsColumn)column).getColumnFieldInfo(), ((ItemListTable_Level01)this.getTable()).isContacts());
        }
        return fieldID;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            // empty if block
        }
        IItem item = this.itemList.getItemAt(rowIndex);
        int fieldID = this.getColumnFieldID(columnIndex);
        if (fieldID != -1) {
            if (item instanceof IMessage) {
                return ((IMessage)item).getValue(fieldID, this.getFolder());
            }
            if (item instanceof IContact) {
                return ((IContact)item).getStringValue(fieldID);
            }
            if (item instanceof IFolder && columnIndex == ((ItemListTable_Level01)this.getTable()).getFirstColumn()) {
                return ((IFolder)item).getName();
            }
            if (item instanceof IGroupHeader && columnIndex == ((ItemListTable_Level01)this.getTable()).getFirstColumn()) {
                int sortedFieldID = ((ItemListTable_Level01)this.getTable()).getColumnModel().getSortedColumnFieldInfo().getFieldID();
                return ((IGroupHeader)item).getValue(sortedFieldID, this.getFolder());
            }
        }
        return "";
    }

    public T getTable() {
        return this.table;
    }

    public IFolder getFolder() {
        return this.folder;
    }

    public IItemList getItemList() {
        if (this.itemList == null) {
            throw new IllegalStateException();
        }
        return this.itemList;
    }

    public boolean hasItemList() {
        return this.itemList != null;
    }

    public void dispose() {
        if (this.hasItemList()) {
            this.getItemList().removeItemListListener(this);
        }
    }

    public void contentsChanged(ItemListEvent e) {
        logger.debug((Object)("e: " + e));
        if (e.getSource() instanceof ItemList) {
            this.printLogs(e);
            T table = this.getTable();
            int type = e.getType();
            if (type == 5) {
                int selectedRow = ((JTable)this.getTable()).getSelectedRow();
                if (selectedRow != -1) {
                    int rowCount = this.getRowCount();
                    if (selectedRow >= rowCount) {
                        selectedRow = rowCount - 1;
                    }
                    this.fireTableDataChanged();
                    ((JTable)table).getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                    ((ItemListTable_Level01)table).scrollToSelection();
                } else {
                    this.fireTableDataChanged();
                }
            } else {
                this.fireTableDataChanged();
                if (type == 7) {
                    logger.debug((Object)"-----------");
                    ((ItemListTable_Level01)table).restoreSelection();
                    ((ItemListTable_Level01)table).scrollToSelection();
                }
            }
        }
    }

    public void moreResultsAvailable(ItemListEvent e) {
        logger.debug((Object)("e: " + e));
    }

    public void notifyEmptyList(ItemListEvent e) {
        logger.debug((Object)("e: " + e));
    }

    public void queryResultsDone(ItemListEvent e) {
        logger.debug((Object)("e: " + e));
    }

    private void printLogs(ItemListEvent event) {
        logger.debug((Object)("event: " + event));
        int type = event.getType();
        if (type == 0) {
            logger.debug((Object)"CONTENTS_CHANGED");
        } else if (type == 1) {
            logger.debug((Object)"MORE_RESULTS_AVAILABLE");
        } else if (type == 2) {
            logger.debug((Object)"QUERY_RESULTS_DONE");
        } else if (type == 3) {
            logger.debug((Object)"ITEM_INSERTED");
        } else if (type == 4) {
            logger.debug((Object)"ITEM_MODIFIED");
        } else if (type == 5) {
            logger.debug((Object)"ITEM_REMOVED");
        } else if (type == 6) {
            logger.debug((Object)"UPDATE_ITEM_COUNT");
        } else if (type == 7) {
            logger.debug((Object)"RANGE_INVALIDATED");
        } else if (type == 8) {
            logger.debug((Object)"NOTIFY_EMPTY_LIST");
        } else if (type == 9) {
            logger.debug((Object)"NOTIFY_DELETE_ALL_ITEMS");
        }
    }
}

