/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level01;

import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableColumnModel_Level01;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableHeader;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableListSelectionModel;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableModel_Level01;
import com.novell.gw.jclient.application.controls.orientable.OrientableTable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import org.apache.log4j.Logger;

public class ItemListTable_Level01
extends OrientableTable {
    private static final Logger logger = Logger.getLogger(ItemListTable_Level01.class);
    private final IViewDisplaySettings viewDisplaySettings;
    private final IFolder folder;
    private IItem[] lastSelectedItems;
    private int defaultRowHeight = -1;
    private boolean valueIsAdjusting = false;

    public ItemListTable_Level01(IFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList) {
        this.setAutoCreateColumnsFromModel(false);
        this.setRowMargin(0);
        this.getActionMap().put("selectNextRow", new SelectAction(true));
        this.getActionMap().put("selectPreviousRow", new SelectAction(false));
        this.viewDisplaySettings = viewDisplaySettings;
        this.folder = folder;
        this.setData(itemList);
    }

    protected ItemListTableListSelectionModel createDefaultSelectionModel() {
        return new ItemListTableListSelectionModel<ItemListTable_Level01>(this);
    }

    public void updateUI() {
        super.updateUI();
        if (this.defaultRowHeight <= 0) {
            this.defaultRowHeight = (int)((double)this.getFontMetrics(this.getFont()).getHeight() * 1.3);
        }
        this.setRowHeight(this.defaultRowHeight);
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setData(IItemList itemList) {
        IItem[] items = this.getLastSelectedItems();
        this.getColumnModel().setColumnAndSortInfo(this.getViewDisplaySettings().getColumnAndSortInfo());
        this.setModel(this.createDefaultDataModel(this.getFolder(), itemList));
        this.updateUI();
        if (items != null && items.length > 0) {
            this.selectItems(items);
            this.scrollToSelection();
        }
    }

    public IItem[] getSelectedItems() {
        int[] selectedRows = this.getSelectedRows();
        ArrayList<IItem> items = new ArrayList<IItem>();
        IItemList itemList = this.getItemList();
        for (int row : selectedRows) {
            if (row < 0 || row >= this.getRowCount()) continue;
            items.add(itemList.getItemAt(row));
        }
        return items.toArray(new IItem[items.size()]);
    }

    public void selectItems(IItem ... items) {
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        if (items != null && items.length > 0) {
            for (IItem item : items) {
                int index = this.getItemList().indexOf(item);
                if (index == -1) continue;
                this.getSelectionModel().addSelectionInterval(index, index);
            }
        }
        selectionModel.setValueIsAdjusting(false);
    }

    protected void setLastSelectedItems(IItem[] items) {
        this.lastSelectedItems = items;
    }

    public IItem[] getLastSelectedItems() {
        return this.lastSelectedItems;
    }

    public void restoreSelection() {
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        if (this.lastSelectedItems == null) {
            selectionModel.clearSelection();
        } else {
            for (IItem item : this.getLastSelectedItems()) {
                int index = this.getItemList().indexOf(item);
                if (index != -1) {
                    selectionModel.addSelectionInterval(index, index);
                    continue;
                }
                logger.debug((Object)("ItemList doesn't contain item: " + item));
            }
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public void scrollToSelection() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            this.scrollRowToVisible(selectedRow);
        }
    }

    @Deprecated
    public void scrollRectToVisible(Rectangle rectangle) {
        super.scrollRectToVisible(rectangle);
    }

    public void scrollRowToVisible(int row) {
        Rectangle cellRect = this.getCellRect(row, 0, true);
        Rectangle visibleRect = this.getVisibleRect();
        int min = visibleRect.y;
        int max = visibleRect.y + visibleRect.height;
        if (cellRect.y >= min && cellRect.y + cellRect.height <= max) {
            return;
        }
        this.scrollRectToVisible(cellRect);
    }

    public boolean isContacts() {
        return this.getFolder().isContactsFolder();
    }

    public void tableChanged(TableModelEvent e) {
        this.setValueIsAdjusting(true);
        super.tableChanged(e);
        this.setValueIsAdjusting(false);
        this.restoreSelection();
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.setRowHeight(i, rowHeight);
        }
    }

    public int getFirstColumn() {
        return 0;
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (!e.getValueIsAdjusting()) {
            IItem[] selectedItems = this.getSelectedItems();
            if (e.getFirstIndex() != -1) {
                this.setLastSelectedItems(selectedItems);
            }
        }
    }

    void setSelectionToItemList(IItem[] items) {
        ArrayList<IItem> correctItems = new ArrayList<IItem>();
        for (IItem item : items) {
            if (!this.isDataItem(item)) continue;
            correctItems.add(item);
        }
        this.getItemList().setSelection(correctItems.toArray(new IItem[correctItems.size()]));
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
        ListSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            selectionModel.setValueIsAdjusting(valueIsAdjusting);
        }
    }

    public IItemList getItemList() {
        return this.getModel().getItemList();
    }

    public IFolder getFolder() {
        return this.folder;
    }

    public boolean isDataItem(IItem item) {
        return item instanceof IFolder || item instanceof IContact || item instanceof IMessage && !((IMessage)item).isChecklistDummyItem();
    }

    public IViewDisplaySettings getViewDisplaySettings() {
        return this.viewDisplaySettings;
    }

    public ItemListTableModel_Level01 getModel() {
        return (ItemListTableModel_Level01)super.getModel();
    }

    protected ItemListTableColumnModel_Level01 createDefaultColumnModel() {
        return new ItemListTableColumnModel_Level01<ItemListTable_Level01>(this);
    }

    protected ItemListTableModel_Level01 createDefaultDataModel() {
        return new ItemListTableModel_Level01<ItemListTable_Level01>(this);
    }

    protected ItemListTableModel_Level01 createDefaultDataModel(IFolder folder, IItemList itemList) {
        return new ItemListTableModel_Level01<ItemListTable_Level01>(this, folder, itemList);
    }

    protected ItemListTableHeader createDefaultTableHeader() {
        return new ItemListTableHeader<ItemListTable_Level01>(this);
    }

    public ItemListTableColumnModel_Level01 getColumnModel() {
        return (ItemListTableColumnModel_Level01)super.getColumnModel();
    }

    public void createDefaultColumnsFromModel() {
    }

    public void dispose() {
        this.getModel().dispose();
    }

    private class SelectAction
    extends AbstractAction {
        private final boolean selectNext;

        public SelectAction(boolean selectNext) {
            this.selectNext = selectNext;
        }

        public void actionPerformed(ActionEvent e) {
            if (ItemListTable_Level01.this.getRowCount() > 0) {
                int selectedRow = ItemListTable_Level01.this.getSelectedRow();
                if (selectedRow == -1) {
                    selectedRow = 0;
                }
                do {
                    selectedRow = this.selectNext ? ++selectedRow : --selectedRow;
                    if (selectedRow >= 0 && selectedRow < ItemListTable_Level01.this.getRowCount()) continue;
                    return;
                } while (!ItemListTable_Level01.this.isDataItem(ItemListTable_Level01.this.getItemList().getItemAt(selectedRow)));
                ItemListTable_Level01.this.changeSelection(selectedRow, ItemListTable_Level01.this.getSelectedColumn(), false, false);
            }
        }
    }
}

