/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level02;

import com.appframework.drag.DragManager;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTable_Level01;
import com.novell.gw.jclient.application.controls.itemlisttable.level02.ItemListTable_Level02;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.dnd.TransferableWrapper;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListTableTransferHandler<T extends ItemListTable_Level02>
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(ItemListTableTransferHandler.class);
    private final T table;

    public ItemListTableTransferHandler(T table) {
        this.table = table;
    }

    public T getTable() {
        return this.table;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        T table = this.getTable();
        for (IItem item : ((ItemListTable_Level01)table).getSelectedItems()) {
            if (!this.canExportItem(item)) continue;
            super.exportAsDrag(comp, e, action);
            break;
        }
    }

    protected boolean canExportItem(IItem item) {
        return item instanceof IFolder || item instanceof IContact || item instanceof IMessage && !((IMessage)item).isChecklistDummyItem();
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        IItem item;
        logger.debug((Object)"createTransferable");
        T table = this.getTable();
        boolean isDocumentsTransfer = ((ItemListTable_Level01)table).getFolder().getType() == FolderType.DOCUMENTS;
        boolean isFoldersOnly = true;
        for (IItem item2 : ((ItemListTable_Level01)table).getSelectedItems()) {
            if (item2 instanceof IFolder) continue;
            isFoldersOnly = false;
            break;
        }
        String userGuid = ControlsUtils.getUserGuid(table);
        AbstractFolder folder = EngineCommandManager.getInstance(userGuid).getGWFolder(((ItemListTable_Level01)table).getFolder());
        int[] indices = ((JTable)table).getSelectedRows();
        ArrayList<Integer> correctIndices = new ArrayList<Integer>();
        IItemList itemList = ((ItemListTable_Level01)table).getItemList();
        int[] arr$ = indices;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer index = arr$[i$];
            if (!((ItemListTable_Level01)table).isDataItem(itemList.getItemAt(index))) continue;
            correctIndices.add(index);
        }
        int size = correctIndices.size();
        indices = new int[size];
        for (int i = 0; i < size; ++i) {
            indices[i] = (Integer)correctIndices.get(i);
        }
        if (indices != null && indices.length == 1 && (item = itemList.getItemAt(indices[0])) instanceof IMessage) {
            try {
                AbstractItem abstractItem = EngineCommandManager.getInstance(userGuid).getItem(itemList, (IMessage)item);
                DragManager.getInstance().setItem(abstractItem);
            }
            catch (GWCommandException e) {
                logger.error((Object)e);
            }
        }
        return new TransferableWrapper(itemList, indices, isDocumentsTransfer, isFoldersOnly, userGuid, ((ItemListTable_Level01)table).getViewDisplaySettings(), folder);
    }
}

