/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level03;

import com.novell.gw.jclient.application.controls.itemlisttable.level03.ItemListTable_Level03;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class SortableTableHeaderUI
extends BasicTableHeaderUI {
    private static final Logger logger = Logger.getLogger(SortableTableHeaderUI.class);

    public static SortableTableHeaderUI createUI(JComponent c) {
        return new SortableTableHeaderUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new BasicTableHeaderUI.MouseInputHandler(){
            private TableColumn column;
            private Cursor deleteColumnCursor;
            private Cursor tempCursor;
            {
                this.tempCursor = this.deleteColumnCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.getDeleteCursorImageFromResources(), new Point(), "delete column");
            }

            private Image getDeleteCursorImageFromResources() {
                Image cursorImage = Toolkit.getDefaultToolkit().getMaximumCursorColors() > 2 ? ImageResources.COLUMN_DELETE.getImage() : ImageResources.COLUMN_DELETE_BLACK_AND_WHITE.getImage();
                return cursorImage;
            }

            private Window getWindow() {
                return SwingUtilities.getWindowAncestor(SortableTableHeaderUI.this.header.getTable());
            }

            public void mousePressed(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    super.mousePressed(e);
                } else {
                    SortableTableHeaderUI.this.header.setDraggedColumn(null);
                    SortableTableHeaderUI.this.header.setResizingColumn(null);
                    SortableTableHeaderUI.this.header.setDraggedDistance(0);
                }
            }

            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                Window window = this.getWindow();
                if (window != null && SortableTableHeaderUI.this.header.getDraggedColumn() != null) {
                    this.column = SortableTableHeaderUI.this.header.getDraggedColumn();
                    Cursor cursor = window.getCursor();
                    if (this.removeColumn(e) && cursor != this.deleteColumnCursor) {
                        this.swapCursor();
                    } else if (!this.removeColumn(e) && cursor == this.deleteColumnCursor) {
                        this.swapCursor();
                    }
                }
            }

            private void swapCursor() {
                Window window = this.getWindow();
                Cursor tmp = window.getCursor();
                window.setCursor(this.tempCursor);
                this.tempCursor = tmp;
            }

            protected boolean removeColumn(MouseEvent event) {
                int height;
                int y = event.getY();
                return (y > (height = SortableTableHeaderUI.this.header.getHeight()) * 2 || -y > height) && SortableTableHeaderUI.this.header.getColumnModel().getColumnCount() > 2;
            }

            private void saveChanges() {
                JTable table = SortableTableHeaderUI.this.header.getTable();
                if (table instanceof ItemListTable_Level03) {
                    ItemListTable_Level03 itemListTable = (ItemListTable_Level03)table;
                    itemListTable.saveColumnsPositions();
                    itemListTable.refreshColumnsPositions(itemListTable.getViewDisplaySettings());
                }
            }

            public void mouseReleased(MouseEvent e) {
                boolean hasChanges;
                Window window = this.getWindow();
                boolean bl = hasChanges = SortableTableHeaderUI.this.header.getResizingColumn() != null || SortableTableHeaderUI.this.header.getDraggedColumn() != null;
                if (window != null && this.removeColumn(e) && this.column != null) {
                    SortableTableHeaderUI.this.header.getColumnModel().removeColumn(this.column);
                    SortableTableHeaderUI.this.header.setResizingColumn(null);
                    SortableTableHeaderUI.this.header.setDraggedColumn(null);
                    this.column = null;
                } else {
                    super.mouseReleased(e);
                }
                if (hasChanges) {
                    this.saveChanges();
                }
                if (window != null && window.getCursor() == this.deleteColumnCursor) {
                    this.swapCursor();
                }
            }
        };
    }
}

