/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level07;

import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.interfaces.IGroupHeader;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnType;
import com.novell.gw.jclient.application.controls.itemlisttable.level05.ItemListTableModel_Level05;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.EmptyTask;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.ItemListTable_Level07;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.TypingTaskItemListImpl;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.collapsable.CollapsableItem;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListTableModel_Level07<T extends ItemListTable_Level07>
extends ItemListTableModel_Level05<T> {
    private static final Logger logger = Logger.getLogger(ItemListTableModel_Level07.class);

    public ItemListTableModel_Level07(T table) {
        this(table, null, null);
    }

    public ItemListTableModel_Level07(T table, IFolder folder, IItemList itemList) {
        super(table, folder, itemList);
    }

    public boolean isChecklistDummyItem(int row) {
        IItem item = this.getItemList().getItemAt(row);
        return item instanceof IMessage && ((IMessage)item).isChecklistDummyItem();
    }

    public boolean isTypingTaskItem(int row) {
        IItem item = this.getItemList().getItemAt(row);
        return item instanceof EmptyTask;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.hasItemList() || columnIndex >= this.getColumnCount()) {
            return null;
        }
        IItem item = this.getItemList().getItemAt(rowIndex);
        TableColumnType columnType = ((ItemListTable_Level07)this.getTable()).getColumnModel().getColumn(columnIndex).getColumnType();
        if (item instanceof IGroupHeader && (columnType == TableColumnType.COLUMN_GROUP_HEADER || columnType == TableColumnType.COLUMN_TASK_LIST)) {
            return new CollapsableItem(item, this.getItemList());
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (value != null) {
            if (value instanceof Boolean) {
                this.setBooleanAt((Boolean)value, rowIndex, columnIndex);
            } else if (value instanceof String) {
                this.setStringAt((String)value, rowIndex, columnIndex);
            }
        }
        super.setValueAt(value, rowIndex, columnIndex);
    }

    protected void setBooleanAt(boolean value, int rowIndex, int columnIndex) {
        IItem item = this.getItemList().getItemAt(rowIndex);
        if (item instanceof IMessage) {
            IMessage message = (IMessage)item;
            try {
                message.markComplete(value);
            }
            catch (EngineException e) {
                logger.error((Object)e);
            }
        }
    }

    protected void setStringAt(String value, int rowIndex, int columnIndex) {
        IItemList itemList = this.getItemList();
        if (itemList instanceof TypingTaskItemListImpl) {
            if (value.equals("")) {
                ((ItemListTable_Level07)this.getTable()).stopCreatingQuickTask();
            } else {
                logger.debug((Object)("createChecklistItem(value: " + value + ", newItemIndex: " + rowIndex + ")"));
                itemList.createChecklistItem(value, rowIndex);
            }
        }
    }
}

