/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level07;

import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnType;
import com.novell.gw.jclient.application.controls.itemlisttable.level06.ItemListTable_Level06;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.EmptyTask;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.ItemListTableColumnModel_Level07;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.ItemListTableModel_Level07;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.TypingTaskItemListImpl;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.ChecklistDummyItemCellRenderer;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.TextCellEditor;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.category.CategoryIconCell;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.checkbox.ItemListTableCheckBoxCellEditor;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.checkbox.ItemListTableCheckBoxCellRenderer;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.collapsable.Collapsable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class ItemListTable_Level07
extends ItemListTable_Level06
implements KeyListener {
    private static final Logger logger = Logger.getLogger(ItemListTable_Level07.class);
    protected static final TableCellEditor CHECK_BOX_CELL_EDITOR = new ItemListTableCheckBoxCellEditor();
    protected static final TableCellRenderer CHECK_BOX_CELL_RENDERER = new ItemListTableCheckBoxCellRenderer();
    protected static final TableCellRenderer CHECKLIST_DUMMY_ITEM_RENDERER = new ChecklistDummyItemCellRenderer();
    protected static final TableCellEditor TASKLIST_TEXT_EDITOR = new TextCellEditor();

    public ItemListTable_Level07(IFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList) {
        super(folder, viewDisplaySettings, itemList);
        this.addKeyListener(this);
    }

    public boolean isTasklistView() {
        IViewDisplaySettings viewDisplaySettings = this.getViewDisplaySettings();
        return viewDisplaySettings != null && viewDisplaySettings.getViewMode() == 7;
    }

    public void setData(IItemList itemList) {
        if (this.getViewDisplaySettings().getViewMode() == 7) {
            itemList = new TypingTaskItemListImpl(itemList, this.getSelectionModel());
        }
        super.setData(itemList);
    }

    protected boolean isLongCell(int row, int column) {
        int columnCount = this.getColumnCount() - this.getLastEmptyColumnsCount();
        ItemListTableModel_Level07 model = this.getModel();
        if (row != -1 && column >= this.getFirstColumn() && column < columnCount && (model.isChecklistDummyItem(row) || model.isTypingTaskItem(row))) {
            return true;
        }
        return super.isLongCell(row, column);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        return this.canEditCell(row, column) && super.editCellAt(row, column, e);
    }

    private boolean canEditCell(int row, int column) {
        return !this.isCreatingQuickTask() || !this.isCellEditable(row, column) || !(this.getCellRenderer(row, column) instanceof CategoryIconCell);
    }

    public boolean editCellAt(int row, int column) {
        return this.canEditCell(row, column) && super.editCellAt(row, column);
    }

    public void editingCanceled(ChangeEvent e) {
        logger.debug((Object)"editingCanceled");
        super.editingCanceled(e);
        if (this.isCreatingQuickTask()) {
            TypingTaskItemListImpl itemList = (TypingTaskItemListImpl)this.getItemList();
            itemList.deleteEmptyTask();
            this.getModel().fireTableDataChanged();
        }
    }

    public boolean isCellEditable(int row, int column) {
        TableColumnType columnType = this.getColumnModel().getColumn(column).getColumnType();
        Object value = this.getValueAt(row, column);
        if (this.getModel().isChecklistDummyItem(row)) {
            return false;
        }
        if (columnType == TableColumnType.COLUMN_TASK_LIST) {
            return value instanceof IMessage && ((IMessage)value).isInChecklist() || value instanceof Collapsable || super.isCellEditable(row, column);
        }
        return this.getModel().isTypingTaskItem(row) || super.isCellEditable(row, column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        Object value = this.getValueAt(row, column);
        TableColumnType columnType = this.getColumnModel().getColumn(column).getColumnType();
        if (this.getModel().isChecklistDummyItem(row)) {
            if (columnType == TableColumnType.COLUMN_DETAILS) {
                return CHECKLIST_DUMMY_ITEM_RENDERER;
            }
            return EMPTY_CELL_RENDERER;
        }
        if (columnType == TableColumnType.COLUMN_TASK_LIST) {
            if (value instanceof IMessage && ((IMessage)value).isInChecklist()) {
                return CHECK_BOX_CELL_RENDERER;
            }
            if (value instanceof Collapsable) {
                return COLLAPSABLE_CELL;
            }
            return EMPTY_CELL_RENDERER;
        }
        return super.getCellRenderer(row, column);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Object value = this.getValueAt(row, column);
        TableColumnType columnType = this.getColumnModel().getColumn(column).getColumnType();
        if (columnType == TableColumnType.COLUMN_TASK_LIST) {
            if (value instanceof IMessage && ((IMessage)value).isInChecklist()) {
                return CHECK_BOX_CELL_EDITOR;
            }
            if (value instanceof Collapsable) {
                return COLLAPSABLE_CELL;
            }
        }
        if (this.getModel().isTypingTaskItem(row)) {
            return TASKLIST_TEXT_EDITOR;
        }
        return super.getCellEditor(row, column);
    }

    protected ItemListTableModel_Level07 createDefaultDataModel() {
        return new ItemListTableModel_Level07<ItemListTable_Level07>(this);
    }

    protected ItemListTableModel_Level07 createDefaultDataModel(IFolder folder, IItemList itemList) {
        return new ItemListTableModel_Level07<ItemListTable_Level07>(this, folder, itemList);
    }

    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof ItemListTableModel_Level07)) {
            throw new IllegalArgumentException();
        }
        super.setModel(dataModel);
    }

    public ItemListTableModel_Level07 getModel() {
        return (ItemListTableModel_Level07)super.getModel();
    }

    protected ItemListTableColumnModel_Level07 createDefaultColumnModel() {
        return new ItemListTableColumnModel_Level07<ItemListTable_Level07>(this);
    }

    public ItemListTableColumnModel_Level07 getColumnModel() {
        return (ItemListTableColumnModel_Level07)super.getColumnModel();
    }

    public boolean isDataItem(IItem item) {
        return !(item instanceof EmptyTask) && super.isDataItem(item);
    }

    public boolean isCreatingQuickTask() {
        IItemList itemList = this.getItemList();
        return itemList instanceof TypingTaskItemListImpl && ((TypingTaskItemListImpl)itemList).hasEmptyTask();
    }

    public void stopCreatingQuickTask() {
        logger.debug((Object)"stopCreatingQuickTask");
        if (this.isCreatingQuickTask()) {
            ((TypingTaskItemListImpl)this.getItemList()).deleteEmptyTask();
            this.getModel().fireTableDataChanged();
        }
    }

    public boolean startCreatingQuickTask() {
        IItemList itemList = this.getItemList();
        if (itemList instanceof TypingTaskItemListImpl && !this.isCreatingQuickTask()) {
            int selectedRow;
            logger.debug((Object)"startCreatingQuickTask");
            int taskRow = selectedRow = this.getSelectedRow();
            boolean createSubTask = false;
            int lastUncompletedChecklistItemIndex = itemList.findLastUncompletedChecklistItemIndex();
            if (selectedRow > lastUncompletedChecklistItemIndex) {
                taskRow = lastUncompletedChecklistItemIndex;
            }
            int rowCount = this.getRowCount();
            while (taskRow + 1 < rowCount && itemList.getItemAt(taskRow + 1) instanceof IFolder) {
                ++taskRow;
            }
            if (taskRow + 1 < this.getRowCount()) {
                createSubTask = this.getItemList().getThreadDepthAt(taskRow) < this.getItemList().getThreadDepthAt(taskRow + 1);
            }
            return this.startCreatingQuickTask(createSubTask, taskRow);
        }
        return false;
    }

    public boolean startCreatingQuickTask(boolean subtask, int row) {
        IItemList itemList = this.getItemList();
        if (itemList instanceof TypingTaskItemListImpl) {
            TypingTaskItemListImpl taskItemList = (TypingTaskItemListImpl)itemList;
            if (!this.isCreatingQuickTask()) {
                int lastUncompletedChecklistItemIndex = itemList.findLastUncompletedChecklistItemIndex();
                if (row > lastUncompletedChecklistItemIndex) {
                    row = lastUncompletedChecklistItemIndex;
                }
                int threadDepth = itemList.getThreadDepthAt(row);
                if (row >= 0) {
                    IItem item = itemList.getItemAt(row);
                    if (!(item instanceof IMessage) || !((IMessage)item).isChecklistDummyItem()) {
                        ++row;
                    }
                } else {
                    ++row;
                }
                if (subtask && itemList.canCreateChecklistSubItemAt(row - 1)) {
                    taskItemList.createEmptyTask(row, ++threadDepth);
                } else if (itemList.canCreateChecklistItem()) {
                    taskItemList.createEmptyTask(row, threadDepth);
                }
                if (taskItemList.hasEmptyTask()) {
                    this.getModel().fireTableDataChanged();
                    if (row > 0 && row < this.getRowCount()) {
                        this.getSelectionModel().setSelectionInterval(row - 1, row - 1);
                        this.scrollRowToVisible(row);
                    }
                    return this.editCellAt(row, this.getFirstColumn());
                }
            }
        }
        return false;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.isTasklistView() && !e.isConsumed()) {
            if (this.isCreatingQuickTask()) {
                int keyCode;
                if (e.isActionKey()) {
                    e.consume();
                }
                if ((keyCode = e.getKeyCode()) == 10) {
                    logger.debug((Object)"editingStopped");
                    this.editingStopped(null);
                } else if (keyCode == 27) {
                    logger.debug((Object)"editingCanceled");
                    this.editingCanceled(null);
                }
            } else {
                char keyChar = e.getKeyChar();
                if (!(e.isActionKey() || !Character.isDefined(keyChar) || Character.isISOControl(keyChar) || e.isAltDown() || e.isControlDown())) {
                    this.startCreatingQuickTask();
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

