/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.renderers;

import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.MessageSentItemStatus;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IGroupHeader;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTable_Level01;
import com.novell.gw.jclient.application.controls.itemlisttable.level10.ItemListTable_Level10;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class TableRendererUtils {
    public static final Color ITEM_LIST_TABLE_BACKGROUND = Color.WHITE;
    public static final Color ITEM_LIST_TABLE_FOREGROUND = Color.BLACK;
    public static final Color ITEM_LIST_TABLE_ALTERNATE_BACKGROUND = OS.isMacOS() ? new Color(237, 243, 254) : new Color(242, 242, 242);
    public static final Color ITEM_LIST_TABLE_ALTERNATE_SELECTION_BACKGROUND = new Color(255, 255, 230);
    public static final Color ITEM_LIST_TABLE_ALTERNATE_SELECTION_BACKGROUND_DARK = new Color(255, 255, 210);
    public static final Color ITEM_LIST_TABLE_ALTERNATE_SELECTION_FOREGROUND = Color.BLACK;
    public static final Color ITEM_LIST_TABLE_IGNORED_THREAD_COLOR = Color.LIGHT_GRAY;
    public static final Color TASK_ITEM_COLOR = Color.BLUE;
    public static final Color TASK_FAILED_COLOR = Color.RED;
    private static final int BORDER_THICKNESS = 1;
    public static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    public static Font getFont(IItemList itemList, IItem item, Font font) {
        if (item instanceof IMessage && itemList != null) {
            IMessage message = (IMessage)item;
            boolean isReaditem = message.isRead();
            if (isReaditem && itemList.isCollapsed(message)) {
                boolean bl = isReaditem = !itemList.hasUnreadItemInThread(message);
            }
            if (!isReaditem || message.getBoxType() == 2 && message.getSentItemStatus() == MessageSentItemStatus.PENDING && font.getStyle() != 1) {
                font = font.deriveFont(1);
            } else if (font.getStyle() != 1) {
                font = font.deriveFont(0);
            }
        } else if (item instanceof IGroupHeader && font.getStyle() != 1) {
            font = font.deriveFont(1);
        } else if (font.getStyle() != 0) {
            font = font.deriveFont(0);
        }
        return font;
    }

    public static void applyFontAndRenderingHints(JComponent target, JTable table, IItem item) {
        Font font = TableRendererUtils.getFont(table instanceof ItemListTable_Level01 ? ((ItemListTable_Level01)table).getItemList() : null, item, table.getFont());
        if (item instanceof IMessage) {
            TableRendererUtils.applyRenderingHintsForMessage(target, (IMessage)item, font);
        } else {
            target.setFont(font);
        }
    }

    private static void applyRenderingHintsForMessage(JComponent target, IMessage message, Font font) {
        boolean imapDeleted = message.isIMAPDeleted();
        if (OS.getJavaVersionMajor() == 1 && OS.getJavaVersionMinor() > 5 || OS.getJavaVersionMajor() > 1) {
            Hashtable<TextAttribute, Boolean> map = new Hashtable<TextAttribute, Boolean>();
            if (imapDeleted) {
                map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            } else {
                map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON == false);
            }
            font = font.deriveFont(map);
        } else {
            TableRendererUtils.setHTMLFormat(imapDeleted, target);
        }
        target.setFont(font);
    }

    public static Color getCategoryColor(ICategoryList categoryList, boolean isForeground) {
        ICategory category;
        if (categoryList != null && (category = categoryList.getPrimary()) != null) {
            if (isForeground) {
                return category.getTextColor();
            }
            return category.getBackgroundColor();
        }
        return null;
    }

    public static Color getCategoryColor(IItem item, boolean isForeground) {
        ICategoryList categoryList = null;
        if (item instanceof IMessage) {
            categoryList = ((IMessage)item).getCategories();
        } else if (item instanceof IContact) {
            categoryList = ((IContact)item).getCategories();
        }
        return TableRendererUtils.getCategoryColor(categoryList, isForeground);
    }

    public static String[] getSummaryValues(IMessage message, IFolder folder, IViewDisplaySettings viewDisplaySettings, JComponent component, int prefferedWidth) {
        ArrayList<String> strings = new ArrayList<String>();
        String value = message.getSummaryValue(2, folder, viewDisplaySettings);
        if (value != null && !value.equals("")) {
            int width;
            value = value.trim();
            value = value.replace("\n", " ");
            int CHARS_COUNT_LIMIT = 1000;
            if (value.length() > CHARS_COUNT_LIMIT) {
                value = value.substring(0, CHARS_COUNT_LIMIT);
            }
            if ((width = component.getFontMetrics(component.getFont()).stringWidth(value)) != 0) {
                if (width > prefferedWidth) {
                    float devider = (float)prefferedWidth / (float)width;
                    if ((double)devider >= 0.1) {
                        String firstLine = value.substring(0, (int)((float)value.length() * devider));
                        for (int i = firstLine.length() - 1; i > 0; --i) {
                            if (firstLine.charAt(i) != ' ') continue;
                            String tmp = firstLine.substring(0, i);
                            if (component.getFontMetrics(component.getFont()).stringWidth(tmp) > prefferedWidth) continue;
                            firstLine = tmp;
                            strings.add(firstLine);
                            strings.add(value.substring(firstLine.length(), value.length()));
                            break;
                        }
                    } else {
                        strings.add(value);
                    }
                } else {
                    strings.add(value);
                }
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String getString(IItem item, JTable table, int columnIndex) {
        if (item == null || table == null || !(table instanceof ItemListTable_Level01)) {
            return "";
        }
        ItemListTable_Level01 itemListTable = (ItemListTable_Level01)table;
        int fieldID = itemListTable.getModel().getColumnFieldID(columnIndex);
        if (item instanceof IFolder) {
            if (fieldID != -1 && itemListTable.getColumnModel().getColumnFieldInfoForColumn(columnIndex).getName().equals("Item Type")) {
                return StringResources.FOLDER;
            }
            if (columnIndex == itemListTable.getFirstColumn()) {
                return ((IFolder)item).getName();
            }
        } else if (item instanceof IGroupHeader && columnIndex == itemListTable.getFirstColumn()) {
            int sortedFieldID = itemListTable.getColumnModel().getSortedColumnFieldInfo().getFieldID();
            return ((IGroupHeader)item).getValue(sortedFieldID, itemListTable.getFolder());
        }
        if (fieldID != -1) {
            if (item instanceof IMessage) {
                return ((IMessage)item).getValue(fieldID, itemListTable.getFolder());
            }
            if (item instanceof IContact) {
                return ((IContact)item).getStringValue(fieldID);
            }
        }
        return "";
    }

    public static Color getDefaultTableCellColor(JTable table, int row, boolean isSelected, boolean isForeground) {
        Color color = isForeground ? (isSelected ? table.getSelectionForeground() : table.getForeground()) : (isSelected ? table.getSelectionBackground() : TableRendererUtils.getDefaultTableCellBackground(table, row));
        return color;
    }

    public static Color getCellColor(IItem item, boolean selected, boolean isFirstColumn, boolean isForeground, int row, JTable table) {
        selected = selected && table.hasFocus();
        ICategoryList categoryList = null;
        if (item instanceof IMessage) {
            categoryList = ((IMessage)item).getCategories();
        } else if (item instanceof IContact) {
            categoryList = ((IContact)item).getCategories();
        }
        if (table instanceof ItemListTable_Level10) {
            ItemListTable_Level10 itemListTable = (ItemListTable_Level10)table;
            if (isForeground && itemListTable.isConversationView() && itemListTable.getItemList().isThreadIgnored(item)) {
                return ITEM_LIST_TABLE_IGNORED_THREAD_COLOR;
            }
        }
        Color color = TableRendererUtils.getCategoryColor(categoryList, selected ? !isForeground : isForeground);
        if (color == null && selected && !isFirstColumn) {
            if (isForeground) {
                Color categoryForeground = TableRendererUtils.getCategoryColor(categoryList, true);
                if (categoryForeground == null) {
                    color = ITEM_LIST_TABLE_ALTERNATE_SELECTION_FOREGROUND;
                }
            } else {
                color = row % 2 == 0 ? ITEM_LIST_TABLE_ALTERNATE_SELECTION_BACKGROUND_DARK : ITEM_LIST_TABLE_ALTERNATE_SELECTION_BACKGROUND;
            }
        }
        if (color == null) {
            color = TableRendererUtils.getDefaultTableCellColor(table, row, selected, isForeground);
        }
        return color;
    }

    public static String getSummaryValue(IItem item, int area, IFolder folder, IViewDisplaySettings viewDisplaySettings) {
        if (item instanceof IFolder && area == 0) {
            return ((IFolder)item).getName();
        }
        if (item instanceof IMessage) {
            return ((IMessage)item).getSummaryValue(area, folder, viewDisplaySettings);
        }
        if (item instanceof IContact) {
            IContact contact = (IContact)item;
            if (area == 0) {
                return contact.getDisplayName();
            }
            if (area == 1) {
                String email = contact.getEmailAddress();
                if (contact instanceof IUserContact) {
                    String phone = ((IUserContact)contact).getDefaultPhone();
                    if (!phone.equals("") && !email.equals("")) {
                        return phone + " (" + email + ")";
                    }
                    if (!phone.equals("")) {
                        return phone;
                    }
                }
                return email;
            }
        }
        return "";
    }

    public static Color getDefaultTableCellBackground(JTable table, int row) {
        if (row % 2 == 0) {
            Color alternateColor = UIManager.getColor("Table.alternateRowColor");
            if (alternateColor == null) {
                return ITEM_LIST_TABLE_ALTERNATE_BACKGROUND;
            }
            return alternateColor;
        }
        return table.getBackground();
    }

    public static Border getBorder(JTable table, boolean selected, boolean firstColumn) {
        if (!table.hasFocus() && selected && firstColumn) {
            return BorderFactory.createLineBorder(table.getSelectionBackground(), 1);
        }
        return EMPTY_BORDER;
    }

    public static void setHTMLFormat(boolean imapDeleted, JComponent renderer) {
        if (imapDeleted) {
            if (renderer instanceof JLabel) {
                ((JLabel)renderer).setText("<html><S><NOBR>" + TableRendererUtils.getCorrectString(((JLabel)renderer).getText()) + "</NOBR></S></html>");
            } else if (renderer instanceof JPanel) {
                JPanel panel = (JPanel)renderer;
                int n = panel.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    if (!(panel.getComponent(i) instanceof JLabel)) continue;
                    JLabel lbl = (JLabel)panel.getComponent(i);
                    lbl.setText("<html><S><NOBR>" + TableRendererUtils.getCorrectString(lbl.getText()) + "</NOBR></S></html>");
                }
            }
        }
    }

    private static String getCorrectString(String s) {
        String res = "";
        for (int i = 0; i < s.length(); ++i) {
            String ch = s.substring(i, i + 1);
            res = ch.equals("<") ? res + "&lt;" : (ch.equals(">") ? res + "&gt;" : (ch.equals(" ") ? res + "&nbsp;" : (ch.equals("&") ? res + "&amp;" : res + ch)));
        }
        return res;
    }
}

