/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.listener.ListenerType;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.item.ActionComplete;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateDocumentHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DocumentChangeHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.ExtendedDateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.SingleDateSelector;
import com.novell.gw.jclient.application.controls.itemview.AbstractAutoSavePanel;
import com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewer;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.statable.StatableCheckBox;
import com.novell.gw.jclient.application.controls.statable.StatableSpinner;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CheckListViewPanel
extends AbstractAutoSavePanel {
    private Logger logger = Logger.getLogger(CheckListViewPanel.class);
    private IItemList itemList;
    private Date itemDueDate;
    private boolean itemIsSetDueDate;
    private JButton btnMoveToTop;
    private JButton btnMoveToBottom;
    private StatableSpinner spnOrder;
    private StatableSpinner spnPercentComplete;
    private JPanel pnlDateSelector;
    private SpinnerNumberModel spinnerNumberModel;
    private TasklistSingleDateSelector dsDueDate;
    private JCheckBox cbDue;
    private StatableCheckBox cbCompleted;
    private ItemViewer pnlItemView;
    private boolean changeListenerDisabled = true;

    public CheckListViewPanel(MVCController controller) {
        super(controller);
        this.setController(controller);
        this.setName(StringResources.TASKLIST);
        this.initValues();
        this.buildUI();
    }

    private void initValues() {
        this.changeListenerDisabled = true;
        this.pnlItemView = new ItemViewer(this.controller, "ATTACHLIST_SPLITPOS_QW", false);
        this.spinnerNumberModel = new SpinnerNumberModel(1, 1, 100, 1);
        this.spnOrder = new StatableSpinner(this.spinnerNumberModel);
        this.spnOrder.addChangeListener(new OrderChangeListener());
        this.spnOrder.setBorder(BorderFactory.createLoweredBevelBorder());
        this.spnPercentComplete = new StatableSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.spnPercentComplete.addChangeListener(new PercentCompleteChangeListener());
        this.spnPercentComplete.setBorder(BorderFactory.createLoweredBevelBorder());
        this.btnMoveToTop = new WideButton(StringResources.MOVE_TO_TOP, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CheckListViewPanel.this.spnOrder.setValue(1);
                CheckListViewPanel.this.startTimer();
            }
        });
        this.btnMoveToBottom = new WideButton(StringResources.MOVE_TO_BOTTOM, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = CheckListViewPanel.this.itemList.findLastUncompletedChecklistItemIndex();
                CheckListViewPanel.this.logger.debug((Object)("LastUncompletedChecklistItemIndex: " + index));
                CheckListViewPanel.this.spnOrder.setValue(index + 1);
                CheckListViewPanel.this.startTimer();
            }
        });
        this.cbDue = new JCheckBox(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                boolean isSelected = ((JToggleButton)e.getSource()).isSelected();
                CheckListViewPanel.this.itemIsSetDueDate = isSelected;
                if (isSelected) {
                    if (CheckListViewPanel.this.itemDueDate == null) {
                        CheckListViewPanel.this.itemDueDate = GWCalendarUtils.getTodayWithoutTimeFraction().getTime();
                    }
                    CheckListViewPanel.this.dsDueDate.setDate(CheckListViewPanel.this.dsDueDate.getDate());
                    CheckListViewPanel.this.dsDueDate.setTextMode(false);
                } else {
                    CheckListViewPanel.this.dsDueDate.setTextMode(true);
                }
                CheckListViewPanel.this.startTimer();
            }
        });
        this.cbDue.setBackground(Color.WHITE);
        this.cbDue.setMargin(new Insets(0, 0, 0, 0));
        this.dsDueDate = new TasklistSingleDateSelector();
        this.dsDueDate.addDateChangeListener(new DueDateChangeListener());
        this.dsDueDate.setDate(GWCalendarUtils.getToday());
        Object dateTextField = this.dsDueDate.getTextComponent();
        ((JComponent)dateTextField).setBorder(BorderFactory.createLineBorder(Color.WHITE));
        ((JTextField)dateTextField).setColumns(10);
        this.cbCompleted = new StatableCheckBox();
        ActionComplete.decorateCheckBox(this.cbCompleted);
        this.cbCompleted.addActionListener(new CompletedActionListener());
        this.pnlDateSelector = new OrientablePanel(new BorderLayout());
        this.pnlDateSelector.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pnlDateSelector.setBackground(Color.WHITE);
        this.changeListenerDisabled = false;
    }

    public void setController(MVCController mvcController) {
        this.controller = mvcController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object item) {
    }

    public Object getMVCModel() {
        return this.item;
    }

    private boolean isChangeListenerDisabled() {
        return this.changeListenerDisabled;
    }

    private void refreshUI(AbstractItem item) {
        assert (item != null);
        this.changeListenerDisabled = true;
        boolean completed = item.getNativeItem().isCompleted();
        this.cbCompleted.setSelected(completed, true);
        int percentComplete = this.item.getNativeItem().getPercentComplete();
        this.spnPercentComplete.setValue(percentComplete, true);
        if (completed && percentComplete != 100) {
            this.spnPercentComplete.setValue(100);
        } else if (!completed && percentComplete == 100) {
            this.spnPercentComplete.setValue(0);
        }
        int itemPosition = this.itemList.indexOf(item.getNativeObject());
        int index = this.itemList.findLastUncompletedChecklistItemIndex();
        if (itemPosition > index) {
            this.btnMoveToBottom.setEnabled(false);
            this.btnMoveToTop.setEnabled(false);
            this.spnOrder.setEnabled(false);
            this.spinnerNumberModel.setMaximum(Integer.valueOf(this.itemList.getSize()));
        } else {
            this.btnMoveToBottom.setEnabled(itemPosition != index);
            this.btnMoveToTop.setEnabled(itemPosition != 0);
            this.spnOrder.setEnabled(true);
            this.spinnerNumberModel.setMaximum(Integer.valueOf(index + 1));
        }
        this.spnOrder.setValue(itemPosition + 1, true);
        this.cbDue.setSelected(this.itemIsSetDueDate);
        if (this.itemIsSetDueDate) {
            this.dsDueDate.setDate(this.getGregorianCalendar(this.itemDueDate));
            this.dsDueDate.setTextMode(false);
        } else {
            this.dsDueDate.setTextMode(true);
        }
        this.changeListenerDisabled = false;
    }

    public void save() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Saving data:...");
            this.logger.debug((Object)("... setDueDate: " + this.itemIsSetDueDate));
            this.logger.debug((Object)("... DueDate: " + this.itemDueDate));
            this.logger.debug((Object)("... % Complete: " + this.getPercentComplete() + (this.spnPercentComplete.isValueStateChanged() ? " < updated" : "")));
            this.logger.debug((Object)("... completed: " + this.isCompleted()));
            this.logger.debug((Object)("... Position: " + this.getOrderIndex() + (this.spnOrder.isValueStateChanged() ? " < updated" : "")));
        }
        this.item.getNativeItem().updateChecklistData(this.itemIsSetDueDate, this.itemDueDate, this.spnPercentComplete.isValueStateChanged(), this.getPercentComplete(), this.isCompleted(), this.spnOrder.isValueStateChanged() ? this.itemList : null, this.getOrderIndex());
    }

    private Calendar getGregorianCalendar(Date date) {
        Calendar gregorianCalendar = Calendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    private void buildUI() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 10, 20);
        constraints.anchor = 21;
        topPanel.add((Component)new OrientableLabel(StringResources.ORDER_C), constraints);
        ++constraints.gridx;
        topPanel.add((Component)this.spnOrder, constraints);
        ++constraints.gridx;
        topPanel.add((Component)this.btnMoveToTop, constraints);
        ++constraints.gridx;
        topPanel.add((Component)this.btnMoveToBottom, constraints);
        ++constraints.gridx;
        constraints.insets.right = 0;
        constraints.gridwidth = 2;
        constraints.anchor = 22;
        topPanel.add((Component)this.cbCompleted, constraints);
        constraints.gridx = 0;
        constraints.gridy = constraints.gridx + 2;
        constraints.insets.right = 20;
        constraints.gridwidth = 1;
        constraints.anchor = 21;
        topPanel.add((Component)new OrientableLabel(StringResources.DUE_ON_C), constraints);
        ++constraints.gridx;
        constraints.gridwidth = 3;
        this.updateDateSelectorPanel(false);
        topPanel.add((Component)this.pnlDateSelector, constraints);
        constraints.gridx += 3;
        constraints.weightx = 1.0;
        constraints.insets.right = 10;
        constraints.gridwidth = 1;
        constraints.anchor = 22;
        topPanel.add((Component)new OrientableLabel(StringResources.PERCENT_COMPLETE_C), constraints);
        ++constraints.gridx;
        constraints.weightx = 0.0;
        constraints.insets.right = 0;
        topPanel.add((Component)this.spnPercentComplete, constraints);
        this.add((Component)topPanel, "First");
        this.add((Component)this.pnlItemView, "Center");
        if (this.isQuickView) {
            this.findAllChildComponents(this);
            for (Component component : this.components) {
                AbstractAutoSavePanel.CurrentFocusAdapter currentFocusAdapter = new AbstractAutoSavePanel.CurrentFocusAdapter();
                ControlsUtils.getListenerManager(this.getController()).addListener(component, currentFocusAdapter, ListenerType.FOCUS_LISTENER);
            }
        }
    }

    private void updateDateSelectorPanel(boolean isTaskItem) {
        this.pnlDateSelector.removeAll();
        if (!isTaskItem) {
            this.pnlDateSelector.add((Component)this.cbDue, "Before");
        }
        this.pnlDateSelector.add((Component)this.dsDueDate, "Center");
    }

    public void loadContent() {
        this.pnlItemView.loadContent();
    }

    public void setItem(AbstractItem item) {
        if (item == null) {
            return;
        }
        this.item = item;
        this.itemList = this.item.getNativeItem().getViewFolder().getContents();
        this.itemDueDate = this.item.getNativeItem().getDueDate();
        this.itemIsSetDueDate = this.item.getNativeItem().getDueDate() != null;
        this.pnlItemView.setItem(this.item);
        this.refreshUI(this.item);
        if (this.isQuickView) {
            this.cbCompleted.requestFocus();
        }
        this.updateDateSelectorPanel(item instanceof TaskItem);
    }

    public void release() {
        super.release();
        this.removeAll();
        if (this.pnlItemView != null) {
            this.pnlItemView.release();
        }
        this.pnlItemView = null;
    }

    private void setDueDate(Calendar dueDate) {
        if (dueDate == null) {
            this.dsDueDate.setTextMode(true);
            this.cbDue.setSelected(false);
        } else {
            this.dsDueDate.setDate(dueDate);
            this.dsDueDate.setTextMode(false);
            this.cbDue.setSelected(true);
        }
    }

    private boolean isCompleted() {
        return this.cbCompleted.isSelected();
    }

    private int getPercentComplete() {
        return (Integer)this.spnPercentComplete.getValue();
    }

    private int getOrderIndex() {
        return (Integer)this.spnOrder.getValue() - 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TasklistSingleDateSelector
    extends SingleDateSelector<ExtendedDateTextField> {
        private TasklistSingleDateSelector() {
        }

        @Override
        protected ExtendedDateTextField createDateTextField() {
            return new ExtendedDateTextField(this.getDateFormat(), (DocumentChangeHandler)new DateDocumentHandler(), StringResources.NO_DUE_DATE);
        }

        @Override
        protected void showPopup(Component invoker) {
            if (!CheckListViewPanel.this.itemIsSetDueDate) {
                CheckListViewPanel.this.setDueDate(this.getDate());
            }
            super.showPopup(invoker);
        }

        private void setTextMode(boolean textMode) {
            ((ExtendedDateTextField)this.dateField).setTextMode(textMode);
        }
    }

    private class CompletedActionListener
    implements ActionListener {
        private CompletedActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (CheckListViewPanel.this.isChangeListenerDisabled()) {
                return;
            }
            boolean selected = CheckListViewPanel.this.cbCompleted.isSelected();
            if (selected && CheckListViewPanel.this.getPercentComplete() != 100) {
                CheckListViewPanel.this.logger.debug((Object)"% complete > to 100");
                CheckListViewPanel.this.spnPercentComplete.setValue(100);
            } else if (!selected && CheckListViewPanel.this.getPercentComplete() == 100) {
                CheckListViewPanel.this.logger.debug((Object)"% complete > to 0");
                CheckListViewPanel.this.spnPercentComplete.setValue(0);
            }
            CheckListViewPanel.this.save();
        }
    }

    private class OrderChangeListener
    implements ChangeListener {
        private OrderChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (CheckListViewPanel.this.isChangeListenerDisabled()) {
                return;
            }
            CheckListViewPanel.this.startTimer();
        }
    }

    private class DueDateChangeListener
    implements DateValueChangeListener {
        private DueDateChangeListener() {
        }

        public void valueChanged(DateChangeEvent event) {
            if (CheckListViewPanel.this.isChangeListenerDisabled()) {
                return;
            }
            CheckListViewPanel.this.itemDueDate = ((SingleDateSelector)event.getSource()).getDate().getTime();
            CheckListViewPanel.this.itemIsSetDueDate = true;
            CheckListViewPanel.this.setDueDate(((SingleDateSelector)event.getSource()).getDate());
            CheckListViewPanel.this.startTimer();
        }
    }

    private class PercentCompleteChangeListener
    implements ChangeListener {
        private PercentCompleteChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (CheckListViewPanel.this.isChangeListenerDisabled()) {
                return;
            }
            int percentComplete = CheckListViewPanel.this.getPercentComplete();
            if (percentComplete == 100 && !CheckListViewPanel.this.cbCompleted.isSelected()) {
                CheckListViewPanel.this.logger.debug((Object)"completed > to true");
                CheckListViewPanel.this.cbCompleted.doClick();
            } else if (percentComplete != 100 && CheckListViewPanel.this.cbCompleted.isSelected()) {
                CheckListViewPanel.this.logger.debug((Object)"completed > to false");
                CheckListViewPanel.this.cbCompleted.doClick();
            }
            CheckListViewPanel.this.startTimer();
        }
    }

    private class WideButton
    extends OrientableButton {
        public WideButton(String name, ActionListener actionListener) {
            super(name);
            this.setMargin(new Insets(0, 3, 0, 3));
            this.addActionListener(actionListener);
        }
    }
}

