/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.header.actions.ActionChangeHeaderFontSize;
import com.novell.gw.jclient.application.controls.itemview.EmbededParentViewController;
import com.novell.gw.jclient.application.controls.itemview.SensitiveLabel;
import com.novell.gw.jclient.application.controls.itemview.UneditableTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.ISkinnable;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbededParentView
extends SkinnablePanel
implements MVCView<EmbededParentViewController, AbstractItem> {
    public static final Color DEFAULT_COLOR = new Color(255, 255, 230);
    public static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    public static final int DEFAULT_TEXT_SIZE = PLAFChanger.getFontSize();
    public static final Boolean DEFAULT_HIDE_SYSTEM_ATTACHMENTS = true;
    private EmbededParentViewController controller;
    private AbstractItem gwItem;
    private SkinnableLabel lbParentMessage;
    private SensitiveLabel lbSubject;
    private SensitiveLabel lbFrom;
    private UneditableTextField tfSubject;
    private UneditableTextField tfFrom;
    private JPopupMenu popupMenu;

    public EmbededParentView(MVCController parentController) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.HEADER_PARENT_BACKGROUND_COLOR, ComponentProperty.BACKGROUND);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HEADER_PARENT_TEXT_COLOR, ComponentProperty.FOREGROUND);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HEADER_PARENT_FONT_SIZE, ComponentProperty.FONT_SIZE);
        this.controller = new EmbededParentViewController(this, parentController);
        this.build();
    }

    private void build() {
        this.lbParentMessage = new SkinnableLabel(StringResources.PARENT_MESSAGE);
        this.lbParentMessage.setIcon(ImageResources.ICON_SHOW_PARENT_MESSAGE);
        this.lbParentMessage.setFont(Utils.deriveFont(this.lbParentMessage.getFont(), 1));
        this.lbParentMessage.setCursor(Cursor.getPredefinedCursor(12));
        this.lbParentMessage.addMouseListener(new ParentMessageMouseListener());
        EmbededParentView.prepareEmbeddedParentViewComponent(this.lbParentMessage);
        this.lbSubject = new SensitiveLabel(StringResources.SUBJECT_C, null);
        EmbededParentView.prepareEmbeddedParentViewComponent(this.lbSubject);
        this.lbFrom = new SensitiveLabel(StringResources.FROM_C, null);
        EmbededParentView.prepareEmbeddedParentViewComponent(this.lbFrom);
        this.tfFrom = new UneditableTextField(this.lbFrom);
        EmbededParentView.prepareEmbeddedParentViewComponent(this.tfFrom);
        this.tfSubject = new UneditableTextField(this.lbSubject);
        EmbededParentView.prepareEmbeddedParentViewComponent(this.tfSubject);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        this.add((Component)this.lbParentMessage, c);
        c.anchor = 22;
        c.fill = 0;
        c.weightx = 1.0;
        OrientablePanel pnlContent = new OrientablePanel();
        pnlContent.setOpaque(false);
        BoxLayout boxLayout = new BoxLayout(pnlContent, 2);
        pnlContent.setLayout(boxLayout);
        pnlContent.add(Box.createRigidArea(new Dimension(10, 0)));
        this.lbSubject.setAlignmentX(1.0f);
        this.tfSubject.setAlignmentX(1.0f);
        pnlContent.add(this.lbSubject);
        pnlContent.add(this.tfSubject);
        c.insets = new Insets(0, 10, 0, 5);
        Dimension textDimention = EmbededParentView.getTextDimention(this.lbSubject, StringResources.FROM_C);
        textDimention = new Dimension(textDimention.width + 20, textDimention.height);
        this.lbSubject.setMinimumSize(textDimention);
        this.lbSubject.setPreferredSize(textDimention);
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)pnlContent, c);
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 5);
        c.anchor = 22;
        this.add((Component)this.lbFrom, c);
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        c.ipadx = 20;
        this.add((Component)this.tfFrom, c);
        this.popupMenu = new PropertiesPopupMenu();
        this.addMouseListener(new RClickMouseListener());
    }

    public void setPopupMenu(JPopupMenu thePopupMenu) {
        this.popupMenu = thePopupMenu;
    }

    @Override
    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    @Override
    public void setController(EmbededParentViewController theController) {
        this.controller = theController;
    }

    @Override
    public EmbededParentViewController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(AbstractItem theModel) {
        if (this.gwItem != theModel) {
            this.gwItem = theModel;
            this.updateView();
        }
    }

    @Override
    public AbstractItem getMVCModel() {
        return null;
    }

    private void updateView() {
        if (this.gwItem != null) {
            this.tfSubject.setText(this.gwItem.getSubject());
            this.tfFrom.setText(this.gwItem.getNativeItem().getFromText());
            Dimension dimension = EmbededParentView.getTextDimention(this.tfFrom, this.gwItem.getNativeItem().getFromText());
            this.tfFrom.setPreferredSize(dimension);
            this.tfFrom.setMinimumSize(dimension);
            this.tfSubject.setCaretPosition(0);
            this.validate();
        }
    }

    private static Dimension getTextDimention(JComponent component, String text) {
        int width = SwingUtilities.computeStringWidth(component.getFontMetrics(component.getFont()), text);
        int inset = 0;
        Dimension dimension = new Dimension(width + inset, component.getPreferredSize().height);
        return dimension;
    }

    private static void prepareEmbeddedParentViewComponent(ISkinnable child) {
        child.clearPropertyBindings();
        child.putSkinProperty(SkinProperty.HEADER_PARENT_BACKGROUND_COLOR, ComponentProperty.BACKGROUND);
        child.putSkinProperty(SkinProperty.HEADER_PARENT_TEXT_COLOR, ComponentProperty.FOREGROUND);
        child.putSkinProperty(SkinProperty.HEADER_PARENT_FONT_SIZE, ComponentProperty.FONT_SIZE);
    }

    private class PropertiesPopupMenu
    extends GWPopupMenu {
        public PropertiesPopupMenu() {
            ActionList actionList = EmbededParentView.this.controller.getActionList();
            this.add(actionList.getAction(ActionKey.CHANGE_EMB_HEADER_COLOR).getMenuItem());
            this.add(actionList.getAction(ActionKey.CHANGE_EMB_HEADER_TEXT_COLOR).getMenuItem());
            ActionChangeHeaderFontSize action = (ActionChangeHeaderFontSize)actionList.getAction(ActionKey.CHANGE_EMB_HEADER_FONT_SIZE);
            this.add(action.getSubMenu());
        }
    }

    private class RClickMouseListener
    extends MouseAdapter {
        private RClickMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger() && EmbededParentView.this.popupMenu != null) {
                EmbededParentView.this.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    private class ParentMessageMouseListener
    extends MouseAdapter {
        private ParentMessageMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (OS.isLeftMouseButton(e)) {
                Command command = new Command(1030, EmbededParentView.this.gwItem);
                EmbededParentView.this.getController().processCommand(command);
            }
        }
    }
}

