/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.ApplicationFrame;
import com.appframework.cache.IdentifiedObject;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.resources.ImageResources;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.ActionComplete;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.components.ComponentInfluence;
import com.novell.gw.jclient.application.controls.components.FocusableLabel;
import com.novell.gw.jclient.application.controls.components.GradientPanel;
import com.novell.gw.jclient.application.controls.filter.ComponentWithMenu;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.header.HeaderPopupMenu;
import com.novell.gw.jclient.application.controls.header.QuickViewPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.CheckListViewPanel;
import com.novell.gw.jclient.application.controls.itemview.EnvelopMessageTreePopup;
import com.novell.gw.jclient.application.controls.itemview.GWItemPropertiesPanelController;
import com.novell.gw.jclient.application.controls.itemview.RecipientsMenu;
import com.novell.gw.jclient.application.controls.itemview.RecipientsPanel;
import com.novell.gw.jclient.application.controls.itemview.RecipientsTextField;
import com.novell.gw.jclient.application.controls.itemview.SensitiveLabel;
import com.novell.gw.jclient.application.controls.itemview.UneditableTextField;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.AppointmentAcceptLevelColorButton;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableCheckBox;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.frames.open.FrameOpenActionList;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWItemPropertiesPanel
extends JPanel
implements MVCView<GWItemPropertiesPanelController, Object> {
    private static Logger logger = Logger.getLogger(GWItemPropertiesPanel.class);
    private static Color DEFAULT_ERROR_NOTIFICATION_BACKGROUND_COLOR = Color.RED;
    private GWItemPropertiesPanelController controller;
    private AbstractItem<?> selectedItem;
    private AbstractItem<?> parentItem;
    private GWAttachment selectedAttachment;
    private SkinnablePanel pnlCenter;
    private SkinnablePanel pnlEmpty;
    private SensitiveLabel lbSubject;
    private SensitiveLabel lbFrom;
    private SensitiveLabel lbTo;
    private SensitiveLabel lbCC;
    private SensitiveLabel lbBC;
    private SensitiveLabel lbWhen;
    private SensitiveLabel lbWhere;
    private SensitiveLabel lbDateStart;
    private SensitiveLabel lbDateEnd;
    private SensitiveLabel lbPriority;
    private SensitiveLabel lbCaller;
    private SensitiveLabel lbCompany;
    private SensitiveLabel lbPhone;
    RecipientsTextField tfFrom;
    RecipientsTextField tfTo;
    RecipientsTextField tfCC;
    RecipientsTextField tfBC;
    UneditableTextField tfSubject;
    UneditableTextField tfDate;
    UneditableTextField tfWhen;
    UneditableTextField tfWhere;
    UneditableTextField tfDateStart;
    UneditableTextField tfDateEnd;
    UneditableTextField tfPriority;
    UneditableTextField tfCaller;
    UneditableTextField tfCompany;
    UneditableTextField tfPhone;
    private JLabel lbViewToRecipients = new OrientableLabel();
    private JLabel lbViewCCRecipients = new OrientableLabel();
    private JLabel lbViewBCRecipients = new OrientableLabel();
    private RecipientsMenu recipientsMenuTo = new RecipientsMenu(this);
    private RecipientsMenu recipientsMenuCC = new RecipientsMenu(this);
    private RecipientsMenu recipientsMenuBC = new RecipientsMenu(this);
    private MouseListener headerMouseListener;
    private boolean alignColons;
    private boolean isLazyInitialized;
    private MouseListener emptyItemListener;
    private MouseListener nonemptyItemListener;
    private EnvelopMessageTreePopup messageTreePopup;
    private SkinnablePanel pnlTemp;
    private SkinnableLabel lbEmbeddedMail = new SkinnableLabel();
    private boolean hideSystemAttachments;
    private GradientPanel cmpRecurs;
    private boolean isAttachmentViewVisible;
    private boolean attachmentViewVisibleWasSet;
    private AbstractItem selectedItemForPopup;
    private String originalEmbeddedMailText;
    private JPanel itemNotificationClickableBar;

    public GWItemPropertiesPanel(MVCController theParentController) {
        super(new BorderLayout());
        ControlsUtils.prepareHeaderLabel(this.lbEmbeddedMail);
        this.cmpRecurs = null;
        this.attachmentViewVisibleWasSet = false;
        this.itemNotificationClickableBar = this.createItemNotificationClickableBar(StringResources.THERE_ARE_ERRORS_WITH_THIS_ITEM, StringResources.INCORRECT_RTF_MESSAGE, com.novell.gw.jclient.application.resources.ImageResources.ICON_ALERT_16x16, DEFAULT_ERROR_NOTIFICATION_BACKGROUND_COLOR);
        this.controller = new GWItemPropertiesPanelController(this, theParentController);
        EnvironmentOptions eo = OptionManager.getInstance().getEnvironmentOptions();
        this.alignColons = eo.isHeaderAligned();
        HeaderPopupMenu headerPopupMenu = new HeaderPopupMenu(this.getController().getActionList());
        this.emptyItemListener = AbstractActionsPopupMenu.createMenuMouseListener(headerPopupMenu);
        QuickViewPopupMenu qwPopupMenu = new QuickViewPopupMenu(this.getController().getActionList());
        this.nonemptyItemListener = AbstractActionsPopupMenu.createMenuMouseListener(qwPopupMenu);
        this.setSelectedItem(null);
    }

    private void clearFields() {
        GWItemPropertiesPanel.clear(this.tfWhere);
        GWItemPropertiesPanel.clear(this.tfWhen);
        GWItemPropertiesPanel.clear(this.tfDateStart);
        GWItemPropertiesPanel.clear(this.tfDateEnd);
        GWItemPropertiesPanel.clear(this.tfPriority);
        GWItemPropertiesPanel.clear(this.tfCaller);
        GWItemPropertiesPanel.clear(this.tfCompany);
        GWItemPropertiesPanel.clear(this.tfPhone);
        GWItemPropertiesPanel.clear(this.tfSubject);
        GWItemPropertiesPanel.clear(this.tfDate);
    }

    private static void clear(JTextField textField) {
        if (textField != null) {
            textField.setText(null);
        }
    }

    private boolean isOnCheckListViewPanel() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof CheckListViewPanel)) continue;
            return true;
        }
        return false;
    }

    private void build() {
        this.removeAll();
        this.createControls();
        this.clearFields();
        this.setData();
        this.pnlCenter = new SkinnablePanel(new GridBagLayout());
        ControlsUtils.prepareHeaderPanel(this.pnlCenter);
        this.add((Component)this.pnlCenter, "Center");
        GWItemPropertiesPanel.setBoldFont(this.lbFrom);
        GridBagConstraints constraints = new GridBagConstraints();
        if (!this.isOnCheckListViewPanel()) {
            this.buildFrom(constraints);
            this.buildAddresses(constraints);
            if (!Utils.isNullOrEmpty(this.tfWhen.getText())) {
                if (this.selectedItem instanceof AppointmentItem && ((IAppointment)this.selectedItem.getNativeItem()).isAutodate()) {
                    this.buildWhen(constraints);
                } else {
                    this.buildRow(this.lbWhen, this.tfWhen, this.getAppAcceptLevelButton(), constraints);
                }
            }
            if (!Utils.isNullOrEmpty(this.tfWhere.getText())) {
                this.buildRow(this.lbWhere, this.tfWhere, null, constraints);
            }
            this.buildCaller(constraints);
            this.buildPhone(constraints);
            if (!Utils.isNullOrEmpty(this.tfDateStart.getText())) {
                SkinnablePanel pnlTemp = new SkinnablePanel();
                pnlTemp.setLayout(new BoxLayout(pnlTemp, 0));
                ControlsUtils.prepareHeaderPanel(pnlTemp);
                pnlTemp.setBorder(null);
                pnlTemp.add(this.tfDateStart);
                pnlTemp.add(Box.createRigidArea(new Dimension(5, 0)));
                GWItemPropertiesPanel.setBoldFont(this.lbDateEnd);
                pnlTemp.add(this.lbDateEnd);
                pnlTemp.add(Box.createRigidArea(new Dimension(5, 0)));
                pnlTemp.add(this.tfDateEnd);
                pnlTemp.add(Box.createRigidArea(new Dimension(5, 0)));
                GWItemPropertiesPanel.setBoldFont(this.lbPriority);
                pnlTemp.add(this.lbPriority);
                pnlTemp.add(Box.createRigidArea(new Dimension(5, 0)));
                pnlTemp.add(this.tfPriority);
                pnlTemp.add(Box.createHorizontalGlue());
                this.buildRow(this.lbDateStart, pnlTemp, null, constraints);
            }
        }
        if (!Utils.isNullOrEmpty(this.tfSubject.getText())) {
            this.buildRow(this.lbSubject, this.tfSubject, null, constraints);
        }
        this.hideSystemAttachments = OptionManager.getInstance().getEnvironmentOptions().isHideSystemAttachments();
        constraints.anchor = 22;
        --constraints.gridy;
        constraints.gridx = -1;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        if (this.hasAttachments()) {
            this.lbEmbeddedMail.setHorizontalAlignment(10);
            this.pnlTemp = new SkinnablePanel(new BorderLayout());
            ControlsUtils.prepareHeaderPanel(this.pnlTemp);
            this.lbEmbeddedMail.setText(this.selectedItem.getSubject());
            this.originalEmbeddedMailText = this.selectedItem.getSubject();
            this.lbEmbeddedMail.setIcon(com.novell.gw.jclient.application.resources.ImageResources.ICON_ATTACHMENT);
            this.pnlTemp.add((Component)this.lbEmbeddedMail, "Center");
            this.pnlTemp.add((Component)new OrientableLabel(com.novell.gw.jclient.application.resources.ImageResources.ICON_DOWN_ARROW), "After");
            IdentifiedObject selected = this.selectedAttachment != null ? this.selectedAttachment : this.selectedItem;
            this.getEnvelopMessageTree().rebuild(this.parentItem, selected, !this.isAttachmentViewVisible);
            this.updateEmbededMailButtonText();
            ComponentWithMenu compon = new ComponentWithMenu(this.pnlTemp, this.messageTreePopup);
            compon.setMaximumSize(compon.getPreferredSize());
            this.pnlCenter.add((Component)compon, constraints);
            this.tfSubject.addComponentListener(new HeaderSizeAdapter());
            this.performTextCutting();
            if (!this.hasEnvelopeMessages() && this.isAttachmentViewVisible) {
                this.pnlTemp.setVisible(false);
            }
        }
        ImageIcon image = null;
        String tipText = null;
        Object message = this.selectedItem.getNativeItem();
        if ((message.isDigitallyClearSigned() || message.isDigitallySigned()) && message.isEncrypted()) {
            image = com.novell.gw.jclient.application.resources.ImageResources.SECURITY_SIGNED_AND_ENCRYPTED;
            tipText = StringResources.THIS_MESSAGE_IS_SIGNED_AND_DECRYPTED;
        } else if (message.isDigitallyClearSigned() || message.isDigitallySigned()) {
            image = com.novell.gw.jclient.application.resources.ImageResources.SECURITY_SIGNED;
            tipText = StringResources.THIS_MESSAGE_IS_SIGNED;
        } else if (message.isEncrypted()) {
            image = com.novell.gw.jclient.application.resources.ImageResources.SECURITY_ENCRYPTED;
            tipText = StringResources.THIS_MESSAGE_IS_ENCRYPTED;
        }
        if (image != null) {
            SkinnableLabel lblSecurityIcon = new SkinnableLabel(image);
            lblSecurityIcon.setToolTipText(tipText);
            lblSecurityIcon.addMouseListener(new SecurityErrorMouseListener());
            this.pnlCenter.add((Component)lblSecurityIcon, constraints);
            SkinnablePanel pnlSecurityBanner = new SkinnablePanel(new BorderLayout());
            pnlSecurityBanner.setBackground(DEFAULT_ERROR_NOTIFICATION_BACKGROUND_COLOR);
            SkinnableLabel lbSecurity = new SkinnableLabel(StringResources.SECURITY_ERROR);
            lbSecurity.setIcon(com.novell.gw.jclient.application.resources.ImageResources.ICON_ALERT_16x16);
            lbSecurity.putSkinProperty(SkinProperty.HEADER_FONT_SIZE, ComponentProperty.FONT_SIZE);
            lbSecurity.addMouseListener(new SecurityErrorMouseListener());
            pnlSecurityBanner.add((Component)lbSecurity, "Before");
            constraints.anchor = 21;
            ++constraints.gridy;
            constraints.gridx = 0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            this.pnlCenter.add((Component)pnlSecurityBanner, constraints);
        }
        constraints.anchor = 21;
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        this.pnlCenter.add((Component)this.itemNotificationClickableBar, constraints);
        this.alignColons();
    }

    private JLabel buildItemNotificationLabel(String text, Icon icon) {
        SkinnableLabel lbNotification = new SkinnableLabel();
        lbNotification.putSkinProperty(SkinProperty.HEADER_FONT_SIZE, ComponentProperty.FONT_SIZE);
        if (!Utils.isNullOrEmpty(text)) {
            lbNotification.setText(text);
        }
        if (icon != null) {
            lbNotification.setIcon(icon);
        }
        return lbNotification;
    }

    private JPanel buildItemNotificationClickableBar(String topic, Icon icon, Color background) {
        SkinnablePanel pnlClickableBar = new SkinnablePanel(new BorderLayout());
        pnlClickableBar.setBackground(background);
        JLabel lbNotification = this.buildItemNotificationLabel(topic, icon);
        pnlClickableBar.add((Component)lbNotification, "Before");
        return pnlClickableBar;
    }

    private JPanel createItemNotificationClickableBar(String topic, String message, Icon icon, Color background) {
        JPanel pnlClickableBar = this.buildItemNotificationClickableBar(topic, icon, background);
        pnlClickableBar.addMouseListener(new ClickableNotificationMouseListener(this, message, StringResources.ERROR, 0));
        return pnlClickableBar;
    }

    private void showSecurityErrorMessage() {
        if (this.selectedItem != null) {
            Object message = this.selectedItem.getNativeItem();
            String text = null;
            if ((message.isDigitallyClearSigned() || message.isDigitallySigned()) && message.isEncrypted()) {
                text = StringResources.THIS_MESSAGE_WAS_DIGITALLY_SIGNED_AND_ENCRYPTED_BUT;
            } else if (message.isDigitallyClearSigned() || message.isDigitallySigned()) {
                text = StringResources.THIS_MESSAGE_WAS_DIGITALLY_SIGNED_BUT;
            }
            if (message.isEncrypted()) {
                text = StringResources.THIS_MESSAGE_WAS_ENCRYPTED_BUT;
            }
            if (text != null) {
                JOptionPane.showMessageDialog(this, text, StringResources.ERROR, 0);
            }
        }
    }

    private void performTextCutting() {
        double widthDifference = this.tfSubject.getSize().getWidth() - this.tfSubject.getPreferredSize().getWidth();
        FontMetrics fontMetrics = this.lbEmbeddedMail.getFontMetrics(this.lbEmbeddedMail.getFont());
        int symbolsCounter = this.lbEmbeddedMail.getText().length();
        char[] symbols = this.lbEmbeddedMail.getText().toCharArray();
        if (widthDifference < 0.0 && this.lbEmbeddedMail.getText().length() > 0) {
            double leftOver = (double)fontMetrics.charsWidth(symbols, 0, symbolsCounter) - Math.abs(widthDifference);
            while (--symbolsCounter > 0 && (double)fontMetrics.charsWidth(symbols, 0, symbolsCounter) > leftOver) {
            }
            this.lbEmbeddedMail.setText(new String(symbols, 0, symbolsCounter));
            this.pnlCenter.validate();
        } else if (this.originalEmbeddedMailText.length() > this.lbEmbeddedMail.getText().length() && widthDifference > (double)this.getSymbolMaxWidth(fontMetrics, this.originalEmbeddedMailText)) {
            double leftOver = (double)fontMetrics.charsWidth(symbols, 0, symbolsCounter) + widthDifference;
            symbols = this.originalEmbeddedMailText.toCharArray();
            while (++symbolsCounter < this.originalEmbeddedMailText.length() && (double)fontMetrics.charsWidth(symbols, 0, symbolsCounter) < leftOver) {
            }
            this.lbEmbeddedMail.setText(new String(symbols, 0, symbolsCounter));
            this.pnlCenter.validate();
        }
    }

    private int getSymbolMaxWidth(FontMetrics metrics, String text) {
        int maxWidth = 0;
        for (char symbol : text.toCharArray()) {
            if (maxWidth >= metrics.charWidth(symbol)) continue;
            maxWidth = metrics.charWidth(symbol);
        }
        return maxWidth;
    }

    private void setRecipients() {
        this.recipientsMenuTo.setRecipients(GWItemPropertiesPanel.getRecipients(this.selectedItem.getRecipientsList(), RecipientCopyType.getTo()));
        this.recipientsMenuCC.setRecipients(GWItemPropertiesPanel.getRecipients(this.selectedItem.getRecipientsList(), RecipientCopyType.getCc()));
        this.recipientsMenuBC.setRecipients(GWItemPropertiesPanel.getRecipients(this.selectedItem.getRecipientsList(), RecipientCopyType.getBc()));
    }

    private static List<IRecipient> getRecipients(List<IRecipient> recipients, RecipientCopyType type) {
        ArrayList<IRecipient> result = new ArrayList<IRecipient>();
        int nSize = recipients.size();
        for (int i = 0; i < nSize; ++i) {
            IRecipient recipient = recipients.get(i);
            if (!recipient.getCopyType().hasRecipientCopyType(type)) continue;
            result.add(recipient);
        }
        return result;
    }

    private EnvelopMessageTreePopup getEnvelopMessageTree() {
        if (this.messageTreePopup == null) {
            this.messageTreePopup = new EnvelopMessageTreePopup(this.controller);
        }
        return this.messageTreePopup;
    }

    private boolean hasAttachments() {
        boolean result = false;
        if (this.parentItem == null) {
            return false;
        }
        for (GWAttachment attachment : this.parentItem.getAttachments()) {
            if (attachment.isSystemAttachment() && this.hideSystemAttachments) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean hasEnvelopeMessages() {
        boolean result = false;
        if (this.parentItem == null) {
            return false;
        }
        for (GWAttachment attachment : this.parentItem.getAttachments()) {
            if (!attachment.isMessageAttachment()) continue;
            result = true;
            break;
        }
        return result;
    }

    private void buildWhen(GridBagConstraints c) {
        SkinnablePanel panel = new SkinnablePanel(new GridBagLayout());
        ControlsUtils.prepareHeaderPanel(panel);
        GridBagConstraints cc = new GridBagConstraints();
        cc.anchor = 21;
        cc.fill = 2;
        cc.gridwidth = 1;
        cc.gridx = 0;
        cc.gridy = 0;
        panel.add((Component)this.tfWhen, cc);
        ++cc.gridx;
        cc.weightx = 1.0;
        cc.insets.left = 5;
        cc.fill = 0;
        JComponent lastComponent = this.getAppAcceptLevelButton();
        if (lastComponent == null) {
            lastComponent = new JPanel();
        }
        panel.add((Component)lastComponent, cc);
        ++cc.gridx;
        cc.weightx = 0.0;
        panel.add((Component)this.getRecursComponent(), cc);
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 0;
        c.gridx = -1;
        c.weightx = 0.0;
        this.pnlCenter.add((Component)this.lbWhen, c);
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.pnlCenter.add((Component)panel, c);
        ++c.gridy;
        c.gridwidth = 1;
    }

    private void buildFrom(GridBagConstraints c) {
        SkinnablePanel pnlFrom;
        if (this.selectedItem instanceof TaskItem) {
            SkinnableCheckBox cbCompleted = ((ActionComplete)this.controller.getActionList().getAction(ActionKey.COMPLETE)).getCheckBox();
            ControlsUtils.prepareHeaderCheckBox(cbCompleted);
            pnlFrom = new SkinnablePanel(new GridBagLayout());
            ControlsUtils.prepareHeaderPanel(pnlFrom);
            GridBagConstraints cc = new GridBagConstraints();
            cc.anchor = 21;
            cc.fill = 2;
            cc.gridy = 0;
            cc.weightx = 1.0;
            pnlFrom.add((Component)this.tfFrom, cc);
            cc.fill = 0;
            cc.insets.left = 5;
            cc.weightx = 0.0;
            cbCompleted.setPreferredSize(new Dimension(cbCompleted.getPreferredSize().width, this.tfDate.getPreferredSize().height));
            pnlFrom.add((Component)cbCompleted, cc);
            cc.insets.left = 0;
            pnlFrom.add((Component)this.tfDate, cc);
        } else {
            pnlFrom = new SkinnablePanel(new BorderLayout());
            ControlsUtils.prepareHeaderPanel(pnlFrom);
            pnlFrom.add((Component)this.tfFrom, "Before");
            pnlFrom.add((Component)this.tfDate, "After");
        }
        c.anchor = 21;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 0;
        c.gridx = -1;
        c.gridy = 0;
        c.weightx = 0.0;
        this.pnlCenter.add((Component)this.lbFrom, c);
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.pnlCenter.add((Component)pnlFrom, c);
        ++c.gridy;
        c.gridwidth = 1;
    }

    private void buildAddresses(GridBagConstraints c) {
        if (!Utils.isNullOrEmpty(this.tfTo.getText())) {
            c.anchor = 21;
            c.fill = 0;
            c.gridx = -1;
            c.weightx = 0.0;
            this.pnlCenter.add((Component)this.lbTo, c);
            ComponentWithMenu.initComponent(this.lbViewToRecipients, this.recipientsMenuTo);
            RecipientsPanel panel = new RecipientsPanel(this.tfTo, this.lbViewToRecipients);
            c.fill = 2;
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.pnlCenter.add((Component)panel, c);
            ControlsUtils.prepareHeaderPanel(panel);
            c.gridwidth = 1;
            ++c.gridy;
        }
        if (!Utils.isNullOrEmpty(this.tfCC.getText())) {
            this.buildRecipients(this.lbCC, this.tfCC, this.lbViewCCRecipients, c, this.recipientsMenuCC);
        }
        if (!Utils.isNullOrEmpty(this.tfBC.getText())) {
            this.buildRecipients(this.lbBC, this.tfBC, this.lbViewBCRecipients, c, this.recipientsMenuBC);
        }
    }

    private void buildRecipients(JLabel lbHead, RecipientsTextField tf, JLabel lbAllRecipients, GridBagConstraints c, JPopupMenu recipientsMenu) {
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        this.pnlCenter.add((Component)lbHead, c);
        ComponentWithMenu.initComponent(lbAllRecipients, recipientsMenu);
        RecipientsPanel panel = new RecipientsPanel(tf, lbAllRecipients);
        ControlsUtils.prepareHeaderPanel(panel);
        c.fill = 2;
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.pnlCenter.add((Component)panel, c);
        c.gridwidth = 1;
        ++c.gridy;
    }

    private void buildCaller(GridBagConstraints constraints) {
        boolean bEmptyCaller = Utils.isNullOrEmpty(this.tfCaller.getText());
        boolean bEmptyCompany = Utils.isNullOrEmpty(this.tfCompany.getText());
        if (!bEmptyCaller || !bEmptyCompany) {
            SkinnablePanel callerPanel = new SkinnablePanel(new GridBagLayout());
            ControlsUtils.prepareHeaderPanel(callerPanel);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 0;
            c.gridy = 0;
            c.insets.right = 5;
            if (!bEmptyCaller) {
                callerPanel.add((Component)this.tfCaller, c);
                if (!bEmptyCompany) {
                    GWItemPropertiesPanel.setBoldFont(this.lbCompany);
                    c.insets.right = 10;
                    callerPanel.add((Component)this.lbCompany, c);
                    c.insets.right = 5;
                    c.weightx = 1.0;
                    callerPanel.add((Component)this.tfCompany, c);
                }
                this.buildRow(this.lbCaller, callerPanel, null, constraints);
            } else {
                callerPanel.add((Component)this.tfCompany, c);
                this.buildRow(this.lbCompany, callerPanel, null, constraints);
            }
        }
    }

    private void buildPhone(GridBagConstraints constraints) {
        boolean bEmptyPhone = Utils.isNullOrEmpty(this.tfPhone.getText());
        SkinnablePanel phonePanel = new SkinnablePanel(new GridBagLayout());
        ControlsUtils.prepareHeaderPanel(phonePanel);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 0;
        c.insets.right = 14;
        if (!bEmptyPhone) {
            phonePanel.add((Component)this.tfPhone, c);
        }
        c.weightx = 1.0;
        if (this.selectedItem instanceof PhoneItem) {
            phonePanel.add((Component)new OrientableLabel(((PhoneItem)this.selectedItem).getWideSubject()), c);
        }
        this.buildRow(bEmptyPhone ? null : this.lbPhone, phonePanel, null, constraints);
    }

    private JComponent getAppAcceptLevelButton() {
        if (this.parentItem instanceof AppointmentItem) {
            AppointmentAcceptLevelColorButton button = new AppointmentAcceptLevelColorButton(this.getController(), ((IAppointment)this.parentItem.getNativeItem()).getShowAsLevel());
            button.setOpaque(false);
            return button;
        }
        return null;
    }

    private void buildRow(JComponent cTitle, JComponent cRecipients, JComponent lastComponent, GridBagConstraints c) {
        if (cTitle != null) {
            GWItemPropertiesPanel.setBoldFont(cTitle);
        }
        cRecipients.setMaximumSize(cRecipients.getPreferredSize());
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        if (cTitle != null) {
            this.pnlCenter.add((Component)cTitle, c);
        }
        SkinnablePanel panel = new SkinnablePanel(new GridBagLayout());
        ControlsUtils.prepareHeaderPanel(panel);
        GridBagConstraints cc = new GridBagConstraints();
        cc.anchor = 21;
        cc.fill = 2;
        cc.gridwidth = 1;
        cc.gridx = 0;
        cc.gridy = 0;
        if (lastComponent == null) {
            cc.weightx = 1.0;
        }
        panel.add((Component)cRecipients, cc);
        if (lastComponent != null) {
            ++cc.gridx;
            cc.weightx = 1.0;
            cc.insets.left = 5;
            cc.fill = 0;
            panel.add((Component)lastComponent, cc);
        }
        c.anchor = 21;
        c.fill = 2;
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.insets.left = 0;
        this.pnlCenter.add((Component)panel, c);
        c.insets.left = 5;
        c.gridwidth = 1;
        ++c.gridy;
    }

    public AbstractItem getSelectedItem() {
        return this.selectedItem;
    }

    private void setSelectedItem(AbstractItem item) {
        this.selectedItem = item;
        if (this.selectedItem == null) {
            if (this.headerMouseListener != this.emptyItemListener) {
                this.removeMouseListener(this.headerMouseListener);
                this.headerMouseListener = this.emptyItemListener;
                this.addMouseListener(this.headerMouseListener);
            }
            this.clearPane();
            this.recipientsMenuCC.clearRecipients();
            this.recipientsMenuTo.clearRecipients();
            this.recipientsMenuBC.clearRecipients();
        } else {
            if (this.headerMouseListener != this.nonemptyItemListener) {
                this.removeMouseListener(this.headerMouseListener);
                this.headerMouseListener = this.nonemptyItemListener;
                this.addMouseListener(this.headerMouseListener);
            }
            if (this.parentItem == null) {
                this.setParentItem(item);
            }
            this.setRecipients();
            this.build();
            this.updateUI();
        }
    }

    @Override
    public void setController(GWItemPropertiesPanelController controller) {
        this.controller = controller;
    }

    @Override
    public GWItemPropertiesPanelController getController() {
        return this.controller;
    }

    public void setEmbeddedObject(Object o) {
        if (o instanceof AbstractItem) {
            this.selectedItemForPopup = (AbstractItem)o;
        }
        this.updateEmbededMailButtonText();
    }

    @Override
    public void setMVCModel(Object theModel) {
        this.selectedAttachment = null;
        if (theModel == null) {
            this.setSelectedItem(null);
        } else if (theModel instanceof AbstractItem) {
            this.setSelectedItem((AbstractItem)theModel);
        } else if (theModel instanceof GWAttachment) {
            this.selectedAttachment = (GWAttachment)theModel;
            this.setSelectedItem(((GWAttachment)theModel).getGwItem());
        }
    }

    @Override
    public Object getMVCModel() {
        return this.selectedItem;
    }

    private void createControls() {
        if (this.isLazyInitialized) {
            return;
        }
        this.lbFrom = new SensitiveLabel(StringResources.FROM_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbFrom);
        this.lbTo = new SensitiveLabel(StringResources.TO_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbTo);
        this.lbCC = new SensitiveLabel(StringResources.CC_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbCC);
        this.lbBC = new SensitiveLabel(StringResources.BC_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbBC);
        this.lbWhen = new SensitiveLabel(StringResources.WHEN_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbWhen);
        this.lbWhere = new SensitiveLabel(StringResources.WHERE_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbWhere);
        this.lbSubject = new SensitiveLabel(StringResources.SUBJECT_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbSubject);
        this.lbDateStart = new SensitiveLabel(StringResources.STARTS_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbDateStart);
        this.lbDateEnd = new SensitiveLabel(StringResources.DUE_ON_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbDateEnd);
        this.lbPriority = new SensitiveLabel(StringResources.PRIORITY_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbPriority);
        this.lbCaller = new SensitiveLabel(StringResources.CALLER_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbCaller);
        this.lbCompany = new SensitiveLabel(StringResources.COMPANY_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbCompany);
        this.lbPhone = new SensitiveLabel(StringResources.PHONE_C, this.headerMouseListener);
        ControlsUtils.prepareHeaderLabel(this.lbPhone);
        this.tfSubject = new UneditableTextField(this.lbSubject);
        ControlsUtils.prepareHeaderTextField(this.tfSubject);
        this.tfDate = new UneditableTextField(null);
        ControlsUtils.prepareHeaderTextField(this.tfDate);
        if (this.tfDate.getComponentOrientation().isLeftToRight()) {
            this.tfDate.setHorizontalAlignment(4);
        } else {
            this.tfDate.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.tfDate.setHorizontalAlignment(2);
        }
        ArrayList<IRecipient> fromRecipients = new ArrayList<IRecipient>();
        fromRecipients.add(this.selectedItem.getSender().getRecipient());
        this.tfFrom = new RecipientsTextField(fromRecipients, this.lbFrom);
        ControlsUtils.prepareHeaderTextField(this.tfFrom);
        this.tfTo = new RecipientsTextField(this.selectedItem.getToRecipients(), this.lbTo);
        ControlsUtils.prepareHeaderTextField(this.tfTo);
        this.tfCC = new RecipientsTextField(this.selectedItem.getCcRecipients(), this.lbCC);
        ControlsUtils.prepareHeaderTextField(this.tfCC);
        this.tfBC = new RecipientsTextField(this.selectedItem.getBcRecipients(), this.lbBC);
        ControlsUtils.prepareHeaderTextField(this.tfBC);
        this.tfWhere = new UneditableTextField(this.lbWhere);
        ControlsUtils.prepareHeaderTextField(this.tfWhere);
        this.tfWhen = new UneditableTextField(this.lbWhen);
        ControlsUtils.prepareHeaderTextField(this.tfWhen);
        this.tfDateStart = new UneditableTextField(this.lbDateStart);
        ControlsUtils.prepareHeaderTextField(this.tfDateStart);
        this.tfDateEnd = new UneditableTextField(this.lbDateEnd);
        ControlsUtils.prepareHeaderTextField(this.tfDateEnd);
        this.tfPriority = new UneditableTextField(this.lbPriority);
        ControlsUtils.prepareHeaderTextField(this.tfPriority);
        this.tfPriority.setEditable(true);
        this.tfCaller = new UneditableTextField(this.lbCaller);
        ControlsUtils.prepareHeaderTextField(this.tfCaller);
        this.tfCompany = new UneditableTextField(this.lbCompany);
        ControlsUtils.prepareHeaderTextField(this.tfCompany);
        this.tfPhone = new UneditableTextField(this.lbPhone);
        ControlsUtils.prepareHeaderTextField(this.tfPhone);
        this.isLazyInitialized = true;
    }

    private void setData() {
        String strSubject = this.selectedItem.getNativeItem().getSubject();
        this.tfSubject.setText(strSubject);
        this.tfSubject.setToolTipText(strSubject);
        this.tfDate.setText(OptionManager.getInstance().getDateTimeOptions().getMainWindowString(this.selectedItem.getDate()));
        ArrayList<IRecipient> fromRecipients = new ArrayList<IRecipient>();
        fromRecipients.add(this.selectedItem.getSender().getRecipient());
        this.tfFrom.setRecipients(fromRecipients);
        this.tfTo.setRecipients(this.selectedItem.getToRecipients());
        this.tfCC.setRecipients(this.selectedItem.getCcRecipients());
        this.tfBC.setRecipients(this.selectedItem.getBcRecipients());
        if (this.selectedItem instanceof AppointmentItem) {
            this.tfWhere.setText(((AppointmentItem)this.selectedItem).getLocation());
            Date startDate = ((AppointmentItem)this.selectedItem).getStartDate();
            this.tfWhen.setText(OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(startDate) + " " + StringResources.L_AT + " " + OptionManager.getInstance().getDateTimeOptions().getTime(startDate) + " " + GWCalendarUtils.getDurationText(((AppointmentItem)this.selectedItem).getDuration()));
        } else if (this.selectedItem instanceof TaskItem) {
            long assignedDate = ((TaskItem)this.selectedItem).getDateTaskAssigned();
            this.tfDateStart.setText(OptionManager.getInstance().getDateTimeOptions().getMainWindowString(new Date(assignedDate)));
            this.tfDateEnd.setText(OptionManager.getInstance().getDateTimeOptions().getMainWindowString(((TaskItem)this.selectedItem).getEndDate()));
            this.tfPriority.setText(((TaskItem)this.selectedItem).getTaskPriority());
        } else if (this.selectedItem instanceof PhoneItem) {
            this.tfCaller.setText(((PhoneItem)this.selectedItem).getCaller());
            this.tfCompany.setText(((PhoneItem)this.selectedItem).getCompany());
            this.tfPhone.setText(((PhoneItem)this.selectedItem).getPhone());
            this.tfSubject.setText(null);
        }
        this.tfDateEnd.setCaretPosition(0);
        this.tfDateStart.setCaretPosition(0);
        this.tfPhone.setCaretPosition(0);
        this.tfWhen.setCaretPosition(0);
        this.tfDate.setCaretPosition(0);
        this.tfCaller.setCaretPosition(0);
        this.tfCompany.setCaretPosition(0);
        this.tfWhere.setCaretPosition(0);
        this.tfSubject.setCaretPosition(0);
        this.tfTo.setCaretPosition(0);
        this.tfCC.setCaretPosition(0);
        this.tfBC.setCaretPosition(0);
        this.tfFrom.setCaretPosition(0);
    }

    private void clearPane() {
        this.removeAll();
        if (this.pnlEmpty == null) {
            this.pnlEmpty = new SkinnablePanel();
            ControlsUtils.prepareHeaderPanel(this.pnlEmpty);
            this.pnlEmpty.setPreferredSize(new Dimension(100, 24));
        }
        this.add((Component)this.pnlEmpty, "Center");
    }

    private static void setBoldFont(JComponent theComponent) {
        theComponent.setFont(Utils.deriveFont(theComponent.getFont(), 1));
    }

    public void setAlignColons(boolean theAlign) {
        this.alignColons = theAlign;
        this.alignColons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alignColons() {
        final int alignment = this.alignColons && this.selectedItem != null ? 11 : 10;
        this.setColonsAligment(alignment);
        GWItemPropertiesPanel gWItemPropertiesPanel = this;
        synchronized (gWItemPropertiesPanel) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWItemPropertiesPanel.this.setColonsAligment(alignment);
                }
            });
        }
    }

    private void setColonsAligment(int theAligment) {
        if (this.pnlCenter != null && this.pnlCenter.getLayout() != null) {
            GridBagLayout bagLayout = (GridBagLayout)this.pnlCenter.getLayout();
            int anchor = 0;
            switch (theAligment) {
                case 10: {
                    anchor = 21;
                    break;
                }
                case 11: {
                    anchor = 22;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong alignment constant");
                }
            }
            for (Component component : new Component[]{this.lbFrom, this.lbTo, this.lbWhen, this.lbWhere, this.lbCaller, this.lbPhone, this.lbSubject, this.lbDateStart, this.lbCC, this.lbBC}) {
                GridBagConstraints c = bagLayout.getConstraints(component);
                c.anchor = anchor;
                bagLayout.setConstraints(component, c);
            }
            bagLayout.layoutContainer(this.pnlCenter);
            this.validate();
        }
    }

    public void updateEmbededMailButtonText() {
        String name = "";
        IdentifiedObject selected = null;
        if (this.isAttachmentViewVisible && this.selectedItemForPopup != null) {
            name = this.selectedItemForPopup.getSubject();
            selected = this.selectedItemForPopup;
        } else if (this.selectedAttachment != null) {
            name = this.selectedAttachment.getName();
            selected = this.selectedAttachment;
        } else if (this.selectedItem != null) {
            name = this.selectedItem.getSubject();
            selected = this.selectedItemForPopup;
        }
        this.lbEmbeddedMail.setText(name);
        this.originalEmbeddedMailText = name;
        this.getEnvelopMessageTree().setSelectedObject(selected);
    }

    public AbstractItem getParentItem() {
        return this.parentItem;
    }

    public void setParentItem(AbstractItem parentItem) {
        if (parentItem != null && this.selectedItem != this.parentItem) {
            boolean isFrameOpen;
            this.parentItem = parentItem;
            boolean bl = isFrameOpen = this.getController().getParentController(FrameOpenActionList.class) != null;
            if (!this.attachmentViewVisibleWasSet) {
                this.isAttachmentViewVisible = MessageUtils.showAttachmentWindow(isFrameOpen, this.parentItem.getNativeItem());
                this.attachmentViewVisibleWasSet = true;
            }
        }
    }

    private boolean isAttachmentViewVisible() {
        boolean isFrameOpen;
        boolean bl = isFrameOpen = this.getController().getParentController(FrameOpenActionList.class) != null;
        if (isFrameOpen) {
            return this.isAttachmentViewVisible;
        }
        return ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE", true);
    }

    public void save() {
        AbstractItem item = this.getParentItem();
        if (item instanceof TaskItem) {
            ((TaskItem)item).setTaskPriority(this.tfPriority.getText());
        }
    }

    private void updateEmbeddedButton(boolean isVisible) {
        if (this.pnlTemp != null) {
            boolean showEmbeddedButton;
            boolean bl = showEmbeddedButton = !isVisible && this.hasAttachments() || this.hasEnvelopeMessages();
            if (showEmbeddedButton) {
                this.updateEmbededMailButtonText();
            }
            this.pnlTemp.setVisible(showEmbeddedButton);
        }
    }

    protected void updateEmbeddedButton() {
        this.updateEmbeddedButton(this.isAttachmentViewVisible());
    }

    public void updateMessageTree(boolean isAttachmentWindowVisible) {
        this.isAttachmentViewVisible = isAttachmentWindowVisible;
        if (this.pnlTemp != null) {
            this.updateEmbeddedButton(isAttachmentWindowVisible);
            this.updateUI();
            this.getEnvelopMessageTree().rebuild(!isAttachmentWindowVisible);
        }
    }

    public void updateMessageTree() {
        this.updateMessageTree(this.isAttachmentViewVisible());
    }

    public void setHideSystemAttachments(boolean hideSystemAttachments) {
        this.hideSystemAttachments = hideSystemAttachments;
        this.getEnvelopMessageTree().setHideSystemAttachments(this.hideSystemAttachments);
        this.updateMessageTree();
    }

    private GradientPanel getRecursComponent() {
        assert (((INote)this.selectedItem.getNativeItem()).isAutodate());
        if (this.cmpRecurs != null) {
            return this.cmpRecurs;
        }
        FocusableLabel component = new FocusableLabel(StringResources.RECURS, ImageResources.ARROW_DOWN, 0);
        component.setHorizontalTextPosition(10);
        Font boldFont = component.getFont().deriveFont(1);
        component.setFont(boldFont);
        component.setInfluenceFocusGained(ComponentInfluence.FONT_UNDERLINED_ON);
        component.setInfluenceFocusLost(ComponentInfluence.FONT_UNDERLINED_OFF);
        component.clearPropertyBindings();
        component.putSkinProperty(SkinProperty.HEADER_FONT_SIZE, ComponentProperty.FONT_SIZE);
        DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
        INote note = (INote)this.selectedItem.getNativeItem();
        Date currentNoteDate = note.getStartDate();
        Date[] dates = note.getAutoDate();
        IItem[] items = note.getAutoDateItems();
        GWCommandManager commandManager = GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController()));
        GWPopupMenu popupMenu = new GWPopupMenu();
        for (int i = 0; i < dates.length; ++i) {
            AbstractItem abstractItem;
            try {
                abstractItem = commandManager.getGWItem((IMessage)items[i]);
            }
            catch (GWCommandException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
                continue;
            }
            String dateString = dateTimeOptions.getGeneralDateString(dates[i]);
            JMenuItem menuItem = MenuItemFactory.createCkeckBoxMenuItem(dateString);
            menuItem.setSelected(currentNoteDate.equals(dates[i]));
            OpenRecurringItemActionListener actionListener = new OpenRecurringItemActionListener(abstractItem, this.getController());
            menuItem.addActionListener(actionListener);
            popupMenu.add(menuItem);
        }
        GradientPanel panel = new GradientPanel();
        panel.add(component);
        panel.propagateMouseListener();
        panel.setPopupMenu(popupMenu);
        this.cmpRecurs = panel;
        return panel;
    }

    public void setNotificationVisible(boolean isVisible) {
        this.itemNotificationClickableBar.setVisible(isVisible);
    }

    private class ClickableNotificationMouseListener
    extends MouseAdapter {
        private Component owner;
        private String message;
        private String title;
        private int messageType;

        public ClickableNotificationMouseListener(Component anOwner, String aMessage, String aTitle, int aMessageType) {
            this.owner = anOwner;
            this.message = aMessage;
            this.title = aTitle;
            this.messageType = aMessageType;
        }

        public void mousePressed(MouseEvent e) {
            JOptionPane.showMessageDialog(this.owner, this.message, this.title, this.messageType);
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(new Cursor(0));
        }

        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(new Cursor(12));
        }
    }

    private class SecurityErrorMouseListener
    extends MouseAdapter {
        private SecurityErrorMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            GWItemPropertiesPanel.this.showSecurityErrorMessage();
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(new Cursor(0));
        }

        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(new Cursor(12));
        }
    }

    private class HeaderSizeAdapter
    extends ComponentAdapter {
        private HeaderSizeAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            super.componentResized(e);
            GWItemPropertiesPanel.this.performTextCutting();
        }
    }

    private class OpenRecurringItemActionListener
    implements ActionListener {
        private MVCController controller = null;
        private AbstractItem item = null;

        private OpenRecurringItemActionListener(AbstractItem item, MVCController controller) {
            this.item = item;
            this.controller = controller;
        }

        public void actionPerformed(ActionEvent e) {
            if (GWClient.getOpenFrame(this.item) != null) {
                return;
            }
            ApplicationFrame parentWindow = ControlsUtils.getFrameForController(this.controller);
            MessageUtils.openItem(null, this.item, ControlsUtils.getUserGuid(parentWindow.getController()), true);
        }
    }
}

