/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.listener.ListenerType;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.OrderedComponentsFocusTraversalPolicy;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.itemview.AbstractAutoSavePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesEditDialog;
import com.novell.gw.jclient.application.frames.options.compose.send.SelectCategoryControl;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class GWItemPropertiesPersonalizePanel
extends AbstractAutoSavePanel {
    private static Logger logger = Logger.getLogger(GWItemPropertiesPersonalizePanel.class);
    private AbstractItem abstractItem;
    private JTextField tfSubject = new GWTextField();
    private JTextArea taNotes = new GWTextArea();
    private SelectCategoryControl tfSelectCategory;
    private JButton btnEditCategories = new JButton(StringResources.EDIT_CATEGORIES);
    private HashMap<JComponent, Boolean> fieldsChangeStatus = new HashMap(3);
    private boolean valuesAreAdjusting = false;
    private boolean threwSaveCommand = false;
    private boolean hasToCatchSaveCommand = false;

    public GWItemPropertiesPersonalizePanel(MVCController theParentController, AbstractItem theAbstractItem) {
        super(theParentController);
        this.setName(StringResources.PERSONALIZE);
        this.abstractItem = theAbstractItem;
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        this.tfSelectCategory = new SelectCategoryControl(CategoryUtils.createNewCategoryList(userGuid), userGuid);
        this.initFieldsChangeStatus();
        this.buildUI();
        this.collectValues();
        this.addListeners();
        this.setName(StringResources.PERSONALIZE);
    }

    private void initFieldsChangeStatus() {
        this.fieldsChangeStatus.put(this.tfSubject, Boolean.FALSE);
        this.fieldsChangeStatus.put(this.taNotes, Boolean.FALSE);
        this.fieldsChangeStatus.put(this.tfSelectCategory, Boolean.FALSE);
    }

    public void processPanelSelected() {
        this.tfSubject.requestFocusInWindow();
    }

    private void addListeners() {
        ArrayList<JComponent> componentList = new ArrayList<JComponent>();
        componentList.add(this.tfSubject);
        componentList.add(this.taNotes);
        componentList.add(this.tfSelectCategory);
        componentList.add(this.btnEditCategories);
        this.setFocusTraversalPolicy(new OrderedComponentsFocusTraversalPolicy(componentList));
        this.setFocusTraversalPolicyProvider(true);
        this.taNotes.getDocument().addDocumentListener(new CurrentDocumentListener(this.taNotes));
        this.tfSelectCategory.getDocument().addDocumentListener(new CurrentDocumentListener(this.tfSelectCategory));
        this.tfSubject.getDocument().addDocumentListener(new CurrentDocumentListener(this.tfSubject));
        if (this.isQuickView) {
            this.findAllChildComponents(this);
            for (Component component : this.components) {
                AbstractAutoSavePanel.CurrentFocusAdapter currentFocusAdapter = new AbstractAutoSavePanel.CurrentFocusAdapter();
                ControlsUtils.getListenerManager(this.controller).addListener(component, currentFocusAdapter, ListenerType.FOCUS_LISTENER);
            }
        }
        Level level = this.controller.getLevel();
        this.controller.addListenerDescriptor(new AppEventListenerDescriptor(level, 1940, new PERSONALIZE_PANEL_SAVE_PERFORMED_Listener()));
        this.controller.addListenerDescriptor(new AppEventListenerDescriptor(level, 1950, new ITEM_LIST_REFRESHED_Listener()));
    }

    private void collectValues() {
        if (this.abstractItem == null) {
            return;
        }
        this.valuesAreAdjusting = true;
        if (this.abstractItem.getCategories() != null) {
            this.tfSelectCategory.setCategories(this.abstractItem.getCategories());
        }
        this.tfSubject.setText(this.abstractItem.getPersonalizeSubject());
        this.taNotes.setText(this.abstractItem.getPersonalizeNote());
        this.valuesAreAdjusting = false;
    }

    private void buildUI() {
        this.taNotes.setRows(4);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 5, 5);
        this.add((Component)new OrientableLabel(StringResources.MY_SUBJECT), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.insets = new Insets(10, 5, 5, 10);
        this.add((Component)this.tfSubject, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.anchor = 23;
        c.fill = 0;
        c.insets = new Insets(5, 10, 5, 10);
        this.add((Component)new OrientableLabel(StringResources.MY_NOTES), c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.anchor = 21;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 10);
        JScrollPane scroll = new JScrollPane(this.taNotes);
        scroll.setPreferredSize(new Dimension(this.taNotes.getPreferredSize().width, this.taNotes.getPreferredSize().height + 3));
        scroll.setVerticalScrollBarPolicy(21);
        this.add((Component)scroll, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)new OrientableLabel(StringResources.CATEGORIES_C), c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        this.add((Component)this.tfSelectCategory, c);
        c.gridx = 2;
        c.gridy = 2;
        c.weightx = 0.0;
        this.add((Component)this.btnEditCategories, c);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        this.add((Component)new JPanel(), c);
        this.btnEditCategories.addActionListener(new ActionEditCategories());
    }

    public void loadContent() {
    }

    public void setItem(AbstractItem item) {
        this.saveChanges();
        if (this.abstractItem == null || !this.abstractItem.equals(item)) {
            this.hasToCatchSaveCommand = false;
            this.abstractItem = item;
            this.collectValues();
        }
    }

    public void save() {
        if (this.abstractItem != null) {
            String subject = null;
            String notes = null;
            ICategoryList categories = this.tfSelectCategory.getCategories();
            if (this.fieldsChangeStatus.get(this.tfSubject).booleanValue()) {
                subject = this.tfSubject.getText();
            }
            if (this.fieldsChangeStatus.get(this.taNotes).booleanValue()) {
                notes = this.taNotes.getText();
            }
            if (subject != null || notes != null || this.fieldsChangeStatus.get(this.tfSelectCategory).booleanValue()) {
                this.abstractItem.updatePersonalizeData(subject, notes, categories);
                this.threwSaveCommand = true;
                this.controller.processCommand(new GlobalCommand(1940, this.abstractItem));
                this.initFieldsChangeStatus();
            }
        }
    }

    private class ITEM_LIST_REFRESHED_Listener
    extends AppEventListener {
        private ITEM_LIST_REFRESHED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            GWItemPropertiesPersonalizePanel panel = GWItemPropertiesPersonalizePanel.this;
            if (panel.hasToCatchSaveCommand) {
                panel.collectValues();
            }
        }
    }

    private class PERSONALIZE_PANEL_SAVE_PERFORMED_Listener
    extends AppEventListener {
        private PERSONALIZE_PANEL_SAVE_PERFORMED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            GWItemPropertiesPersonalizePanel panel = GWItemPropertiesPersonalizePanel.this;
            if (!panel.threwSaveCommand) {
                AbstractItem eventItem = (AbstractItem)theEvent.getData();
                if (panel.abstractItem.equals(eventItem)) {
                    panel.hasToCatchSaveCommand = true;
                }
            } else {
                panel.threwSaveCommand = false;
            }
        }
    }

    private class CurrentDocumentListener
    implements DocumentListener {
        JComponent parent;

        public CurrentDocumentListener(JComponent parent) {
            this.parent = parent;
        }

        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void changedUpdate(DocumentEvent e) {
            if (GWItemPropertiesPersonalizePanel.this.valuesAreAdjusting) {
                return;
            }
            GWItemPropertiesPersonalizePanel.this.fieldsChangeStatus.put(this.parent, Boolean.TRUE);
            GWItemPropertiesPersonalizePanel.this.startTimer();
        }
    }

    private class ActionEditCategories
    implements ActionListener {
        private ActionEditCategories() {
        }

        public void actionPerformed(ActionEvent e) {
            ICategoryList c = CategoriesEditDialog.show(SwingUtilities.getWindowAncestor(GWItemPropertiesPersonalizePanel.this), GWItemPropertiesPersonalizePanel.this.controller, GWItemPropertiesPersonalizePanel.this.tfSelectCategory.getCategories());
            if (c != null) {
                GWItemPropertiesPersonalizePanel.this.tfSelectCategory.setCategories(c);
            }
        }
    }
}

