/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.components.htmleditor.BrowserType;
import com.appframework.components.htmleditor.GWBrowserFactory;
import com.appframework.components.htmleditor.GWMozillaBrowser;
import com.appframework.components.htmleditor.HTMLTextViewer;
import com.appframework.components.htmleditor.SimpleHTMLViewer;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ItemBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.PathManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;

public class ItemProperties
extends OrientablePanel
implements ItemBox {
    private static Logger logger = Logger.getLogger(ItemProperties.class);
    private boolean contentRead = false;
    private SimpleHTMLViewer htmlViewer;
    private AbstractItem item;

    public ItemProperties(MVCController parentController) {
        this.htmlViewer = GWClient.USE_EXTERNAL_HTML_VIEWER() ? GWBrowserFactory.getBrowser(parentController, BrowserType.ITEM_PROPERTIES) : new HTMLTextViewer();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.htmlViewer), "Center");
        this.setName(StringResources.PROPERTIES);
    }

    public void clear() {
        this.htmlViewer.clear();
    }

    private void readHtmlContent() {
        if (!this.contentRead) {
            String propertyFilePath = PathManager.getTempFolderPath() + File.separator + this.item.getID() + ".html";
            this.item.getNativeItem().getInfoFile(propertyFilePath);
            this.contentRead = true;
            File file = new File(propertyFilePath);
            if (file.exists()) {
                try {
                    this.htmlViewer.setPage(file.toURL());
                }
                catch (MalformedURLException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    public void release() {
        if (GWClient.USE_EXTERNAL_HTML_VIEWER()) {
            GWBrowserFactory.releaseBrowser((GWMozillaBrowser)this.htmlViewer);
        }
    }

    public void setItem(AbstractItem item) {
        this.contentRead = false;
        this.item = item;
    }

    public AbstractItem getItem() {
        return this.item;
    }

    public void loadContent() {
        this.readHtmlContent();
    }
}

