/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.actions;

import com.appframework.ActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.header.actions.ActionChangeHeaderFontSize;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.application.controls.skinnable.ComponentPropertyManager;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JRadioButtonMenuItem;

public class ActionChangeEmbHeaderFontSize
extends ActionChangeHeaderFontSize {
    public ActionChangeEmbHeaderFontSize(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.CHANGE_EMB_HEADER_FONT_SIZE, StringResources.HEADER_FONT_SIZE);
        this.headerTextSize = (Integer)ComponentPropertyManager.getInstance().getSkinPropertyValue(SkinProperty.HEADER_PARENT_FONT_SIZE);
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 620, new EMB_HEADER_TEXT_SIZE_CHANGED_EventListener()));
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(int i) {
        OrientableRadioButtonMenuItem menuItem = new OrientableRadioButtonMenuItem(new SubAction(textSizes[i]));
        return menuItem;
    }

    private class SubAction
    extends AbstractAction {
        private int textSize;

        public SubAction(int value) {
            super(String.valueOf(value));
            this.textSize = value;
        }

        public void actionPerformed(ActionEvent e) {
            GlobalCommand command = new GlobalCommand(620, this.textSize);
            ActionChangeEmbHeaderFontSize.this.getActionList().processCommand(command);
            DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
            dataStoreSettings.setHeaderParentFontSize(this.textSize);
            dataStoreSettings.setHeaderSettings();
            ComponentPropertyManager.getInstance().updateProperty(SkinProperty.HEADER_PARENT_FONT_SIZE, this.textSize);
        }
    }

    private class EMB_HEADER_TEXT_SIZE_CHANGED_EventListener
    extends AppEventListener {
        private EMB_HEADER_TEXT_SIZE_CHANGED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            ActionChangeEmbHeaderFontSize.this.headerTextSize = (Integer)theEvent.getData();
            ActionChangeEmbHeaderFontSize.this.selectMenuItem();
        }
    }
}

