/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.contentviewer;

import com.appframework.components.htmleditor.HTMLExternalTextViewer;
import com.appframework.components.htmleditor.HTMLTextViewer;
import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.ContentViewerController;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.HTMLViewerHyperlinkListener;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.HTMLViewerStatusbarHyperlinkListener;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.RtfLinkController;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageViewer;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentViewer
extends JComponent
implements MVCView<ContentViewerController, Object> {
    private static Logger logger = Logger.getLogger(ContentViewer.class);
    private HTMLViewer messageViewer;
    private ImageViewer imageViewer;
    private static final String MESSAGE_VIEWER = "MESSAGE_VIEWER";
    private static final String IMAGE_VIEWER = "IMAGE_VIEWER";
    private CardLayout cardLayout;
    private ContentViewerController controller;

    public ContentViewer(MVCController parentController) {
        this.controller = new ContentViewerController(this, parentController);
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        RtfLinkController rtfLinkController = new RtfLinkController(parentController);
        if (GWClient.USE_EXTERNAL_HTML_VIEWER()) {
            this.messageViewer = new HTMLExternalTextViewer(parentController);
            this.messageViewer.setMode(2);
            ((HTMLExternalTextViewer)this.messageViewer).addRTFViewerMouseListeners(rtfLinkController, rtfLinkController);
        } else {
            this.messageViewer = new HTMLTextViewer();
            ((HTMLTextViewer)this.messageViewer).addHyperlinkListener(new HTMLViewerHyperlinkListener());
            ((HTMLTextViewer)this.messageViewer).addHyperlinkListener(new HTMLViewerStatusbarHyperlinkListener(parentController));
            this.messageViewer.getTextComponent().addMouseListener(rtfLinkController);
            this.messageViewer.getTextComponent().addMouseMotionListener(rtfLinkController);
        }
        this.messageViewer.setDragEnabled(true);
        this.messageViewer.setPreferredSize(new Dimension(1, 20));
        this.messageViewer.setBorder(BorderFactory.createEmptyBorder());
        this.loadProxySettings();
        this.add((Component)this.messageViewer, MESSAGE_VIEWER);
        this.imageViewer = new ImageViewer();
        this.imageViewer.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.imageViewer, IMAGE_VIEWER);
        this.showPanel(MESSAGE_VIEWER);
    }

    void loadProxySettings() {
        this.messageViewer.setProxyConfiguration(OptionManager.getInstance().getEnvironmentOptions().getProxyConfiguration());
        logger.debug((Object)"proxy settings reloaded");
    }

    private void showPanel(String thePanelLayoutName) {
        if (thePanelLayoutName.equals(MESSAGE_VIEWER)) {
            if (!this.messageViewer.isVisible()) {
                this.cardLayout.show(this, MESSAGE_VIEWER);
            }
        } else if (thePanelLayoutName.equals(IMAGE_VIEWER) && !this.imageViewer.isVisible()) {
            this.cardLayout.show(this, IMAGE_VIEWER);
        }
    }

    public void clear() {
        this.messageViewer.clear();
        this.imageViewer.clear();
    }

    public void setupImage(String theFilePath) {
        this.imageViewer.setImage(theFilePath);
        this.showPanel(IMAGE_VIEWER);
    }

    public void setupHTMLPage(String theFilePath) {
        GWException exception = new GWException("\n Client can not load message body: \n\n Message body file : \n" + theFilePath);
        if (theFilePath == null || theFilePath.length() == 0) {
            String htmlText = "<html><body><b>" + HTMLUtils.normalizeTextToHTML(StringResources.HTML_ONLY_WARNING, false) + "</b></body></html>";
            this.messageViewer.setMode(1);
            this.messageViewer.setStyledText(htmlText);
        } else {
            try {
                File f = new File(theFilePath);
                if (!f.exists() || f.isDirectory()) {
                    logger.error((Object)exception, (Throwable)exception);
                    ErrorDialog.processGWException(exception);
                } else {
                    this.messageViewer.setMode(1);
                    this.messageViewer.setPage(f.toURI().toURL());
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
        }
        this.showPanel(MESSAGE_VIEWER);
    }

    public void setupMessage(String theMessage) {
        this.messageViewer.setMode(2);
        this.messageViewer.setPlainText(theMessage);
        this.messageViewer.setCaretPosition(0);
        this.showPanel(MESSAGE_VIEWER);
    }

    public void setupRTF(String theFilePath) {
        this.setupRTFMessage(ControlsUtils.getPage(theFilePath));
    }

    public void setupRTFMessage(String theMessage) {
        this.messageViewer.setMode(2);
        this.messageViewer.setStyledText(theMessage);
        this.messageViewer.setCaretPosition(0);
        this.showPanel(MESSAGE_VIEWER);
    }

    public void zoom(boolean isZoomIn) {
        this.messageViewer.zoom(isZoomIn);
    }

    public void resetZoom() {
        this.messageViewer.resetZoom();
    }

    public int getViewMode() {
        return this.messageViewer.getMode();
    }

    public JComponent getTextComponent() {
        return this.messageViewer;
    }

    public void enableImages(boolean enable, boolean reload) {
        this.messageViewer.enableImages(enable);
        if (reload) {
            this.messageViewer.reload();
        }
    }

    public void release() {
        this.messageViewer.release();
    }

    public HTMLViewer getMessageViewer() {
        return this.messageViewer;
    }

    @Override
    public ContentViewerController getController() {
        return this.controller;
    }

    @Override
    public void setController(ContentViewerController controller) {
        assert (false);
    }

    @Override
    public void setMVCModel(Object model) {
        assert (false);
    }

    @Override
    public Object getMVCModel() {
        assert (false);
        return null;
    }
}

