/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.contentviewer;

import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.HTMLViewerHyperlinkListener;
import com.novell.gw.jclient.application.controls.panelviews.BrowserPanel;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.apache.log4j.Logger;

public class RtfLinkController
extends MouseAdapter
implements MouseMotionListener {
    private static Logger logger = Logger.getLogger(BrowserPanel.class);
    private MVCController controller;
    private HTMLViewer htmlViewer;

    public RtfLinkController(MVCController controller) {
        this.controller = controller;
    }

    public RtfLinkController(MVCController controller, HTMLViewer htmlViewer) {
        this(controller);
        if (htmlViewer == null) {
            throw new IllegalArgumentException("htmlViewer is null");
        }
        this.htmlViewer = htmlViewer;
    }

    public void mouseMoved(MouseEvent ev) {
        Document doc;
        Point pt;
        int pos;
        JTextPane editor = (JTextPane)ev.getSource();
        if ((!editor.isEditable() && editor instanceof HTMLTextPane && ((HTMLTextPane)editor).getMode() == 2 || ((HTMLTextPane)editor).getMode() == 3) && (pos = editor.viewToModel(pt = new Point(ev.getX(), ev.getY()))) >= 0 && (doc = editor.getDocument()) instanceof DefaultStyledDocument) {
            DefaultStyledDocument hdoc = (DefaultStyledDocument)doc;
            Element e = hdoc.getCharacterElement(pos);
            AttributeSet a = e.getAttributes();
            String href = (String)a.getAttribute("hyperlink");
            if (href != null) {
                editor.setCursor(Cursor.getPredefinedCursor(12));
                Command command = new Command(630, href);
                this.controller.processCommand(command);
            } else {
                editor.setCursor(Cursor.getDefaultCursor());
                Command command = new Command(630, "");
                this.controller.processCommand(command);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        DefaultStyledDocument hdoc;
        Element el;
        AttributeSet a;
        String href;
        Document doc;
        Point pt;
        int pos;
        if (e.isPopupTrigger() || e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        JTextPane editor = (JTextPane)e.getSource();
        if ((!editor.isEditable() && editor instanceof HTMLTextPane && ((HTMLTextPane)editor).getMode() == 2 || ((HTMLTextPane)editor).getMode() == 3) && (pos = editor.viewToModel(pt = new Point(e.getX(), e.getY()))) >= 0 && (doc = editor.getDocument()) instanceof DefaultStyledDocument && (href = (String)(a = (el = (hdoc = (DefaultStyledDocument)doc).getCharacterElement(pos)).getAttributes()).getAttribute("hyperlink")) != null) {
            this.processUrl(href);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    private void processUrl(String url) {
        logger.debug((Object)("processing URL: " + url));
        HTMLViewerHyperlinkListener listener = this.htmlViewer != null ? new HTMLViewerHyperlinkListener() : new HTMLViewerHyperlinkListener(this.htmlViewer);
        listener.processURL(url);
    }
}

