/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.imageviewer;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageLoadException;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageReader;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageViewIcon;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageViewLabel;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class ImageViewer
extends JComponent {
    public static final int MEMORY_IMAGE_CACHE = 8000000;
    public static final int SIZE_ORIGINAL = 0;
    public static final int SIZE_FIT_BOTH = 1;
    public static final int SIZE_FIT_HEIGHT = 2;
    public static final int SIZE_FIT_WIDTH = 3;
    public static final int ROTATION_NONE = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    public static final int ZOOM_IN = 0;
    public static final int ZOOM_OUT = 1;
    public static final int ZOOM_RESET = 2;
    private static final int MAX_ZOOM = 90;
    private static final int MIN_ZOOM = -40;
    ImageViewIcon imageIcon = null;
    PlanarImage image = null;
    float fitScale = 1.0f;
    float zoomScale = 1.0f;
    float rotationAngle = 0.0f;
    ImageViewLabel imageLabel = null;
    JScrollPane scrollPane = null;
    ImageViewPopupMenu popup;
    int currentZoom = 0;
    private Point pressPoint;
    private int pressedMouseButton = 0;

    public ImageViewer() {
        JAI.getDefaultInstance().getTileCache().setMemoryCapacity(8000000L);
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.imageLabel = new ImageViewLabel();
        this.imageLabel.setVerticalAlignment(0);
        this.imageLabel.setHorizontalAlignment(0);
        this.scrollPane = new OrientableScrollPane(this.imageLabel, 20, 30);
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "Center");
        this.imageLabel.addMouseListener(new PopupListener());
        this.imageLabel.addMouseListener(new ImageMouseListener());
        this.imageLabel.addMouseMotionListener(new ImageDragListener());
        this.popup = new ImageViewPopupMenu();
        JScrollBar scrollBar = this.scrollPane.getHorizontalScrollBar();
        scrollBar.addMouseWheelListener(new HorizontalBarWheelMouseListener());
    }

    public void setImage(String theFilePath) {
        if (this.image != null) {
            this.clear();
        }
        try {
            this.image = ImageReader.readImage(theFilePath);
        }
        catch (ImageLoadException e) {
            this.image = ImageReader.getDefaultImage();
        }
        if (this.image != null) {
            this.setupImageIcon(this.image);
        }
    }

    private void setupImageIcon(PlanarImage theImage) {
        this.imageIcon = new ImageViewIcon((RenderedImage)theImage, this.getBackground());
        this.imageLabel.setIcon(this.imageIcon);
        this.repaint();
        this.revalidate();
    }

    public void clear() {
        if (this.image == null) {
            return;
        }
        this.image.dispose();
        this.fitScale = 1.0f;
        this.zoomScale = 1.0f;
        this.rotationAngle = 0.0f;
        this.imageLabel.setIcon(null);
        this.repaint();
    }

    public void fitImage(int theSizeState) {
        if (this.image == null) {
            return;
        }
        switch (theSizeState) {
            case 1: {
                this.fitScale = Math.min((float)this.scrollPane.getVisibleRect().getHeight() / (float)this.image.getHeight(), (float)this.scrollPane.getVisibleRect().getWidth() / (float)this.image.getWidth());
                this.currentZoom = 0;
                this.zoomScale = 1.0f;
                break;
            }
            case 2: {
                this.fitScale = (float)this.scrollPane.getVisibleRect().getHeight() / (float)this.image.getHeight();
                this.currentZoom = 0;
                this.zoomScale = 1.0f;
                break;
            }
            case 3: {
                this.fitScale = (float)this.scrollPane.getVisibleRect().getWidth() / (float)this.image.getWidth();
                this.currentZoom = 0;
                this.zoomScale = 1.0f;
                break;
            }
            case 0: {
                this.fitScale = 1.0f;
                this.currentZoom = 0;
                this.zoomScale = 1.0f;
                break;
            }
        }
        this.applyTransformation();
    }

    private void rotateImage(int theRotation) {
        if (this.image == null) {
            return;
        }
        switch (theRotation) {
            case 1: {
                this.rotationAngle += 1.5707964f;
                break;
            }
            case 2: {
                this.rotationAngle += (float)Math.PI;
                break;
            }
            case 3: {
                this.rotationAngle += 4.712389f;
                break;
            }
            case 0: {
                this.rotationAngle = 0.0f;
                break;
            }
        }
        this.applyTransformation();
    }

    private void zoomImage(int theZoom) {
        if (this.image == null) {
            return;
        }
        switch (theZoom) {
            case 0: {
                this.zoomIn();
                break;
            }
            case 1: {
                this.zoomOut();
                break;
            }
            case 2: {
                this.currentZoom = 0;
                break;
            }
        }
        this.zoomScale = (float)Math.abs(this.currentZoom) / 10.0f + 1.0f;
        if (this.currentZoom < 0) {
            this.zoomScale = 1.0f / this.zoomScale;
        }
        this.applyTransformation();
    }

    private void zoomIn() {
        this.currentZoom += 10;
        if (this.currentZoom >= 90) {
            this.currentZoom = 90;
        }
    }

    private void zoomOut() {
        this.currentZoom -= 10;
        if (this.currentZoom <= -40) {
            this.currentZoom = -40;
        }
    }

    private void applyTransformation() {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.image);
        pb.add(this.fitScale);
        pb.add(this.fitScale);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add(new InterpolationBilinear());
        RenderedOp theImage = JAI.create((String)"scale", (ParameterBlock)pb, null);
        pb = new ParameterBlock();
        pb.addSource(theImage);
        pb.add(this.zoomScale);
        pb.add(this.zoomScale);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add(new InterpolationBilinear());
        theImage = JAI.create((String)"scale", (ParameterBlock)pb, null);
        pb = new ParameterBlock();
        pb.addSource(theImage);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add(this.rotationAngle);
        pb.add(new InterpolationNearest());
        theImage = JAI.create((String)"Rotate", (ParameterBlock)pb, null);
        this.setupImageIcon((PlanarImage)theImage);
    }

    private class HorizontalBarWheelMouseListener
    implements MouseWheelListener {
        private HorizontalBarWheelMouseListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            int val = ImageViewer.this.scrollPane.getHorizontalScrollBar().getValue();
            ImageViewer.this.scrollPane.getHorizontalScrollBar().setValue(val + 3 * e.getWheelRotation());
        }
    }

    private class ImageDragListener
    extends MouseMotionAdapter {
        private ImageDragListener() {
        }

        public void mouseDragged(MouseEvent e) {
            if (ImageViewer.this.pressedMouseButton == 1) {
                Point dragPoint = e.getPoint();
                ImageViewer.this.setCursor(new Cursor(12));
                int x = ImageViewer.this.scrollPane.getHorizontalScrollBar().getValue() - (int)((double)(dragPoint.x - ((ImageViewer)ImageViewer.this).pressPoint.x) / 1.5);
                int y = ImageViewer.this.scrollPane.getVerticalScrollBar().getValue() - (int)((double)(dragPoint.y - ((ImageViewer)ImageViewer.this).pressPoint.y) / 1.5);
                ImageViewer.this.scrollPane.getHorizontalScrollBar().setValue(x);
                ImageViewer.this.scrollPane.getVerticalScrollBar().setValue(y);
                ImageViewer.this.pressPoint = dragPoint;
            }
        }
    }

    private class ImageMouseListener
    extends MouseAdapter {
        private ImageMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                ImageViewer.this.setCursor(new Cursor(12));
                ImageViewer.this.pressPoint = e.getPoint();
            }
            ImageViewer.this.pressedMouseButton = e.getButton();
        }

        public void mouseReleased(MouseEvent e) {
            ImageViewer.this.setCursor(new Cursor(0));
            ImageViewer.this.pressedMouseButton = 0;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ImageViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class ZoomAction
    extends AbstractAction {
        int zoom = 0;
        boolean selected = false;
        JMenuItem item;

        public ZoomAction(int theZoom) {
            this.zoom = theZoom;
            this.item = new JMenuItem(this);
            String name = "";
            ImageIcon icon = null;
            switch (this.zoom) {
                case 0: {
                    name = "In";
                    icon = ImageResources.ACT_ZOOM_IN;
                    break;
                }
                case 1: {
                    name = "Out";
                    icon = ImageResources.ACT_ZOOM_OUT;
                    break;
                }
                case 2: {
                    name = "Reset";
                    icon = ImageResources.ACT_ZOOM_RESET;
                    this.selected = true;
                    break;
                }
            }
            this.item.setSelected(this.selected);
            this.putValue("Name", name);
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent e) {
            ImageViewer.this.zoomImage(this.zoom);
        }

        public JMenuItem getMenuItem() {
            return this.item;
        }
    }

    class RotateAction
    extends AbstractAction {
        int rotation = 0;
        JMenuItem item;
        boolean selected = false;

        public RotateAction(int theRotation) {
            this.rotation = theRotation;
            this.item = new JMenuItem(this);
            String name = "";
            ImageIcon icon = null;
            switch (this.rotation) {
                case 0: {
                    name = "None";
                    icon = ImageResources.ACT_ROTATE_NONE;
                    this.selected = true;
                    break;
                }
                case 1: {
                    name = "90";
                    icon = ImageResources.ACT_ROTATE_90;
                    break;
                }
                case 2: {
                    name = "180";
                    icon = ImageResources.ACT_ROTATE_180;
                    break;
                }
                case 3: {
                    name = "270";
                    icon = ImageResources.ACT_ROTATE_270;
                    break;
                }
            }
            this.item.setSelected(this.selected);
            this.putValue("Name", name);
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent e) {
            ImageViewer.this.rotateImage(this.rotation);
        }

        public JMenuItem getMenuItem() {
            return this.item;
        }
    }

    class FitAction
    extends AbstractAction {
        int fit = 1;
        JMenuItem item;
        boolean selected = false;

        public FitAction(int theFit) {
            this.fit = theFit;
            this.item = OS.createMenuItemForAction(this, false);
            String name = "";
            ImageIcon icon = null;
            switch (this.fit) {
                case 1: {
                    name = "Fit to Window";
                    icon = ImageResources.ACT_FIT_TOWINDOW;
                    break;
                }
                case 2: {
                    name = "Fit to Window Height";
                    icon = ImageResources.ACT_FIT_TOHEIGHT;
                    break;
                }
                case 3: {
                    name = "Fit to Window Width";
                    icon = ImageResources.ACT_FIT_TOWIDTH;
                    break;
                }
                case 0: {
                    name = "Original Size";
                    icon = ImageResources.ACT_FIT_ORIGINAL;
                    this.selected = true;
                    break;
                }
            }
            this.item.setSelected(this.selected);
            this.putValue("Name", name);
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent e) {
            ImageViewer.this.fitImage(this.fit);
        }

        public JMenuItem getMenuItem() {
            return this.item;
        }
    }

    class ImageViewPopupMenu
    extends GWPopupMenu {
        public ImageViewPopupMenu() {
            GWMenu sizeMenu = new GWMenu("Size");
            sizeMenu.setIcon(ImageResources.ACT_FIT);
            FitAction fitOriginal = new FitAction(0);
            FitAction fitBoth = new FitAction(1);
            FitAction fitHeight = new FitAction(2);
            FitAction fitWeight = new FitAction(3);
            sizeMenu.add(fitOriginal.getMenuItem());
            sizeMenu.add(fitBoth.getMenuItem());
            sizeMenu.add(fitHeight.getMenuItem());
            sizeMenu.add(fitWeight.getMenuItem());
            this.add(sizeMenu);
            GWMenu rotationMenu = new GWMenu("Rotation");
            rotationMenu.setIcon(ImageResources.ACT_ROTATION);
            RotateAction rotateNone = new RotateAction(0);
            RotateAction rotate90 = new RotateAction(1);
            RotateAction rotate180 = new RotateAction(2);
            RotateAction rotate270 = new RotateAction(3);
            rotationMenu.add(rotateNone.getMenuItem());
            rotationMenu.add(rotate90.getMenuItem());
            rotationMenu.add(rotate180.getMenuItem());
            rotationMenu.add(rotate270.getMenuItem());
            this.add(rotationMenu);
            GWMenu zoomMenu = new GWMenu("Zoom");
            zoomMenu.setIcon(ImageResources.ACT_ZOOM);
            ZoomAction zoomIn = new ZoomAction(0);
            ZoomAction zoomOut = new ZoomAction(1);
            ZoomAction zoomReset = new ZoomAction(2);
            zoomMenu.add(zoomIn.getMenuItem());
            zoomMenu.add(zoomOut.getMenuItem());
            zoomMenu.add(zoomReset.getMenuItem());
            this.add(zoomMenu);
        }
    }
}

