/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.ActionList;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.mnemonic.MnemonicMenu;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FrameAddressBookMenuBar
extends GWMenuBar {
    private static Logger logger = Logger.getLogger(FrameAddressBookMenuBar.class);
    private ActionList actionList;

    public FrameAddressBookMenuBar(ActionList actionList) {
        this.actionList = actionList;
        this.build();
    }

    private void build() {
        this.add(this.buildFileMenu());
        this.add(this.buildEditMenu());
        this.add(this.buildViewMenu());
        this.add(this.buildMenuHelp());
    }

    private JMenu buildFileMenu() {
        MnemonicMenu menu = new MnemonicMenu(StringResources.MENU_FILE);
        menu.add(this.actionList.getAction(ActionKey.CREATE_ADDRESSBOOK).getMenuItem());
        menu.add(this.actionList.getAction(ActionKey.DELETE_ADDRESSBOOKS).getMenuItem());
        menu.add(this.actionList.getAction(ActionKey.RENAME_ADDRESS_BOOK).getMenuItem());
        menu.addSeparator();
        JMenuItem menuItem = this.actionList.getAction(ActionKey.NEW_MAIL).getMenuItem();
        UIUtils.setText(menuItem, StringResources.ACTION_SEND_MAIL);
        menu.add(menuItem);
        menuItem = this.actionList.getAction(ActionKey.NEW_APPOINTMENT).getMenuItem();
        UIUtils.setText(menuItem, StringResources.ACTION_SEND_APPOINTMENT);
        menu.add(menuItem);
        menuItem = OS.createMenuItem(this.actionList.getAction(ActionKey.NEW_TASK));
        UIUtils.setText(menuItem, StringResources.ACTION_SEND_TASK);
        menu.add(menuItem);
        menuItem = OS.createMenuItem(this.actionList.getAction(ActionKey.NEW_REMINDERNOTE));
        UIUtils.setText(menuItem, StringResources.ACTION_SEND_NOTE);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = OS.createMenuItem(this.actionList.getAction(ActionKey.PRINT_ADDRESSBOOK));
        UIUtils.setText(menuItem, StringResources.ACTION_PRINT_D);
        menu.add(menuItem);
        menu.addSeparator();
        menu.add(this.actionList.getAction(ActionKey.NCC_SEARCH_ORDER).getMenuItem());
        menu.addSeparator();
        menuItem = this.actionList.getAction(ActionKey.CLOSE_FRAME).getMenuItem();
        if (!OS.isMacOS()) {
            UIUtils.setText(menuItem, StringResources.ACTION_EXIT);
        }
        menu.add(menuItem);
        return menu;
    }

    private JMenu buildEditMenu() {
        MnemonicMenu menu = new MnemonicMenu(StringResources.MENU_EDIT);
        JMenuItem item = this.actionList.getAction(ActionKey.CREATE_CONTACT).getMenuItem();
        menu.add(item);
        item = this.actionList.getAction(ActionKey.VIEW_CONTACT_DETAILS).getMenuItem();
        UIUtils.setText(item, StringResources.ACTION_EDIT);
        item.setToolTipText(StringResources.ACTION_EDIT);
        menu.add(item);
        item = this.actionList.getAction(ActionKey.COPY_CONTACTS).getMenuItem();
        menu.add(item);
        item = this.actionList.getAction(ActionKey.DELETE_CONTACT).getMenuItem();
        menu.add(item);
        menu.addSeparator();
        item = this.actionList.getAction(ActionKey.CUT).getMenuItem();
        menu.add(item);
        item = this.actionList.getAction(ActionKey.COPY).getMenuItem();
        menu.add(item);
        item = this.actionList.getAction(ActionKey.PASTE).getMenuItem();
        menu.add(item);
        item = this.actionList.getAction(ActionKey.SELECT_ALL).getMenuItem();
        UIUtils.setMnemonic(item, 2);
        menu.add(item);
        return menu;
    }

    private JMenu buildViewMenu() {
        MnemonicMenu menu = new MnemonicMenu(StringResources.MENU_VIEW);
        JMenuItem menuItem = this.actionList.getAction(ActionKey.VIEW_CONTACT_DETAILS).getMenuItem();
        UIUtils.setText(menuItem, StringResources.ACTION_DETAILS);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.actionList.getAction(ActionKey.NAME_FORMAT).getMenuItem();
        UIUtils.setText(menuItem, StringResources.NAME_FORMAT_D);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.actionList.getAction(ActionKey.REFRESH_ADDRESSBOOK).getMenuItem();
        UIUtils.setText(menuItem, StringResources.ACTION_REFRESH);
        menu.add(menuItem);
        if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
            menuItem = this.actionList.getAction(ActionKey.RETRIEVE_SYSTEM_ADDRESS_BOOK).getMenuItem();
            menu.add(menuItem);
            menuItem = this.actionList.getAction(ActionKey.RETRIEVE_PERSONAL_ADDRESS_BOOKS).getMenuItem();
            menu.add(menuItem);
        }
        return menu;
    }

    private JMenu buildMenuHelp() {
        MnemonicMenu menu = new MnemonicMenu(StringResources.MENU_HELP);
        JMenuItem item = this.actionList.getAction(ActionKey.HELPTOPICS).getMenuItem();
        menu.add(item);
        item = this.actionList.getAction(ActionKey.USER_GUIDE).getMenuItem();
        menu.add(item);
        menu.addSeparator();
        item = this.actionList.getAction(ActionKey.HOMEPAGE).getMenuItem();
        menu.add(item);
        if (!OS.isMacOS()) {
            menu.addSeparator();
            item = this.actionList.getAction(ActionKey.ABOUT).getMenuItem();
            menu.add(item);
        }
        return menu;
    }
}

