/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.ActionList;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.AppointmentItemPopupMenu;
import com.novell.gw.jclient.application.controls.menus.AttachedMessagePopupMenu;
import com.novell.gw.jclient.application.controls.menus.AttachmentPopupMenu;
import com.novell.gw.jclient.application.controls.menus.AttachmentsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.CalendarItemPopupMenu;
import com.novell.gw.jclient.application.controls.menus.CalendarViewGWItemPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWItemPopupMenu;
import com.novell.gw.jclient.application.controls.menus.MultipleItemsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.NNTPItemPopupMenu;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class PopupMenuFactory {
    private static final Logger logger = Logger.getLogger(PopupMenuFactory.class);

    public static AbstractActionsPopupMenu createGWItemPopupMenu(AbstractFolder folder, IItemList itemList, AbstractItem item, ActionList actionList) {
        return PopupMenuFactory.createGWItemPopupMenu(actionList, folder, itemList, item, null);
    }

    public static AbstractActionsPopupMenu createGWItemPopupMenu(ActionList actionList, AbstractFolder folder, IItemList itemList, AbstractItem item, String columnName) {
        if (folder.getType().equals(StringResources.NEWSGROUPS)) {
            return new NNTPItemPopupMenu(actionList, folder, itemList, item, columnName);
        }
        if (item instanceof AppointmentItem) {
            return new AppointmentItemPopupMenu(actionList, folder, itemList, item, columnName);
        }
        if (item instanceof TaskItem) {
            return new CalendarItemPopupMenu(actionList, folder, itemList, item, columnName);
        }
        if (item instanceof ReminderNote) {
            return new CalendarItemPopupMenu(actionList, folder, itemList, item, columnName);
        }
        return new GWItemPopupMenu(actionList, folder, itemList, item, columnName);
    }

    public static MultipleItemsPopupMenu createMultipleItemsPopupMenu(AbstractFolder folder, ActionList theActionList, IItemList itemList) {
        return new MultipleItemsPopupMenu(folder, theActionList, itemList);
    }

    public static AbstractActionsPopupMenu createCalendarViewGWItemPopupMenu(ActionList actionList, AbstractFolder folder, IItemList itemList, AbstractItem item, String itemType) {
        return new CalendarViewGWItemPopupMenu(actionList, folder, itemList, item, itemType);
    }

    public static JPopupMenu createAttachmentsPopupMenu(MVCController controller, Object ... attachments) {
        if (controller == null || attachments == null || attachments.length == 0) {
            throw new IllegalArgumentException();
        }
        Object attachment = attachments[0];
        if (attachments.length > 1) {
            return new AttachmentsPopupMenu(controller.getActionList(), attachments.length > 1);
        }
        if (attachment instanceof GWAttachment) {
            return new AttachmentPopupMenu(controller.getActionList(), (GWAttachment)attachment);
        }
        if (attachment instanceof AbstractItem) {
            return new AttachedMessagePopupMenu(controller.getActionList(), (AbstractItem)attachment);
        }
        return null;
    }
}

