/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.panelviews;

import com.appframework.ApplicationFrame;
import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.panelviews.BrowserPanel;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModel;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModelManager;
import com.novell.gw.jclient.application.controls.panelviews.PanelContent;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPanelView
extends OrientablePanel
implements MVCView {
    private static final Logger logger = Logger.getLogger(MultiPanelView.class);
    private static final String FOCUS_OWNER_PROPERTY_NAME = "focusOwner";
    private MVCController controller;
    private AbstractFolder folder;
    private MultiPanelViewModel model;
    private List<PanelView> panelViews = new ArrayList<PanelView>();
    private Map<MatrixPosition, PanelView> positionToPanelMap = new HashMap<MatrixPosition, PanelView>();
    private boolean forceRefresh = false;
    private FocusChangeListener focusChangeListener;

    public MultiPanelView(MVCController theParentController) {
        this.controller = theParentController;
        this.setLayout(new GridBagLayout());
    }

    public void cleanUpViews(boolean disposeTables) {
        logger.debug((Object)("++++ cleanin up views, disposeTables: " + disposeTables));
        if (this.focusChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(FOCUS_OWNER_PROPERTY_NAME, this.focusChangeListener);
            this.focusChangeListener = null;
        }
        this.removeAll();
        for (PanelView view : this.panelViews) {
            PanelContent content = view.getPanelContent();
            LevelManager.release(view.getController().getLevel());
            if (content instanceof ItemListView) {
                ItemListView itemListView = (ItemListView)((Object)content);
                if (itemListView.isDead()) continue;
                itemListView.die();
                continue;
            }
            if (!(content instanceof BrowserPanel)) continue;
            ((BrowserPanel)content).cleanUp();
        }
        this.panelViews.clear();
        this.positionToPanelMap.clear();
        this.forceRefresh = true;
    }

    public PanelView getSelectedPanel() {
        for (PanelView panelView : this.positionToPanelMap.values()) {
            if (!panelView.isPanelSelected()) continue;
            return panelView;
        }
        return null;
    }

    private void buildUI() {
        this.cleanUpViews(true);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        List<IPanelDisplaySettings> columnOnePanels = this.model.getPanelsForColumn(0);
        JComponent lastComponent1 = this.layoutPanelsForColumn(columnOnePanels, 0);
        if (this.model.getColumnsMode() == 1) {
            this.add((Component)lastComponent1, c);
        } else if (this.model.getColumnsMode() >= 2) {
            List<IPanelDisplaySettings> columnTwoPanels = this.model.getPanelsForColumn(1);
            JComponent lastComponent2 = this.layoutPanelsForColumn(columnTwoPanels, 1);
            lastComponent1.setPreferredSize(new Dimension(0, 0));
            lastComponent2.setPreferredSize(new Dimension(0, 0));
            NullBorderedSplitPane splitPane = new NullBorderedSplitPane(1, lastComponent1, lastComponent2);
            int widthOne = columnOnePanels.get(0).getPanelWidth();
            int widthTwo = columnTwoPanels.get(0).getPanelWidth();
            splitPane.setResizeWeight((double)widthOne / ((double)widthOne + (double)widthTwo));
            int nCount = this.model.getColumnsMode();
            for (int i = 2; i < nCount; ++i) {
                widthOne += widthTwo;
                widthTwo = this.model.getPanelsForColumn(i).get(0).getPanelWidth();
                lastComponent2 = this.layoutPanelsForColumn(this.model.getPanelsForColumn(i), i);
                lastComponent2.setPreferredSize(new Dimension(0, 0));
                lastComponent1 = splitPane;
                splitPane = new NullBorderedSplitPane(1, lastComponent1, lastComponent2);
                splitPane.setResizeWeight((double)widthOne / ((double)widthOne + (double)widthTwo));
            }
            this.add((Component)splitPane, c);
        }
        for (PanelView panelView : this.panelViews) {
            panelView.refresh();
        }
        if (!this.positionToPanelMap.isEmpty()) {
            this.positionToPanelMap.get(new MatrixPosition(0, 0)).setPanelSelected(true);
        }
        this.forceRefresh = false;
    }

    private JComponent layoutPanelsForColumn(List<IPanelDisplaySettings> columnPanels, int column) {
        String userGuid = ((ApplicationFrame)SwingUtilities.getWindowAncestor(this)).getUserGuid();
        OrientablePanel panel = new OrientablePanel();
        int y = 0;
        int prevCumulativeHeight = 0;
        JComponent lastComponent = panel;
        for (IPanelDisplaySettings displaySettings : columnPanels) {
            PanelView curPanelView = new PanelView(this.getController(), this.folder, displaySettings, userGuid);
            this.panelViews.add(curPanelView);
            curPanelView.setPreferredSize(new Dimension(0, 0));
            this.positionToPanelMap.put(new MatrixPosition(y, column), curPanelView);
            if (y == 0) {
                lastComponent = curPanelView;
            } else {
                NullBorderedSplitPane curSplitPane = new NullBorderedSplitPane(0, lastComponent, curPanelView);
                double resizeWeight = (double)prevCumulativeHeight / ((double)prevCumulativeHeight + (double)curPanelView.getPanelHeight());
                curSplitPane.setResizeWeight(resizeWeight);
                lastComponent = curSplitPane;
            }
            prevCumulativeHeight += curPanelView.getPanelHeight();
            ++y;
        }
        return lastComponent;
    }

    public void setFolder(AbstractFolder folder) {
        boolean needRefresh;
        boolean bl = needRefresh = this.forceRefresh || !folder.equals(this.folder) || this.model != MultiPanelViewModelManager.getInstance().getModel(this.folder.getNativeFolder(), this.getUserGuid());
        if (needRefresh) {
            this.cleanUpViews(true);
            this.folder = folder;
            this.refresh();
        }
    }

    public void refresh() {
        int i;
        this.model = MultiPanelViewModelManager.getInstance().getModel(this.folder.getNativeFolder(), this.getUserGuid());
        int fullWidth = 0;
        int columnCount = this.model.getColumnsMode();
        logger.debug((Object)("++ columnCount: " + columnCount));
        boolean bh = false;
        for (i = 0; i < columnCount; ++i) {
            List<IPanelDisplaySettings> panels = this.model.getPanelsForColumn(i);
            if (panels.size() == 0) {
                return;
            }
            int fullHeight = 0;
            fullWidth += panels.get(0).getPanelWidth();
            int panelCount = this.model.getColumnPanelsAmount(i);
            for (IPanelDisplaySettings displaySettings : panels) {
                fullHeight += displaySettings.getPanelHeight();
                if (displaySettings.getPanelHeight() != 0) continue;
                bh = true;
                break;
            }
            if (!bh) continue;
            for (IPanelDisplaySettings displaySettings : panels) {
                if (displaySettings.getPanelHeight() != 0) {
                    displaySettings.setPanelHeight((int)((double)(fullHeight - fullHeight / panelCount) * ((double)displaySettings.getPanelHeight() / (double)fullHeight)));
                    continue;
                }
                if (displaySettings.getPanelHeight() == 0 && fullHeight != 0) {
                    displaySettings.setPanelHeight((int)((double)fullHeight / (double)panelCount));
                    continue;
                }
                displaySettings.setPanelHeight(1);
            }
        }
        for (i = 0; i < columnCount; ++i) {
            if (this.model.getPanelsForColumn(i).get(0).getPanelWidth() != 0) continue;
            for (int j = 0; j < columnCount; ++j) {
                IPanelDisplaySettings ds = this.model.getPanelsForColumn(j).get(0);
                if (ds.getPanelWidth() != 0) {
                    ds.setPanelWidth((int)((double)(fullWidth - fullWidth / columnCount) * ((double)ds.getPanelWidth() / (double)fullWidth)));
                    continue;
                }
                if (ds.getPanelWidth() == 0 && fullWidth != 0) {
                    ds.setPanelWidth((int)((double)fullWidth / (double)columnCount));
                    continue;
                }
                ds.setPanelWidth(1);
            }
            break;
        }
        this.buildUI();
        this.revalidate();
    }

    public void maximizePanel(PanelView panel) {
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)panel, c);
        this.revalidate();
    }

    public void restoreView() {
        this.buildUI();
        this.revalidate();
    }

    public void setController(MVCController theController) {
        this.controller = theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return null;
    }

    private String getUserGuid() {
        return ((ApplicationFrame)SwingUtilities.getWindowAncestor(this)).getUserGuid();
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(FOCUS_OWNER_PROPERTY_NAME, new FocusChangeListener());
    }

    private class NullBorderedSplitPane
    extends GWSplitPane {
        private NullBorderedSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
            super(newOrientation, newLeftComponent, newRightComponent);
            this.setBorder(null);
        }
    }

    private static class FocusChangeListener
    implements PropertyChangeListener {
        private FocusChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getNewValue() instanceof Component)) {
                return;
            }
            Component component = (Component)evt.getNewValue();
            PanelView panelView = this.findParentPanelView(component);
            if (panelView == null) {
                return;
            }
            panelView.setPanelSelected(true);
        }

        private PanelView findParentPanelView(Component component) {
            assert (component != null);
            for (Container p = component.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof PanelView)) continue;
                return (PanelView)p;
            }
            return null;
        }

        private MultiPanelView findParentMultiPanelView(PanelView panelView) {
            assert (panelView != null);
            for (Container p = panelView.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof MultiPanelView)) continue;
                return (MultiPanelView)p;
            }
            return null;
        }
    }

    private class MatrixPosition {
        private int column;
        private int row;

        public MatrixPosition(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatrixPosition that = (MatrixPosition)o;
            return this.column == that.column && this.row == that.row;
        }

        public int hashCode() {
            int result = this.column;
            result = 31 * result + this.row;
            return result;
        }
    }
}

