/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.panelviews;

import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModelManager;
import com.novell.gw.jclient.application.controls.panelviews.PanelsManager;
import com.novell.gw.jclient.bl.om.folders.UserFolder;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPanelViewModel {
    private static Logger logger = Logger.getLogger(MultiPanelViewModel.class);
    private IFolder folder;
    private IFolderDisplaySettings nativeDisplaySettings;
    private PanelsManager panelsManager;
    private String userGuid;

    MultiPanelViewModel(IFolder folder, String userGuid) {
        if (folder == null) {
            throw new IllegalArgumentException("folder is null");
        }
        if (userGuid == null) {
            throw new IllegalArgumentException("userGuid is null");
        }
        logger.debug((Object)("creatind MultiPanelViewModel for folder: " + folder));
        this.folder = folder;
        this.userGuid = userGuid;
        this.nativeDisplaySettings = folder.getDisplaySettings();
        this.panelsManager = PanelsManager.getInstance(this.nativeDisplaySettings);
        if (this.hasPanels()) {
            this.panelsManager.checkDisplaySettings();
        }
    }

    public List<IPanelDisplaySettings> getPanelsForColumn(int column) {
        return this.panelsManager.getPanelsForColumn(column);
    }

    public int getColumnsMode() {
        return this.nativeDisplaySettings.getPanelColumnCount();
    }

    public void setColumnsMode(int columnsMode) {
    }

    public int getColumnPanelsAmount(int column) {
        return this.panelsManager.getPanelsCountForColumn(column);
    }

    public int getPanelsAmount() {
        return this.nativeDisplaySettings.getPanelCount();
    }

    public boolean hasPanels() {
        return this.getPanelsAmount() > 0;
    }

    public void remove(int column, int columnPosition) {
        this.panelsManager.remove(column, columnPosition);
        if (this.folder instanceof UserFolder && this.nativeDisplaySettings.getPanelCount() == 0) {
            logger.debug((Object)"Home folder has no panels > removing its model");
            MultiPanelViewModelManager.getInstance().removeModel(this.folder);
        }
    }

    public void insert(IPanelDisplaySettings panel, int columnNum, int columnIndex) {
        this.panelsManager.insert(panel, columnNum, columnIndex);
    }

    public boolean move(IPanelDisplaySettings targetPanel, int oldColumnNum, int oldColumnIndex) {
        return this.panelsManager.move(targetPanel, oldColumnNum, oldColumnIndex);
    }

    public void movePanelToNewColumn(IPanelDisplaySettings panel) {
        panel.setPanelColumnNum(this.getColumnsMode());
        this.nativeDisplaySettings.resetPanelSettings();
        this.panelsManager.checkDisplaySettings();
    }
}

