/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.panelviews;

import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.level.LevelManager;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.panelviews.BrowserPanel;
import com.novell.gw.jclient.application.controls.panelviews.BrowserPanelActionList;
import com.novell.gw.jclient.application.controls.panelviews.ILVPPanelContent;
import com.novell.gw.jclient.application.controls.panelviews.PanelContent;
import com.novell.gw.jclient.application.controls.panelviews.PanelType;
import com.novell.gw.jclient.application.controls.panelviews.PanelViewController;
import com.novell.gw.jclient.application.controls.panelviews.PanelViewDragGestureListener;
import com.novell.gw.jclient.application.controls.panelviews.PanelViewDropTargetListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelView
extends OrientablePanel
implements MVCView<PanelViewController, Object> {
    private static final Logger logger = Logger.getLogger(PanelView.class);
    private PanelViewController controller;
    public static final int MODE_RESTORED = 0;
    public static final int MODE_MAXIMIZED = 1;
    private final Color clrBorder = new Color(198, 199, 198);
    private final Color clrHeaderEnd = new Color(239, 235, 247);
    private final Color clrHeaderDefault = new Color(214, 211, 206);
    private final Color clrHeaderSelected = new Color(8, 36, 107);
    private final Color clrLabelDefault = new Color(90, 89, 90);
    private static final Color clrLabelSelected = Color.WHITE;
    private JLabel label = new OrientableLabel();
    private final HeaderPane pnlHeader = new HeaderPane();
    private int viewSizeMode = 0;
    private JLabel arrowLabel = new OrientableLabel(ImageResources.ICON_DOWN_ARROW);
    private JMenuItem itemMaximize;
    private JMenuItem itemRestore;
    private JMenuItem itemEditPanel;
    private JMenuItem itemClose;
    private JMenuItem itemAddPanel;
    private JMenuItem itemCustomizePanel;
    private JMenuItem itemAddColumn;
    private AppAction actionMaximizePanel;
    private AppAction actionRestorePanel;
    private AppAction actionClosePanel;
    private AppAction actionAddPanel;
    private AppAction actionEditPanel;
    private AppAction actionCustomizePanel;
    private AppAction actionAddColumn;
    private IPanelDisplaySettings panelDisplaySettings;
    private AbstractFolder panelFolder;
    private final AbstractFolder multiPanelViewFolder;
    private final String userGuid;
    private boolean selected = false;
    private PanelType panelType;
    private PanelContent view;
    private JPanel pnlView = new OrientablePanel(new BorderLayout());

    public PanelView(MVCController parentController, AbstractFolder multiPanelViewFolder, IPanelDisplaySettings panelDisplaySettings, String userGuid) {
        super(new BorderLayout());
        this.userGuid = userGuid;
        this.multiPanelViewFolder = multiPanelViewFolder;
        this.panelDisplaySettings = panelDisplaySettings;
        this.controller = new PanelViewController(this, parentController);
        this.init();
        this.buildUI();
    }

    private void refreshlPanelHeader() {
        this.pnlHeader.removeAll();
        this.pnlHeader.add(this.label);
        this.pnlHeader.add(Box.createHorizontalGlue());
        if (this.panelType.equals((Object)PanelType.WEB_PAGE_PANEL)) {
            BrowserPanelActionList actionList = this.getBrowserPanelActionList();
            AppAction actionBack = actionList.getAction(ActionKey.WEB_PAGE_GO_BACK);
            JComponent btnBack = actionBack.getToolBarComponent();
            ((JButton)btnBack).setText(null);
            ((JButton)btnBack).setDisabledIcon(ImageResources.WEB_PAGE_PANEL_GO_BACK_DISABLED);
            AppAction actionForward = actionList.getAction(ActionKey.WEB_PAGE_GO_FORWARD);
            JComponent btnForward = actionForward.getToolBarComponent();
            ((JButton)btnForward).setText(null);
            ((JButton)btnForward).setDisabledIcon(ImageResources.WEB_PAGE_PANEL_GO_FORWARD_DISABLED);
            AppAction actionReload = actionList.getAction(ActionKey.WEB_PAGE_RELOAD);
            JComponent btnReload = actionReload.getToolBarComponent();
            ((JButton)btnReload).setText(null);
            ((JButton)btnReload).setDisabledIcon(ImageResources.WEB_PAGE_PANEL_RELOAD_DISABLED);
            this.pnlHeader.add(btnBack);
            this.pnlHeader.add(btnForward);
            this.pnlHeader.add(btnReload);
        }
        this.pnlHeader.add(this.arrowLabel);
    }

    private void init() {
        this.setBackground(this.clrBorder);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.arrowLabel.setFocusable(false);
        this.arrowLabel.setIconTextGap(0);
        PopupListener popupListener = new PopupListener();
        this.arrowLabel.addMouseListener(popupListener);
        this.actionMaximizePanel = this.getApplicationFrameActionList().getAction(ActionKey.MAXIMIZE_PANEL);
        this.itemMaximize = OS.createMenuItem(this.actionMaximizePanel);
        this.actionRestorePanel = this.getApplicationFrameActionList().getAction(ActionKey.RESTORE_PANEL);
        this.itemRestore = OS.createMenuItem(this.actionRestorePanel);
        this.actionClosePanel = this.getApplicationFrameActionList().getAction(ActionKey.CLOSE_PANEL);
        this.itemClose = OS.createMenuItem(this.actionClosePanel);
        this.actionAddPanel = this.getApplicationFrameActionList().getAction(ActionKey.ADD_PANEL);
        this.itemAddPanel = OS.createMenuItem(this.actionAddPanel);
        this.actionEditPanel = this.getApplicationFrameActionList().getAction(ActionKey.EDIT_PANEL);
        this.itemEditPanel = OS.createMenuItem(this.actionEditPanel);
        this.actionCustomizePanel = this.getApplicationFrameActionList().getAction(ActionKey.CUSTOMIZE_PANELS);
        this.itemCustomizePanel = OS.createMenuItem(this.actionCustomizePanel);
        this.actionAddColumn = this.getApplicationFrameActionList().getAction(ActionKey.ADD_COLUMN);
        this.itemAddColumn = OS.createMenuItem(this.actionAddColumn);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (PanelView.this.viewSizeMode == 0) {
                    PanelView.this.panelDisplaySettings.setPanelWidth(PanelView.this.getWidth());
                    PanelView.this.panelDisplaySettings.setPanelHeight(PanelView.this.getHeight());
                    PanelView.this.panelDisplaySettings.writeDisplaySettings();
                }
            }
        });
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getPnlHeader(), 2, new PanelViewDragGestureListener(this));
        this.getPnlHeader().setDropTarget(new DropTarget(this.getPnlHeader(), 2, new PanelViewDropTargetListener(this)));
    }

    private void buildUI() {
        this.add((Component)this.pnlView, "Center");
        this.add((Component)this.pnlHeader, "North");
    }

    public void refresh(IPanelDisplaySettings newSettings) {
        this.panelDisplaySettings = newSettings;
        this.refresh();
    }

    public void refresh() {
        OrientablePanel view;
        PanelType panelType;
        AbstractFolder panelFolder;
        GWCommandManager manager = EngineCommandManager.getInstance(this.userGuid);
        IDataStore currentDataStore = manager.getCurrentDataStore();
        IFolder nativePanelFolder = this.panelDisplaySettings.getPanelFolder(currentDataStore);
        if (nativePanelFolder == null) {
            logger.debug((Object)"display settings contain null as a folder");
            panelFolder = this.multiPanelViewFolder;
        } else {
            panelFolder = manager.getGWFolder(nativePanelFolder);
        }
        this.panelFolder = panelFolder;
        if (!Utils.isNullOrEmpty(this.panelDisplaySettings.getPanelWebPage())) {
            panelType = PanelType.WEB_PAGE_PANEL;
            BrowserPanel browserPanel = new BrowserPanel(this.controller, this.panelDisplaySettings.getPanelRefreshInterval());
            browserPanel.setJavascriptEnabled(true);
            browserPanel.setPage(this.panelDisplaySettings.getPanelWebPage());
            view = browserPanel;
        } else {
            ILVPPanelContent itemListView;
            view = itemListView = new ILVPPanelContent(this.panelFolder, this.multiPanelViewFolder, this.panelDisplaySettings, null, this.getController());
            int viewMode = this.panelDisplaySettings.getViewMode();
            panelType = viewMode == 6 ? PanelType.CALENDAR_PANEL : (panelFolder.isContactsFolder() ? PanelType.CONTACTS_TABLE_PANEL : PanelType.ITEM_LIST_TABLE_PANEL);
        }
        if (this.view != null) {
            if (this.view instanceof ItemListView) {
                ((ItemListView)((Object)this.view)).dispose();
            } else if (this.view instanceof BrowserPanel) {
                ((BrowserPanel)this.view).cleanUp();
            }
            LevelManager.release(((MVCController)((MVCView)((Object)this.view)).getController()).getLevel());
        }
        this.view = view;
        this.view.setParentPanel(this);
        this.panelType = panelType;
        this.label.setText(this.panelDisplaySettings.getPanelName());
        this.pnlView.removeAll();
        this.pnlView.add((Component)this.view.getComponent(), "Center");
        if (this.view instanceof ItemListView) {
            ((ItemListView)((Object)this.view)).refresh();
        }
        this.refreshlPanelHeader();
    }

    public PanelType getPanelType() {
        return this.panelType;
    }

    public int getRealItemCount() {
        if (this.panelType == PanelType.ITEM_LIST_TABLE_PANEL || this.panelType == PanelType.CONTACTS_TABLE_PANEL) {
            return ((ItemListView)((Object)this.view)).getItemList().getDisplayItemCount();
        }
        throw new IllegalStateException("incorrect panelType: " + (Object)((Object)this.panelType));
    }

    public int getSelectedItemCount() {
        if (this.panelType == PanelType.ITEM_LIST_TABLE_PANEL || this.panelType == PanelType.CONTACTS_TABLE_PANEL) {
            return ((ILVPPanelContent)this.view).getSelectedItemCount();
        }
        throw new IllegalStateException("incorrect panelType: " + (Object)((Object)this.panelType));
    }

    public Component getPnlHeader() {
        return this.pnlHeader;
    }

    private JPopupMenu getPopupMenu() {
        GWPopupMenu popup = new GWPopupMenu();
        if (this.panelType == PanelType.WEB_PAGE_PANEL) {
            BrowserPanelActionList actionList = this.getBrowserPanelActionList();
            assert (actionList != null);
            if (actionList != null) {
                AppAction action;
                BrowserPanel browserPanel = (BrowserPanel)actionList.getMVCView();
                if (browserPanel.canGoBack()) {
                    action = actionList.getAction(ActionKey.WEB_PAGE_GO_BACK);
                    popup.add(action.getMenuItem());
                }
                if (browserPanel.canGoForward()) {
                    action = actionList.getAction(ActionKey.WEB_PAGE_GO_FORWARD);
                    popup.add(action.getMenuItem());
                }
                action = actionList.getAction(ActionKey.WEB_PAGE_RELOAD);
                popup.add(action.getMenuItem());
                if (browserPanel.canGoBack()) {
                    action = actionList.getAction(ActionKey.WEB_PAGE_GOTO_START_PAGE);
                    String url = this.getDisplaySettings().getPanelWebPage();
                    action.setMVCModel(url);
                    popup.add(action.getMenuItem());
                }
                popup.addSeparator();
            }
        }
        this.actionMaximizePanel.setMVCModel(this);
        this.actionRestorePanel.setMVCModel(this);
        this.actionClosePanel.setMVCModel(this);
        this.actionAddPanel.setMVCModel(this);
        this.actionEditPanel.setMVCModel(this);
        this.actionAddColumn.setMVCModel(this);
        this.actionCustomizePanel.setMVCModel(this);
        if (this.viewSizeMode == 0) {
            popup.add(this.itemMaximize);
        } else if (this.viewSizeMode == 1) {
            popup.add(this.itemRestore);
        }
        popup.add(this.itemEditPanel);
        popup.add(this.itemClose);
        popup.addSeparator();
        popup.add(this.itemCustomizePanel);
        popup.add(this.itemAddPanel);
        popup.addSeparator();
        popup.add(this.itemAddColumn);
        return popup;
    }

    public AbstractFolder getPanelFolder() {
        return this.panelFolder;
    }

    public AbstractFolder getMultiPanelViewFolder() {
        return this.multiPanelViewFolder;
    }

    public IPanelDisplaySettings getDisplaySettings() {
        return this.panelDisplaySettings;
    }

    public int getColumnPosition() {
        return this.panelDisplaySettings.getPanelIndex();
    }

    public int getColumn() {
        return this.panelDisplaySettings.getPanelColumnNum();
    }

    public int getPanelHeight() {
        return this.panelDisplaySettings.getPanelHeight();
    }

    private void showPopup() {
        JPopupMenu popup = this.getPopupMenu();
        popup.show(this, this.arrowLabel.getX() - popup.getPreferredSize().width, this.arrowLabel.getY() + this.arrowLabel.getHeight());
    }

    public void setViewSizeMode(int mode) {
        this.viewSizeMode = mode;
    }

    @Override
    public void setController(PanelViewController controller) {
        this.controller = controller;
    }

    @Override
    public PanelViewController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(Object theModel) {
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    public String getUserGuid() {
        return this.userGuid;
    }

    private ApplicationFrameActionList getApplicationFrameActionList() {
        return ControlsUtils.getFrameForController(this.controller).getAppActionList();
    }

    private BrowserPanelActionList getBrowserPanelActionList() {
        assert (this.panelType == PanelType.WEB_PAGE_PANEL);
        return ((BrowserPanel)this.getPanelContent()).getController();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.pnlHeader.getMinimumSize();
    }

    public boolean isPanelSelected() {
        return this.selected;
    }

    public void setPanelSelected(boolean selected) {
        if (selected != this.selected) {
            this.selected = selected;
            if (selected) {
                this.label.setForeground(clrLabelSelected);
                this.pnlHeader.repaint();
            } else {
                this.label.setForeground(this.clrLabelDefault);
            }
            this.repaint();
            if (selected) {
                this.view.parentPanelSelected();
                this.firePanelSelected();
            }
        }
    }

    public void firePanelSelected() {
        this.controller.processCommand(new Command(1860, this));
    }

    public PanelContent getPanelContent() {
        return this.view;
    }

    public String getPanelName() {
        return this.panelDisplaySettings.getPanelName();
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            PanelView.this.showPopup();
        }
    }

    private class HeaderPane
    extends OrientablePanel {
        public HeaderPane() {
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setFocusable(true);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    PanelView.this.view.getComponent().requestFocusInWindow();
                    PanelView.this.setPanelSelected(true);
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        if (PanelView.this.viewSizeMode == 0) {
                            AppAction actionMaximizePanel = PanelView.this.getApplicationFrameActionList().getAction(ActionKey.MAXIMIZE_PANEL);
                            actionMaximizePanel.setMVCModel(PanelView.this);
                            PanelView.this.getApplicationFrameActionList().performAction(ActionKey.MAXIMIZE_PANEL);
                        } else if (PanelView.this.viewSizeMode == 1) {
                            AppAction actionResorePanel = PanelView.this.getApplicationFrameActionList().getAction(ActionKey.RESTORE_PANEL);
                            actionResorePanel.setMVCModel(PanelView.this);
                            PanelView.this.getApplicationFrameActionList().performAction(ActionKey.RESTORE_PANEL);
                        }
                    }
                }
            });
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2D = (Graphics2D)g;
            Color color = PanelView.this.selected ? PanelView.this.clrHeaderSelected : PanelView.this.clrHeaderDefault;
            GradientPaint paintHigherSegment = new GradientPaint(0.0f, 0.0f, color, this.getWidth(), this.getHeight(), PanelView.this.clrHeaderEnd);
            g2D.setPaint(paintHigherSegment);
            g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

