/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.panelviews;

import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModel;
import com.novell.gw.jclient.application.controls.panelviews.MultiPanelViewModelManager;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.application.controls.panelviews.PanelViewTransferData;
import com.novell.gw.jclient.application.controls.panelviews.PanelViewTransferable;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PanelViewDropTargetListener
implements DropTargetListener {
    private static Logger logger = Logger.getLogger(PanelViewDropTargetListener.class);
    private PanelView panelView;

    public PanelViewDropTargetListener(PanelView panelView) {
        this.panelView = panelView;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragOver(dtde);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (PanelViewDropTargetListener.verifyDragOverPanelView(dtde)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.dragOver(dtde);
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        PanelViewTransferData transferData = PanelViewDropTargetListener.getTransferData(dtde.getTransferable());
        int dragColumnIndex = transferData.getColumnIndex();
        int dragColumnNum = transferData.getColumnNum();
        AbstractFolder multiViewFolder = this.panelView.getMultiPanelViewFolder();
        MultiPanelViewModel multiPanelModel = MultiPanelViewModelManager.getInstance().getModel(multiViewFolder.getNativeFolder(), this.panelView.getUserGuid());
        if (multiPanelModel.move(this.panelView.getDisplaySettings(), dragColumnNum, dragColumnIndex)) {
            ((GWMainAppFrame)SwingUtilities.getWindowAncestor(this.panelView)).getMultiPanelView().refresh();
        }
    }

    private static boolean verifyDragOverPanelView(DropTargetDragEvent dtde) {
        return dtde.getTransferable().isDataFlavorSupported(PanelViewTransferable.panelViewFlavor);
    }

    private static PanelViewTransferData getTransferData(Transferable transferable) {
        PanelViewTransferData data = null;
        try {
            data = (PanelViewTransferData)transferable.getTransferData(PanelViewTransferable.panelViewFlavor);
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        if (data == null) {
            logger.warn((Object)"transfer data is null");
        }
        return data;
    }
}

