/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.skinnable;

import com.appframework.weak.WeakList;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.ColorUtils;
import com.novell.gw.jclient.application.controls.GtkColors;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.itemview.EmbededParentView;
import com.novell.gw.jclient.application.controls.skinnable.ISkinnable;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPropertyManager {
    private static Logger logger = Logger.getLogger(ComponentPropertyManager.class);
    private static ComponentPropertyManager instance = null;
    private WeakList<ISkinnable> components = new WeakList();
    private Map<SkinProperty, Object> skinProperties = null;

    private ComponentPropertyManager() {
        this.tryInit();
    }

    public static ComponentPropertyManager getInstance() {
        if (instance == null) {
            instance = new ComponentPropertyManager();
        }
        return instance;
    }

    public void add(ISkinnable component) {
        this.components.add(component);
        if (!this.isInited() && !this.tryInit()) {
            return;
        }
        component.processSkinPropertiesChange(this.skinProperties);
    }

    public void updateProperties(SkinProperty ... properties) {
        if (!this.isInited() && !this.tryInit()) {
            return;
        }
        this.updateProperties(this.readPropertyValues(properties));
    }

    public void updateProperty(SkinProperty property, Object value) {
        HashMap<SkinProperty, Object> map = new HashMap<SkinProperty, Object>();
        map.put(property, value);
        this.updateProperties(map);
    }

    public void updateProperties(Map<SkinProperty, Object> propertiesMap) {
        if (!this.isInited() && !this.tryInit()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        for (Map.Entry<SkinProperty, Object> entry : propertiesMap.entrySet()) {
            this.skinProperties.put(entry.getKey(), entry.getValue());
        }
        for (int i = 0; i < this.components.size(); ++i) {
            this.components.get(i).processSkinPropertiesChange(propertiesMap);
        }
        logger.debug((Object)("update time, ms: " + (System.currentTimeMillis() - timestamp)));
    }

    public Object getSkinPropertyValue(SkinProperty skinProperty) {
        if (!this.isInited() && !this.tryInit()) {
            return null;
        }
        return this.skinProperties.get((Object)skinProperty);
    }

    public void processSkinChanged() {
        this.updateProperties(SkinProperty.BACKGROUND_COLOR, SkinProperty.BACK_TOP_END_COLOR, SkinProperty.SEL_END_COLOR, SkinProperty.SEL_START_COLOR, SkinProperty.HILITE_END_COLOR, SkinProperty.HILITE_START_COLOR, SkinProperty.HILITE_BORDER_COLOR, SkinProperty.SEL_BORDER_COLOR, SkinProperty.SEPARATOR_COLOR, SkinProperty.TOOLBAR_TEXT_COLOR, SkinProperty.BOTTOM_START_COLOR, SkinProperty.HIGHLIGHTED_TEXT_COLOR, SkinProperty.NAVBAR_TEXT_COLOR, SkinProperty.HEADER_TEXT_COLOR, SkinProperty.HEADER_BACKGROUND_COLOR, SkinProperty.SELECTED_TOOLBAR_BTN_BACKROUND_COLOR);
    }

    private Map<SkinProperty, Object> readPropertyValues(SkinProperty ... properties) {
        assert (this.isInited());
        HashMap<SkinProperty, Object> changedProperties = new HashMap<SkinProperty, Object>(properties.length);
        for (SkinProperty property : properties) {
            assert (property != null) : "property is null";
            Object value = this.readProperty(property);
            changedProperties.put(property, value);
            this.skinProperties.put(property, value);
        }
        return changedProperties;
    }

    private Object readProperty(SkinProperty property) {
        Serializable value = null;
        switch (property) {
            case BACKGROUND_COLOR: {
                value = SkinPropertyReader.getBackgroundColor();
                break;
            }
            case BOTTOM_START_COLOR: {
                value = SkinPropertyReader.getBottomStartColor();
                break;
            }
            case BACK_TOP_END_COLOR: {
                value = SkinPropertyReader.getBackTopEndColor();
                break;
            }
            case SEL_END_COLOR: {
                value = SkinPropertyReader.getSelEndColor();
                break;
            }
            case SEL_START_COLOR: {
                value = SkinPropertyReader.getSelStartColor();
                break;
            }
            case HILITE_END_COLOR: {
                value = SkinPropertyReader.getHiliteEndColor();
                break;
            }
            case HILITE_START_COLOR: {
                value = SkinPropertyReader.getHiliteStartColor();
                break;
            }
            case HILITE_BORDER_COLOR: {
                value = SkinPropertyReader.getHiliteBorderColor();
                break;
            }
            case SEL_BORDER_COLOR: {
                value = SkinPropertyReader.getSelBorderColor();
                break;
            }
            case SEPARATOR_COLOR: {
                value = SkinPropertyReader.getSeparatorColor();
                break;
            }
            case TOOLBAR_TEXT_COLOR: {
                value = SkinPropertyReader.getToolbarTextColor();
                break;
            }
            case HIGHLIGHTED_TEXT_COLOR: {
                value = SkinPropertyReader.getHighlightedTextColor();
                break;
            }
            case SELECTED_TOOLBAR_BTN_BACKROUND_COLOR: {
                value = SkinPropertyReader.getToolBarButtonHotColor();
                break;
            }
            case NAVBAR_TEXT_COLOR: {
                value = SkinPropertyReader.getNavbarTextColor();
                break;
            }
            case NAVBAR_FONT_SIZE: {
                value = Integer.valueOf(SkinPropertyReader.getNavbarFontSize());
                break;
            }
            case HEADER_BACKGROUND_COLOR: {
                value = SkinPropertyReader.getHeaderBackgroundColor();
                break;
            }
            case HEADER_TEXT_COLOR: {
                value = SkinPropertyReader.getHeaderTextColor();
                break;
            }
            case HEADER_FONT_SIZE: {
                value = Integer.valueOf(SkinPropertyReader.getHeaderFontSize());
                break;
            }
            case HEADER_PARENT_BACKGROUND_COLOR: {
                value = SkinPropertyReader.getHeaderParentBackgroundColor();
                break;
            }
            case HEADER_PARENT_TEXT_COLOR: {
                value = SkinPropertyReader.getHeaderParentTextColor();
                break;
            }
            case HEADER_PARENT_FONT_SIZE: {
                value = Integer.valueOf(SkinPropertyReader.getHeaderParentFontSize());
                break;
            }
            default: {
                assert (false) : "unexpected skin property: " + (Object)((Object)property);
                break;
            }
        }
        return value;
    }

    private boolean tryInit() {
        if (this.skinProperties != null) {
            return true;
        }
        if (EngineCommandManager.getUserInfo() == null) {
            return false;
        }
        this.skinProperties = new HashMap<SkinProperty, Object>();
        for (SkinProperty property : SkinProperty.values()) {
            this.skinProperties.put(property, this.readProperty(property));
        }
        return true;
    }

    private boolean isInited() {
        return this.skinProperties != null;
    }

    private static class SkinPropertyReader {
        private SkinPropertyReader() {
        }

        private static Color getBackgroundColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(3);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getDarkColor(color);
            }
            return color;
        }

        private static Color getBottomStartColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(2);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getLightColor(color);
            }
            return color;
        }

        private static Color getBackTopEndColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(1);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getDarkColor(color);
            }
            return color;
        }

        private static Color getSelEndColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(5);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getMidColor(color);
            }
            return color;
        }

        private static Color getSelStartColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(4);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getDesktopColor(color);
            }
            return color;
        }

        private static Color getHiliteEndColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(8);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getLightColor(color);
            }
            return color;
        }

        private static Color getHiliteStartColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(7);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getDarkColor(color);
            }
            return color;
        }

        private static Color getHiliteBorderColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(9);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getDarkColor(color);
            }
            return color;
        }

        private static Color getSelBorderColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(6);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getDesktopColor(color);
            }
            return color;
        }

        private static Color getSeparatorColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(11);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getLightColor(color);
            }
            return color;
        }

        private static Color getToolbarTextColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(12);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return ColorUtils.revertColor(GtkColors.getDesktopColor(color));
            }
            return color;
        }

        private static Color getHighlightedTextColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(35);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getTextForegroundColor(color);
            }
            return color;
        }

        private static Color getToolBarButtonHotColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getGWColor(14);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getDarkColor(color);
            }
            return color;
        }

        private static Color getNavbarTextColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getNavBarTextColorSet() ? SkinPropertyReader.getDataStoreSettings().getNavBarTextColor() : SkinPropertyReader.getDataStoreSettings().getGWColor(6);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getTextForegroundColor(color);
            }
            return color;
        }

        private static int getNavbarFontSize() {
            int navBarFontSize = SkinPropertyReader.getDataStoreSettings().getNavBarFontSize();
            if (navBarFontSize == 0) {
                return PLAFChanger.getFontSize();
            }
            return navBarFontSize;
        }

        private static Color getHeaderTextColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getHeaderTextColorSet() ? SkinPropertyReader.getDataStoreSettings().getHeaderTextColor() : SkinPropertyReader.getDataStoreSettings().getGWColor(12);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getTextForegroundColor(color);
            }
            return color;
        }

        private static Color getHeaderBackgroundColor() {
            Color color = SkinPropertyReader.getDataStoreSettings().getHeaderBackColorSet() ? SkinPropertyReader.getDataStoreSettings().getHeaderBackColor() : SkinPropertyReader.getDataStoreSettings().getGWColor(6);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                return GtkColors.getDesktopColor(color);
            }
            return color;
        }

        private static int getHeaderFontSize() {
            int fontSize = SkinPropertyReader.getDataStoreSettings().getHeaderFontSize();
            if (fontSize == 0) {
                fontSize = PLAFChanger.getFontSize();
            }
            return fontSize;
        }

        public static Color getHeaderParentBackgroundColor() {
            if (!SkinPropertyReader.getDataStoreSettings().getHeaderParentBackColorSet()) {
                return EmbededParentView.DEFAULT_COLOR;
            }
            return SkinPropertyReader.getDataStoreSettings().getHeaderParentBackColor();
        }

        public static Color getHeaderParentTextColor() {
            if (!SkinPropertyReader.getDataStoreSettings().getHeaderParentTextColorSet()) {
                return EmbededParentView.DEFAULT_TEXT_COLOR;
            }
            return SkinPropertyReader.getDataStoreSettings().getHeaderParentTextColor();
        }

        public static int getHeaderParentFontSize() {
            int fontSize = SkinPropertyReader.getDataStoreSettings().getHeaderParentFontSize();
            if (fontSize == 0) {
                return PLAFChanger.getFontSize();
            }
            return fontSize;
        }

        private static DataStoreSettings getDataStoreSettings() {
            return GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        }
    }
}

