/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.skinnable;

import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.ComponentPropertyManager;
import com.novell.gw.jclient.application.controls.skinnable.ISkinnable;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableDelegate;
import java.awt.Color;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinnableTextField
extends OrientableTextField
implements ISkinnable {
    protected SkinnableDelegate<JTextField> skinnableDelegate = new SkinnableDelegate<SkinnableTextField>(this);

    public SkinnableTextField() {
        this.skinnableDelegate.clearPropertyBindings();
        ComponentPropertyManager.getInstance().add(this);
    }

    public SkinnableTextField(int columns) {
        super(columns);
        this.skinnableDelegate.clearPropertyBindings();
        ComponentPropertyManager.getInstance().add(this);
    }

    public SkinnableTextField(String text) {
        super(text);
        this.skinnableDelegate.clearPropertyBindings();
        ComponentPropertyManager.getInstance().add(this);
    }

    public SkinnableTextField(String text, int columns) {
        super(text, columns);
        this.skinnableDelegate.clearPropertyBindings();
        ComponentPropertyManager.getInstance().add(this);
    }

    public JComponent getJComponent() {
        return this;
    }

    @Override
    public Set<SkinProperty> getSkinProperties() {
        return this.skinnableDelegate.getSkinProperties();
    }

    @Override
    public Object getSkinPropertyValue(SkinProperty skinProperty) {
        return this.skinnableDelegate.getSkinPropertyValue(skinProperty);
    }

    @Override
    public void processSkinPropertiesChange(Map<SkinProperty, Object> skinPropertyValues) {
        this.skinnableDelegate.processSkinPropertiesChange(skinPropertyValues);
    }

    @Override
    public void setSkinabilityEnabled(boolean isSkinabilityEnabled) {
        this.skinnableDelegate.setSkinabilityEnabled(isSkinabilityEnabled);
    }

    @Override
    public Color getDefaultBackground() {
        return UIManager.getColor("TextField.background");
    }

    @Override
    public Color getDefaultForeground() {
        return UIManager.getColor("TextField.foreground");
    }

    @Override
    public void putSkinProperty(SkinProperty skinProperty, ComponentProperty componentProperty) {
        this.skinnableDelegate.putSkinProperty(skinProperty, componentProperty);
    }

    @Override
    public void removeSkinProperty(SkinProperty skinProperty) {
        this.skinnableDelegate.removeSkinProperty(skinProperty);
    }

    @Override
    public void clearPropertyBindings() {
        this.skinnableDelegate.clearPropertyBindings();
    }
}

