/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.timepicker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class SliderGeometry {
    private final JSlider slider;
    private Insets focusInsets = null;
    private Insets insetCache = null;
    private Rectangle focusRect = new Rectangle();
    private Rectangle contentRect = new Rectangle();
    private Rectangle labelRect = new Rectangle();
    private Rectangle tickRect = new Rectangle();
    private Rectangle trackRect = new Rectangle();
    private Rectangle thumbRect = new Rectangle();
    private int trackBuffer = 0;

    public static SliderGeometry getInstance(JSlider slider) {
        return new SliderGeometry(slider);
    }

    private SliderGeometry(JSlider slider) {
        this.slider = slider;
        this.calculateGeometry();
    }

    void calculateGeometry() {
        this.focusInsets = (Insets)UIManager.get("Slider.focusInsets");
        if (this.focusInsets == null) {
            this.focusInsets = new InsetsUIResource(2, 2, 2, 2);
        }
        this.insetCache = this.slider.getInsets();
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    void calculateFocusRect() {
        this.focusRect.x = this.insetCache.left;
        this.focusRect.y = this.insetCache.top;
        this.focusRect.width = this.slider.getWidth() - (this.insetCache.left + this.insetCache.right);
        this.focusRect.height = this.slider.getHeight() - (this.insetCache.top + this.insetCache.bottom);
    }

    void calculateThumbSize() {
        Dimension size = this.getThumbSize();
        this.thumbRect.setSize(size.width, size.height);
    }

    void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - (this.focusInsets.left + this.focusInsets.right);
        this.contentRect.height = this.focusRect.height - (this.focusInsets.top + this.focusInsets.bottom);
    }

    void calculateThumbLocation() {
        int valuePosition;
        if (this.slider.getSnapToTicks()) {
            int sliderValue;
            int snappedValue = sliderValue = this.slider.getValue();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((sliderValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(sliderValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != sliderValue) {
                    this.slider.setValue(snappedValue);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            valuePosition = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            valuePosition = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    void calculateTrackBuffer() {
        if (this.slider.getPaintLabels() && this.slider.getLabelTable() != null) {
            Component highLabel = this.getHighestValueLabel();
            Component lowLabel = this.getLowestValueLabel();
            if (this.slider.getOrientation() == 0) {
                this.trackBuffer = Math.max(highLabel.getBounds().width, lowLabel.getBounds().width) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.width / 2);
            } else {
                this.trackBuffer = Math.max(highLabel.getBounds().height, lowLabel.getBounds().height) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.height / 2);
            }
        } else {
            this.trackBuffer = this.slider.getOrientation() == 0 ? this.thumbRect.width / 2 : this.thumbRect.height / 2;
        }
    }

    void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            int centerSpacing = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                centerSpacing += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                centerSpacing += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - centerSpacing - 1) / 2;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
            this.trackRect.height = this.thumbRect.height;
        } else {
            int centerSpacing = this.thumbRect.width;
            if (this.isLeftToRight()) {
                if (this.slider.getPaintTicks()) {
                    centerSpacing += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    centerSpacing -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - centerSpacing - 1) / 2;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2;
        }
    }

    int getTickLength() {
        SliderUI sliderUI = this.slider.getUI();
        if (sliderUI instanceof MetalSliderUI) {
            return ((MetalSliderUI)this.slider.getUI()).getTickLength();
        }
        return 8;
    }

    void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        } else {
            this.tickRect.width = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.isLeftToRight() ? this.trackRect.x + this.trackRect.width : this.trackRect.x - this.tickRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
    }

    void calculateLabelRect() {
        if (this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 0) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
            } else {
                if (this.isLeftToRight()) {
                    this.labelRect.x = this.tickRect.x + this.tickRect.width;
                    this.labelRect.width = this.getWidthOfWidestLabel();
                } else {
                    this.labelRect.width = this.getWidthOfWidestLabel();
                    this.labelRect.x = this.tickRect.x - this.labelRect.width;
                }
                this.labelRect.y = this.tickRect.y - this.trackBuffer;
                this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
            }
        } else if (this.slider.getOrientation() == 0) {
            this.labelRect.x = this.tickRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.tickRect.width;
            this.labelRect.height = 0;
        } else {
            this.labelRect.x = this.isLeftToRight() ? this.tickRect.x + this.tickRect.width : this.tickRect.x;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    Dimension getThumbSize() {
        Icon icon = this.slider.getComponentOrientation().isHorizontal() ? UIManager.getIcon("Slider.horizontalThumbIcon") : UIManager.getIcon("Slider.verticalThumbIcon");
        if (icon != null) {
            return new Dimension(icon.getIconWidth(), icon.getIconHeight());
        }
        return new Dimension();
    }

    protected int getWidthOfWidestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int widest = 0;
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Component label = (Component)dictionary.get(keys.nextElement());
                widest = Math.max(label.getPreferredSize().width, widest);
            }
        }
        return widest;
    }

    int getHeightOfTallestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int tallest = 0;
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Component label = (Component)dictionary.get(keys.nextElement());
                tallest = Math.max(label.getPreferredSize().height, tallest);
            }
        }
        return tallest;
    }

    protected int getWidthOfHighValueLabel() {
        Component label = this.getHighestValueLabel();
        int width = 0;
        if (label != null) {
            width = label.getPreferredSize().width;
        }
        return width;
    }

    protected int getWidthOfLowValueLabel() {
        Component label = this.getLowestValueLabel();
        int width = 0;
        if (label != null) {
            width = label.getPreferredSize().width;
        }
        return width;
    }

    protected int getHeightOfHighValueLabel() {
        Component label = this.getHighestValueLabel();
        int height = 0;
        if (label != null) {
            height = label.getPreferredSize().height;
        }
        return height;
    }

    protected int getHeightOfLowValueLabel() {
        Component label = this.getLowestValueLabel();
        int height = 0;
        if (label != null) {
            height = label.getPreferredSize().height;
        }
        return height;
    }

    boolean drawInverted() {
        if (this.slider.getOrientation() == 0) {
            if (this.isLeftToRight()) {
                return this.slider.getInverted();
            }
            return !this.slider.getInverted();
        }
        return this.slider.getInverted();
    }

    private boolean isLeftToRight() {
        return this.slider.getComponentOrientation().isLeftToRight();
    }

    Integer getHighestValue() {
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            int max = this.slider.getMinimum() - 1;
            while (keys.hasMoreElements()) {
                max = Math.max(max, (Integer)keys.nextElement());
            }
            if (max == this.slider.getMinimum() - 1) {
                return null;
            }
            return max;
        }
        return null;
    }

    Integer getLowestValue() {
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            int min = this.slider.getMaximum() + 1;
            while (keys.hasMoreElements()) {
                min = Math.min(min, (Integer)keys.nextElement());
            }
            if (min == this.slider.getMaximum() + 1) {
                return null;
            }
            return min;
        }
        return null;
    }

    Component getLowestValueLabel() {
        Integer min = this.getLowestValue();
        if (min != null) {
            return (Component)this.slider.getLabelTable().get(min);
        }
        return null;
    }

    Component getHighestValueLabel() {
        Integer max = this.getHighestValue();
        if (max != null) {
            return (Component)this.slider.getLabelTable().get(max);
        }
        return null;
    }

    protected int yPositionForValue(int value) {
        return this.yPositionForValue(value, this.trackRect.y, this.trackRect.height);
    }

    int yPositionForValue(int value, int trackY, int trackHeight) {
        int yPosition;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackHeight / valueRange;
        int trackBottom = trackY + (trackHeight - 1);
        if (!this.drawInverted()) {
            yPosition = trackY;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)max - (double)value)));
        } else {
            yPosition = trackY;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        yPosition = Math.max(trackY, yPosition);
        yPosition = Math.min(trackBottom, yPosition);
        return yPosition;
    }

    public int valueForYPosition(int yPos) {
        int value;
        int minValue = this.slider.getMinimum();
        int maxValue = this.slider.getMaximum();
        int trackLength = this.trackRect.height;
        int trackTop = this.trackRect.y;
        int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
        if (yPos <= trackTop) {
            value = this.drawInverted() ? minValue : maxValue;
        } else if (yPos >= trackBottom) {
            value = this.drawInverted() ? maxValue : minValue;
        } else {
            int distanceFromTrackTop = yPos - trackTop;
            double valueRange = (double)maxValue - (double)minValue;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromTrackTop = (int)Math.round((double)distanceFromTrackTop * valuePerPixel);
            value = this.drawInverted() ? minValue + valueFromTrackTop : maxValue - valueFromTrackTop;
        }
        return value;
    }

    int xPositionForValue(int value) {
        int xPosition;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int trackLength = this.trackRect.width;
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackLength / valueRange;
        int trackLeft = this.trackRect.x;
        int trackRight = this.trackRect.x + (this.trackRect.width - 1);
        if (!this.drawInverted()) {
            xPosition = trackLeft;
            xPosition = (int)((long)xPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        } else {
            xPosition = trackRight;
            xPosition = (int)((long)xPosition - Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        xPosition = Math.max(trackLeft, xPosition);
        xPosition = Math.min(trackRight, xPosition);
        return xPosition;
    }

    public int valueForXPosition(int xPos) {
        int value;
        int minValue = this.slider.getMinimum();
        int maxValue = this.slider.getMaximum();
        int trackLength = this.trackRect.width;
        int trackLeft = this.trackRect.x;
        int trackRight = this.trackRect.x + (this.trackRect.width - 1);
        if (xPos <= trackLeft) {
            value = this.drawInverted() ? maxValue : minValue;
        } else if (xPos >= trackRight) {
            value = this.drawInverted() ? minValue : maxValue;
        } else {
            int distanceFromTrackLeft = xPos - trackLeft;
            double valueRange = (double)maxValue - (double)minValue;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromTrackLeft = (int)Math.round((double)distanceFromTrackLeft * valuePerPixel);
            value = this.drawInverted() ? maxValue - valueFromTrackLeft : minValue + valueFromTrackLeft;
        }
        return value;
    }
}

