/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.timepicker;

import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TimeRange;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.timepicker.CardPanels;
import com.novell.gw.jclient.application.controls.timepicker.SliderGeometry;
import com.novell.gw.jclient.application.options.ColorsOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimePicker
extends OkCancelDialog {
    private static final Logger logger = Logger.getLogger(TimePicker.class);
    private boolean startDayIncremented = false;
    private static final String SHOW = "SHOW";
    private static final String HIDE = "HIDE";
    private static final int SLIDER_HEIGHT = 24 * PLAFChanger.getFontSize() * 2;
    private static final int MAJOR_TICK_SPACING = 4;
    private static final int MINOR_TICK_SPACING = 1;
    private static final int MAX_TICKS = 96;
    private static final int STEP = 15;
    private JSlider sldStartTime;
    private JSlider sldEndTime;
    private JPanel sliders;
    private JLabel lblStartTime;
    private JLabel lblEndTime;
    private JLabel lblDurationHour;
    private JLabel lblDurationMinute;
    private MouseListener sliderActivationListener = new SliderActivationMouseListener();
    private TimeRange timeRange;
    private StartTimeListener startChangeListener;
    private EndTimeListener endChangeListener;
    final DisplayTimeMode mode;
    private DateFormat timeFormat = new SimpleDateFormat(OptionManager.getInstance().getDateTimeOptions().getTimeFormat());
    private CardPanels<Integer> cpEndTime = new CardPanels();
    private CardPanels<Integer> cpStartTime = new CardPanels();
    private CardPanels<Integer> cpDuration = new CardPanels();
    private boolean singleDay = true;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (UnsupportedLookAndFeelException e) {
            logger.error((Object)e);
        }
        int startMinutes = 1200;
        int endMinutes = 2800;
        logger.debug((Object)("startMinutes: " + startMinutes + "; endMinutes: " + endMinutes));
        TimePicker dialog = new TimePicker(null, DisplayTimeMode.START);
        dialog.setDuration(new TimeDuration(startMinutes, endMinutes));
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        TimeDuration duration = dialog.getDuration();
        startMinutes = duration.getStartMinutes();
        endMinutes = duration.getEndMinutes();
        logger.debug((Object)("dialog.isSingleDay(): " + dialog.isSingleDay()));
        logger.debug((Object)("startMinutes: " + startMinutes + "; endMinutes: " + endMinutes));
        Calendar startTime = GWCalendarUtils.clearTime(Calendar.getInstance());
        startTime.add(12, endMinutes);
        Calendar endTime = GWCalendarUtils.clearTime(Calendar.getInstance());
        endTime.add(12, startMinutes);
        boolean singleDay = startTime.get(6) == endTime.get(6);
        logger.debug((Object)("singleDay: " + singleDay));
    }

    public TimePicker(JFrame frame) {
        this(frame, DisplayTimeMode.START);
    }

    public TimePicker(JFrame theFrame, DisplayTimeMode mode) {
        super((Frame)theFrame, true);
        this.mode = mode;
        this.init();
        this.buildUI();
        this.pack();
    }

    private void initTime() {
        this.timeRange = new TimeRange(GWCalendarUtils.getTodayWithoutTimeFraction(), GWCalendarUtils.getTodayWithoutTimeFraction());
    }

    private void scrollToVisible() {
        Rectangle rectangle = this.mode == DisplayTimeMode.START ? ((AdvancedSlider)this.sldStartTime).getColoredRectangle() : ((AdvancedSlider)this.sldEndTime).getColoredRectangle();
        rectangle.height += 100;
        this.sliders.scrollRectToVisible(rectangle);
    }

    private void buildUI() {
        this.setTitle(StringResources.TIME_INPUT);
        this.setLayout(new BorderLayout(5, 5));
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.createSliders(), "Before");
        this.add((Component)this.createInfoPanel(), "Center");
        this.initChangeListeners();
    }

    private void init() {
        this.initSliders();
        this.initStartTimeLabels();
        this.initEndTimeLabels();
        this.initDurationLabels();
        this.showStartTimeLabels(false);
        this.showEndTimeLabels(false);
        this.showDurationLabels(false);
        this.initTime();
        this.updateInfo();
    }

    private void initStartTimeLabels() {
        this.cpStartTime.addComponent(SHOW, 0, new OrientableLabel(StringResources.START_TIME_C));
        this.cpStartTime.addComponent(HIDE, 0, new JPanel());
        this.lblStartTime = new OrientableLabel();
        this.cpStartTime.addComponent(SHOW, 1, this.lblStartTime);
        this.cpStartTime.addComponent(HIDE, 1, new JPanel());
    }

    private void showStartTimeLabels(boolean b) {
        this.cpStartTime.switchCard(b ? SHOW : HIDE);
    }

    private void initEndTimeLabels() {
        this.cpEndTime.addComponent(SHOW, 0, new OrientableLabel(StringResources.END_TIME_C));
        this.cpEndTime.addComponent(HIDE, 0, new JPanel());
        this.lblEndTime = new OrientableLabel();
        this.cpEndTime.addComponent(SHOW, 1, this.lblEndTime);
        this.cpEndTime.addComponent(HIDE, 1, new JPanel());
    }

    private void showEndTimeLabels(boolean b) {
        this.cpEndTime.switchCard(b ? SHOW : HIDE);
    }

    private void initDurationLabels() {
        this.cpDuration.addComponent(SHOW, 0, new OrientableLabel(StringResources.DURATION_C));
        this.cpDuration.addComponent(HIDE, 0, new JPanel());
        this.lblDurationHour = new OrientableLabel();
        this.cpDuration.addComponent(SHOW, 1, this.lblDurationHour);
        this.cpDuration.addComponent(HIDE, 1, new JPanel());
        this.lblDurationMinute = new OrientableLabel();
        this.cpDuration.addComponent(SHOW, 2, this.lblDurationMinute);
        this.cpDuration.addComponent(HIDE, 2, new JPanel());
    }

    private void showDurationLabels(boolean b) {
        this.cpDuration.switchCard(b ? SHOW : HIDE);
    }

    private JComponent createSliders() {
        this.sliders = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        constraints.gridx = 0;
        constraints.anchor = 24;
        this.sliders.add((Component)this.sldStartTime, constraints);
        ++constraints.gridx;
        constraints.anchor = 23;
        this.sliders.add((Component)this.sldEndTime, constraints);
        this.sliders.addHierarchyListener(new VisibilityChangeListener());
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.sliders);
        scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private void addChangeListeners() {
        this.sldStartTime.addChangeListener(this.startChangeListener);
        this.sldEndTime.addChangeListener(this.endChangeListener);
    }

    private void removeChangeListeners() {
        this.sldStartTime.removeChangeListener(this.startChangeListener);
        this.sldEndTime.removeChangeListener(this.endChangeListener);
    }

    private void initChangeListeners() {
        this.startChangeListener = new StartTimeListener();
        this.endChangeListener = new EndTimeListener();
    }

    private void initSliders() {
        if (this.mode == DisplayTimeMode.END) {
            this.sldStartTime = this.createAdditionalSlider();
            this.sldEndTime = this.createMainSlider();
        } else {
            this.sldStartTime = this.createMainSlider();
            this.sldEndTime = this.createAdditionalSlider();
        }
        this.sldEndTime.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
    }

    private JSlider createMainSlider() {
        AdvancedSlider slider = new AdvancedSlider(1, 0, 96, 15);
        slider.setSnapToTicks(true);
        slider.setInverted(true);
        slider.setMajorTickSpacing(4);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setLabelTable(this.createSliderLablels());
        slider.setValue(-1);
        Dimension preferredSize = new Dimension(slider.getPreferredSize().width, SLIDER_HEIGHT);
        slider.setPreferredSize(preferredSize);
        slider.setMinimumSize(preferredSize);
        slider.addMouseMotionListener(new DoAutoscrollAdapter());
        return slider;
    }

    private JSlider createAdditionalSlider() {
        JSlider slider = new JSlider(1, 0, 96, 15);
        slider.setSnapToTicks(true);
        slider.setInverted(true);
        slider.setMajorTickSpacing(4);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(false);
        slider.setValue(-1);
        slider.addMouseMotionListener(new DoAutoscrollAdapter());
        Dimension preferredSize = new Dimension(slider.getPreferredSize().width, SLIDER_HEIGHT);
        slider.setPreferredSize(preferredSize);
        slider.setMinimumSize(preferredSize);
        return slider;
    }

    private Hashtable<Integer, JLabel> createSliderLablels() {
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>(24);
        Calendar gc = GWCalendarUtils.getToday();
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        labels.put(0, new OrientableLabel());
        for (int i = 1; i < 24; ++i) {
            gc.add(10, 1);
            OrientableLabel lab = new OrientableLabel(this.timeFormat.format(gc.getTime()));
            lab.setFont(FontOptions.getFontFor(160));
            int key = i * 4;
            labels.put(key, lab);
        }
        return labels;
    }

    private JPanel createInfoPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(0, 10, 10, 0);
        constraints.anchor = 24;
        panel.add((Component)this.createOkCancelButtonsPanel(), constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.anchor = 23;
        panel.add((Component)this.cpStartTime.getCardPanel(0), constraints);
        ++constraints.gridy;
        panel.add((Component)this.cpEndTime.getCardPanel(0), constraints);
        ++constraints.gridy;
        constraints.gridheight = 2;
        panel.add((Component)this.cpDuration.getCardPanel(0), constraints);
        ++constraints.gridx;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.anchor = 19;
        panel.add((Component)this.cpStartTime.getCardPanel(1), constraints);
        ++constraints.gridy;
        panel.add((Component)this.cpEndTime.getCardPanel(1), constraints);
        ++constraints.gridy;
        panel.add((Component)this.cpDuration.getCardPanel(1), constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.cpDuration.getCardPanel(2), constraints);
        return panel;
    }

    @Override
    protected JPanel createOkCancelButtonsPanel() {
        OrientablePanel panel = new OrientablePanel(new GridLayout(2, 1, 5, 5));
        panel.add(this.getBtnOk());
        panel.add(this.getBtnCancel());
        return panel;
    }

    private void updateInfo() {
        Calendar startCalendar = this.timeRange.getStart();
        Calendar endCalendar = this.timeRange.getEnd();
        this.lblStartTime.setText(this.timeFormat.format(startCalendar.getTime()));
        this.lblEndTime.setText(this.timeFormat.format(endCalendar.getTime()));
        int start = GWCalendarUtils.getMinutes(startCalendar);
        int end = GWCalendarUtils.getMinutes(endCalendar);
        int duration = end - start;
        int durHour = duration / 60;
        int durMin = duration % 60;
        this.lblDurationHour.setText(String.valueOf(durHour) + ' ' + StringResources.HOUR_S);
        String text = durMin + " " + StringResources.MINUTE_S;
        if (durMin < 10) {
            text = durMin + "   " + StringResources.MINUTE_S;
        }
        this.lblDurationMinute.setText(text);
    }

    private void refreshView(boolean adjustSlider) {
        if (adjustSlider) {
            int start = GWCalendarUtils.getMinutes(this.timeRange.getStart()) / 15;
            int end = GWCalendarUtils.getMinutes(this.timeRange.getEnd()) / 15;
            if (!this.isSingleDay()) {
                if (this.mode == DisplayTimeMode.END) {
                    start = 0;
                } else {
                    end = 96;
                }
            }
            this.sldStartTime.setValue(start);
            this.sldEndTime.setValue(end);
            int y = SliderGeometry.getInstance(this.sldStartTime).yPositionForValue(this.sldStartTime.getValue());
            Rectangle rec = new Rectangle(0, y, 1, 1);
            this.sliders.scrollRectToVisible(rec);
        }
        this.updateInfo();
        this.sliders.repaint();
    }

    public boolean isSingleDay() {
        return this.singleDay;
    }

    private void setSingleDay(boolean singleDay) {
        this.singleDay = singleDay;
        this.showDurationLabels(singleDay);
        this.showStartTimeLabels(singleDay || this.mode == DisplayTimeMode.START);
        this.showEndTimeLabels(singleDay || this.mode == DisplayTimeMode.END);
        this.activateAdditionalSlider(singleDay);
    }

    public void setDuration(TimeDuration duration) {
        this.initTime();
        Calendar startTime = this.timeRange.getStart();
        Calendar endTime = this.timeRange.getEnd();
        startTime.add(12, duration.getStartMinutes());
        endTime.add(12, duration.getEndMinutes());
        this.setSingleDay(startTime.get(6) == endTime.get(6));
        if (startTime.compareTo(endTime) == 1) {
            endTime.setTime(startTime.getTime());
        }
        this.timeRange.setRange(startTime, endTime);
        this.removeChangeListeners();
        this.refreshView(true);
        this.addChangeListeners();
    }

    public TimeDuration getDuration() {
        Calendar start = this.timeRange.getStart();
        Calendar end = this.timeRange.getEnd();
        int startMinutes = GWCalendarUtils.getMinutes(start);
        int endMinutes = startMinutes + GWCalendarUtils.getDuration(start, end);
        return new TimeDuration(startMinutes, endMinutes);
    }

    public boolean isStartDayIncremented() {
        return this.startDayIncremented;
    }

    private void activateAdditionalSlider(boolean b) {
        JSlider slider;
        JSlider jSlider = slider = this.mode == DisplayTimeMode.START ? this.sldEndTime : this.sldStartTime;
        if (b) {
            slider.setCursor(Cursor.getPredefinedCursor(0));
            slider.removeMouseListener(this.sliderActivationListener);
        } else {
            slider.addMouseListener(this.sliderActivationListener);
        }
        slider.setEnabled(b);
    }

    private class SliderActivationMouseListener
    extends MouseAdapter {
        private SliderActivationMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            ((Component)e.getSource()).getParent().setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent e) {
            ((Component)e.getSource()).getParent().setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseClicked(MouseEvent e) {
            JSlider slider;
            TimePicker.this.setSingleDay(true);
            JSlider jSlider = slider = TimePicker.this.mode == DisplayTimeMode.START ? TimePicker.this.sldEndTime : TimePicker.this.sldStartTime;
            if (TimePicker.this.mode == DisplayTimeMode.END) {
                TimePicker.this.startDayIncremented = true;
                Calendar start = TimePicker.this.timeRange.getStart();
                start.add(6, 1);
                TimePicker.this.timeRange.setStart(start);
            }
            slider.setValue(SliderGeometry.getInstance(slider).valueForYPosition(e.getY()));
        }
    }

    private class VisibilityChangeListener
    implements HierarchyListener {
        private VisibilityChangeListener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) == 0L || !TimePicker.this.isShowing()) {
                return;
            }
            TimePicker.this.scrollToVisible();
        }
    }

    private class AdvancedSlider
    extends JSlider {
        private boolean isDragging;
        private int dY;
        private int valueDifference;
        private SliderGeometry geometry;

        public AdvancedSlider(int orientation, int min, int max, int value) {
            super(orientation, min, max, value);
            this.isDragging = false;
            this.dY = 0;
            this.valueDifference = 0;
            MouseListener[] ml = this.getMouseListeners();
            MouseListener originMouseListener = ml[0];
            this.removeMouseListener(originMouseListener);
            this.addMouseListener(new SlideMouseAdapter(originMouseListener));
            this.addMouseMotionListener(new SliderMouseMotionAdapter());
            this.setOpaque(false);
        }

        public SliderGeometry getGeometry() {
            this.geometry = SliderGeometry.getInstance(this);
            return this.geometry;
        }

        public void paint(Graphics g) {
            Rectangle r = this.getColoredRectangle();
            g.setColor(ColorsOptions.clrSliderSelection);
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(ColorsOptions.clrSliderSelBorder);
            if (TimePicker.this.isSingleDay() || TimePicker.this.mode == DisplayTimeMode.START) {
                g.drawLine(r.x, r.y, r.x + r.width, r.y);
            }
            if (TimePicker.this.isSingleDay() || TimePicker.this.mode == DisplayTimeMode.END) {
                g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
            }
            super.paint(g);
        }

        private Rectangle getColoredRectangle() {
            int width;
            int x;
            int widthOfWidestLabel = this.getGeometry().getWidthOfWidestLabel();
            if (this.getComponentOrientation().isLeftToRight()) {
                x = this.getWidth() - widthOfWidestLabel;
                width = this.getWidth() - x;
            } else {
                x = 0;
                width = widthOfWidestLabel;
            }
            int startValue = TimePicker.this.sldStartTime.getValue();
            int endValue = TimePicker.this.sldEndTime.getValue();
            int y = this.getGeometry().yPositionForValue(startValue) - 1;
            int height = this.getGeometry().yPositionForValue(endValue) - 1 - y;
            if (!TimePicker.this.isSingleDay()) {
                if (TimePicker.this.mode == DisplayTimeMode.END) {
                    height += y;
                    y = 0;
                } else if (TimePicker.this.mode == DisplayTimeMode.START) {
                    height = this.getHeight() - y;
                }
            }
            return new Rectangle(x, y, width, height);
        }

        private class SlideMouseAdapter
        extends MouseAdapter {
            private final MouseListener originMouseListener;

            private SlideMouseAdapter(MouseListener originMouseListener) {
                this.originMouseListener = originMouseListener;
            }

            public void mouseClicked(MouseEvent e) {
                if (!AdvancedSlider.this.getColoredRectangle().contains(e.getPoint())) {
                    this.originMouseListener.mouseClicked(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                if (AdvancedSlider.this.getColoredRectangle().contains(e.getPoint())) {
                    AdvancedSlider.this.isDragging = true;
                    AdvancedSlider.this.valueDifference = TimePicker.this.sldEndTime.getValue() - TimePicker.this.sldStartTime.getValue();
                    if (TimePicker.this.mode == DisplayTimeMode.END) {
                        AdvancedSlider.this.dY = AdvancedSlider.this.getGeometry().yPositionForValue(TimePicker.this.sldEndTime.getValue()) - e.getY();
                    } else {
                        AdvancedSlider.this.dY = e.getY() - AdvancedSlider.this.getGeometry().yPositionForValue(TimePicker.this.sldStartTime.getValue());
                    }
                } else {
                    this.originMouseListener.mousePressed(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                AdvancedSlider.this.isDragging = false;
                this.originMouseListener.mouseReleased(e);
            }

            public void mouseEntered(MouseEvent e) {
                this.originMouseListener.mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                this.originMouseListener.mouseExited(e);
            }
        }

        private class SliderMouseMotionAdapter
        extends MouseMotionAdapter {
            private SliderMouseMotionAdapter() {
            }

            public void mouseDragged(MouseEvent e) {
                if (AdvancedSlider.this.isDragging) {
                    int startValue;
                    int endValue;
                    int y = e.getY();
                    SliderGeometry sliderGeometry = AdvancedSlider.this.getGeometry();
                    if (TimePicker.this.mode == DisplayTimeMode.START) {
                        int newValue = sliderGeometry.valueForYPosition(y -= AdvancedSlider.this.dY);
                        if (TimePicker.this.isSingleDay()) {
                            endValue = newValue + AdvancedSlider.this.valueDifference;
                            endValue = Math.min(endValue, AdvancedSlider.this.getMaximum());
                            startValue = endValue - AdvancedSlider.this.valueDifference;
                        } else {
                            startValue = newValue;
                            endValue = 96;
                        }
                    } else {
                        int newValue = sliderGeometry.valueForYPosition(y += AdvancedSlider.this.dY);
                        if (TimePicker.this.isSingleDay()) {
                            startValue = newValue - AdvancedSlider.this.valueDifference;
                            startValue = Math.max(startValue, AdvancedSlider.this.getMinimum());
                            endValue = startValue + AdvancedSlider.this.valueDifference;
                        } else {
                            endValue = newValue;
                            startValue = 0;
                        }
                    }
                    TimePicker.this.sldStartTime.setValue(startValue);
                    TimePicker.this.sldEndTime.setValue(endValue);
                    TimePicker.this.sldStartTime.repaint();
                    TimePicker.this.sldEndTime.repaint();
                }
            }

            public void mouseMoved(MouseEvent e) {
                if (AdvancedSlider.this.getColoredRectangle().contains(e.getPoint())) {
                    AdvancedSlider.this.setCursor(new Cursor(8));
                } else {
                    AdvancedSlider.this.setCursor(new Cursor(0));
                }
            }
        }
    }

    private class DoAutoscrollAdapter
    extends MouseMotionAdapter {
        private DoAutoscrollAdapter() {
        }

        public void mouseDragged(MouseEvent e) {
            Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
            TimePicker.this.sliders.scrollRectToVisible(r);
        }
    }

    private class EndTimeListener
    implements ChangeListener {
        private EndTimeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            int value = source.getValue();
            int start = value * 15;
            if (start == 1440) {
                start = 1439;
            }
            Calendar zero = GWCalendarUtils.clearTime((Calendar)TimePicker.this.timeRange.getStart().clone());
            zero.add(12, start);
            TimePicker.this.timeRange.setEnd(zero);
            if (value < TimePicker.this.sldStartTime.getValue()) {
                TimePicker.this.sldStartTime.setValue(value);
            } else {
                TimePicker.this.refreshView(false);
            }
        }
    }

    private class StartTimeListener
    implements ChangeListener {
        private StartTimeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            int value = source.getValue();
            int end = value * 15;
            if (end == 1440) {
                end = 1439;
            }
            Calendar start = TimePicker.this.timeRange.getStart();
            Calendar zero = GWCalendarUtils.clearTime((Calendar)start.clone());
            zero.add(12, end);
            TimePicker.this.timeRange.setStart(zero);
            if (value > TimePicker.this.sldEndTime.getValue()) {
                TimePicker.this.sldEndTime.setValue(value);
            } else {
                TimePicker.this.refreshView(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayTimeMode {
        START,
        END;

    }
}

