/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.timepicker;

import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationToken;
import com.novell.gw.jclient.application.controls.timepicker.TimeFormat;
import com.novell.gw.jclient.application.resources.StringResources;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TimeTextFormat
implements TimeFormat {
    private static Logger logger = Logger.getLogger(TimeTextFormat.class);

    public String format(Calendar theTime) {
        return GWCalendarUtils.getTimeFormatHMMA().format(theTime.getTime());
    }

    public Calendar parse(String theText) throws ParseException {
        String timeFormatPattern;
        String time;
        Pattern pattern = Pattern.compile("\\d{1,}");
        Matcher matcher = pattern.matcher(theText);
        ArrayList<DurationToken> result = new ArrayList<DurationToken>();
        while (matcher.find()) {
            String digits = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            DurationToken token = new DurationToken(digits, start, end);
            result.add(token);
        }
        if (result.isEmpty()) {
            throw new ParseException("No time found", 0);
        }
        DurationToken[] tokens = new DurationToken[result.size()];
        result.toArray(tokens);
        boolean adjustAM = true;
        boolean isAM = false;
        boolean is24HourClock = false;
        String hTime = "";
        String mTime = "";
        for (int i = 0; i < tokens.length; ++i) {
            DurationToken token = tokens[i];
            String sDigits = token.getDigits();
            if (hTime.length() == 0) {
                hTime = sDigits;
                isAM = hTime.startsWith("0");
                adjustAM = !isAM;
            } else if (mTime.length() == 0) {
                mTime = mTime + sDigits;
            }
            String txt = theText.substring(token.getEnd(), theText.length()).trim().toLowerCase();
            if (txt.startsWith(StringResources.PM_FIRST_CHARS_LOWER_CASE)) {
                isAM = false;
                adjustAM = false;
                break;
            }
            if (!txt.startsWith(StringResources.AM_FIRST_CHARS_LOWER_CASE)) continue;
            isAM = true;
            adjustAM = false;
            break;
        }
        if (theText.startsWith("PM")) {
            isAM = false;
            adjustAM = false;
        } else if (theText.startsWith("AM")) {
            isAM = true;
            adjustAM = false;
        }
        if (hTime.length() == 1) {
            hTime = '0' + hTime;
        }
        if (mTime.length() == 1) {
            mTime = '0' + mTime;
        }
        if ((time = hTime + mTime).length() == 1) {
            time = '0' + time + "00";
        }
        if (time.length() == 2) {
            time = time + "00";
        }
        if (time.length() == 3) {
            time = '0' + time;
        }
        int minutes = this.getMinutes(time);
        int hours = this.getHours(time);
        if (adjustAM) {
            boolean bl = isAM = hours > 5;
        }
        if (GWCalendarUtils.getTimeFormatHMMA() instanceof SimpleDateFormat && ("HH:mm".equals(timeFormatPattern = ((SimpleDateFormat)GWCalendarUtils.getTimeFormatHMMA()).toPattern()) || "H:mm".equals(timeFormatPattern))) {
            is24HourClock = true;
        }
        if (minutes > 59) {
            minutes = 0;
        }
        if (hours > 24) {
            hours = 0;
        }
        logger.debug((Object)("INPUT [" + theText + "] => stime [" + time + "] isAM [" + isAM + "] HH:MM [" + hours + " : " + minutes + ']'));
        if (hours == 24) {
            hours = 0;
        }
        if (hours == 12 && !is24HourClock) {
            hours = 0;
        }
        if (hours > 12 && !isAM) {
            hours -= 12;
        }
        Calendar date = GWCalendarUtils.getToday();
        if (is24HourClock && hours >= 12) {
            hours -= 12;
            isAM = false;
        }
        date.set(10, hours);
        date.set(9, isAM ? 0 : 1);
        date.set(12, minutes);
        date.set(13, 0);
        return date;
    }

    private int getMinutes(String theTime) throws ParseException {
        String sMinutes = theTime.substring(theTime.length() - 2);
        return TimeTextFormat.getInt(sMinutes);
    }

    private int getHours(String theTime) throws ParseException {
        String sHours = theTime.substring(0, theTime.length() - 2);
        return TimeTextFormat.getInt(sHours);
    }

    private static int getInt(String theTime) throws ParseException {
        int digits = 0;
        try {
            digits = Integer.parseInt(theTime);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Time is too large", 0);
        }
        return digits;
    }
}

