/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.appframework.CustomizableToolBarSeparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MultilineToolBarLayout
extends FlowLayout {
    private static final Logger logger = Logger.getLogger(MultilineToolBarLayout.class);

    public MultilineToolBarLayout(int hgap, int vgap) {
        super(3, hgap, vgap);
    }

    public MultilineToolBarLayout() {
        this(5, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            for (int i = target.getComponentCount() - 1; i >= 0; --i) {
                Component c = target.getComponent(i);
                if (!c.getClass().getName().equals("javax.swing.JSeparator")) continue;
                target.remove(i);
            }
            int maxwidth = target.getWidth() - (insets.left + insets.right + hgap * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + vgap;
            int rowh = 0;
            int start = 0;
            int height = insets.top + insets.bottom + vgap;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            ArrayList<Segment> segmentList = new ArrayList<Segment>();
            Segment segment = new Segment();
            for (int i = 0; i < nmembers; ++i) {
                Component component = target.getComponent(i);
                if (!component.isVisible()) continue;
                component.setSize(component.getPreferredSize());
                segment.components.add(component);
                if (!(component instanceof CustomizableToolBarSeparator)) continue;
                segmentList.add(segment);
                segment.initSegmentSize(hgap);
                segment = new Segment();
            }
            segmentList.add(segment);
            segment.initSegmentSize(hgap);
            int startSegment = 0;
            int n = segmentList.size();
            for (int i = 0; i < n; ++i) {
                segment = (Segment)segmentList.get(i);
                int segmentWidth = segment.getMaxWidth();
                if (x + segmentWidth <= maxwidth) {
                    x += segmentWidth;
                    rowh = Math.max(rowh, segment.getMaxHeight());
                    continue;
                }
                if (i > startSegment) {
                    int end = 0;
                    int totalWidth = 0;
                    for (int j = startSegment; j < i; ++j) {
                        Segment s = (Segment)segmentList.get(j);
                        rowh = Math.max(rowh, s.getMaxHeight());
                        totalWidth += s.getMaxWidth();
                        end += s.components.size();
                    }
                    this.moveComponents(target, insets.left + hgap, y, totalWidth, rowh, start, start + end, ltr);
                    startSegment = i--;
                    start += end;
                    height += vgap + rowh;
                    y += vgap + rowh;
                    x = 0;
                    rowh = 0;
                } else {
                    startSegment = i + 1;
                    int nc = segment.components.size();
                    if (nc > 0) {
                        int totalWidth = 0;
                        int itemCount = 0;
                        x = 0;
                        for (int j = 0; j < nc; ++j) {
                            Component c = (Component)segment.components.get(j);
                            Dimension d = c.getPreferredSize();
                            if (x == 0 || x + d.width <= maxwidth) {
                                if (x > 0) {
                                    x += hgap;
                                    totalWidth += hgap;
                                }
                                x += d.width;
                                totalWidth += d.width;
                                rowh = Math.max(rowh, d.height);
                                ++itemCount;
                                continue;
                            }
                            if (j == nc - 1 && c instanceof CustomizableToolBarSeparator) {
                                if (itemCount > 1) {
                                    --itemCount;
                                    totalWidth -= ((Component)segment.components.get((int)(--j))).getPreferredSize().width;
                                } else if (itemCount == 1) {
                                    ++itemCount;
                                    ++j;
                                    totalWidth += c.getPreferredSize().width;
                                }
                            }
                            this.moveComponents(target, insets.left + hgap, y, totalWidth, rowh, start, start + itemCount, ltr);
                            height += vgap + rowh;
                            y += vgap + rowh;
                            start += itemCount;
                            totalWidth = 0;
                            --j;
                            x = 0;
                            itemCount = 0;
                        }
                        if (itemCount > 0) {
                            this.moveComponents(target, insets.left + hgap, y, totalWidth, rowh, start, start + itemCount, ltr);
                            height += vgap + rowh;
                            y += vgap + rowh;
                            start += itemCount;
                            x = 0;
                        }
                    }
                }
                if (i >= n - 1 || start >= target.getComponentCount()) continue;
                JSeparator separator = new JSeparator();
                Dimension separatorSize = new Dimension(maxwidth - hgap, separator.getPreferredSize().height + vgap);
                separator.setSize(separatorSize);
                target.add((Component)separator, start);
                this.moveComponents(target, insets.left + hgap, y, maxwidth, separatorSize.height + vgap, start, start + 1, ltr);
                ++nmembers;
                height += vgap + separatorSize.height;
                y += vgap + separatorSize.height;
                ++start;
            }
            if (start < nmembers - 1) {
                height += vgap + rowh;
                this.moveComponents(target, insets.left + hgap, y, maxwidth - x, rowh, start, nmembers, ltr);
            }
            if (target.getPreferredSize().height != height) {
                Dimension preferredSize = new Dimension(target.getWidth(), height);
                target.setPreferredSize(preferredSize);
                SwingUtilities.getWindowAncestor(target).validate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.getAlignment()) {
                case 0: {
                    x += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x += width;
                }
            }
            int n = target.getComponentCount();
            for (int i = rowStart; i < rowEnd && i < n; ++i) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    if (ltr) {
                        m.setLocation(x, y + (height - m.getHeight()) / 2);
                    } else {
                        m.setLocation(target.getWidth() - x - m.getWidth(), y + (height - m.getHeight()) / 2);
                    }
                    x += m.getWidth() + this.getHgap();
                }
                if (!(m instanceof CustomizableToolBarSeparator)) continue;
                CustomizableToolBarSeparator cvs = (CustomizableToolBarSeparator)m;
                cvs.setLocation(cvs.getX(), y);
                cvs.setSize(cvs.getWidth(), height);
            }
        }
    }

    private static class Segment {
        List components = new ArrayList();
        int width = 0;
        int height = 0;

        private Segment() {
        }

        void initSegmentSize(int hgap) {
            int w = hgap;
            int n = this.components.size();
            for (int i = 0; i < n; ++i) {
                Component c = (Component)this.components.get(i);
                Dimension d = c.getPreferredSize();
                w += d.width + hgap;
                this.height = Math.max(this.height, d.height);
            }
            this.width = w;
        }

        int getMaxHeight() {
            return this.height;
        }

        int getMaxWidth() {
            return this.width;
        }
    }
}

