/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.novell.gw.jclient.application.controls.toolbars.ext.ResizableToolbar;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import org.apache.log4j.Logger;

public class ToolBarsLayout
implements LayoutManager {
    private static Logger logger = Logger.getLogger(ToolBarsLayout.class);
    int hgap;
    int vgap;

    public ToolBarsLayout() {
        this(5, 5);
    }

    public ToolBarsLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                dim.height = Math.max(dim.height, d.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                dim.height = Math.max(dim.height, d.height);
                if (i > 0) {
                    dim.width += this.hgap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ltr) {
                    if (x < 0) {
                        x = 0;
                        new Exception().printStackTrace();
                    }
                    m.setLocation(x, y + (height - m.getHeight()) / 2);
                } else {
                    m.setLocation(target.getWidth() - x - m.getWidth(), y + (height - m.getHeight()) / 2);
                }
                x += m.getWidth() + this.hgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxWidth = target.getWidth() - (insets.left + insets.right + this.hgap * 2);
            int maxHeight = 0;
            int currentWidth = 0;
            int nmembers = target.getComponentCount();
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < nmembers; ++i) {
                ResizableToolbar toolbar = (ResizableToolbar)target.getComponent(i);
                if (!toolbar.isVisible()) continue;
                int componentHeight = toolbar.getPreferredSize().height;
                int componentWidth = toolbar.getCurrentWidth();
                int minRequiredWidth = this.getMinimumWidth(target, i + 1, nmembers);
                if (maxWidth - currentWidth >= minRequiredWidth + componentWidth) {
                    if (ToolBarUtils.isLastVisible(toolbar)) {
                        toolbar.setSize(maxWidth - currentWidth, componentHeight);
                    } else {
                        toolbar.setSize(componentWidth, componentHeight);
                    }
                } else {
                    int width = Math.max(toolbar.getMinimumSize().width, maxWidth - currentWidth - minRequiredWidth);
                    toolbar.setSize(width, componentHeight);
                }
                currentWidth += toolbar.getWidth() + this.hgap;
                maxHeight = Math.max(maxHeight, toolbar.getHeight());
            }
            this.moveComponents(target, insets.left + this.hgap, insets.top + this.vgap, maxWidth, maxHeight, 0, nmembers, ltr);
        }
    }

    private int getMinimumWidth(Container target, int theFromIndex, int theToIndex) {
        int result = 0;
        int visibleComponents = 0;
        for (int i = theFromIndex; i < theToIndex; ++i) {
            Component component = target.getComponent(i);
            if (!component.isVisible()) continue;
            result += component.getMinimumSize().width;
            ++visibleComponents;
        }
        return result += this.hgap * visibleComponents;
    }
}

