/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeCellEditor;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.navigation.MultipleCheckFoldersTreeController;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleCheckFoldersTree
extends PlainFoldersTree {
    private static Logger logger = Logger.getLogger(MultipleCheckFoldersTree.class);
    private AbstractFolder selectedFolder;
    List<AbstractFolder> selectedFolderList = new ArrayList<AbstractFolder>();
    Set<AbstractFolder> originalFolderSet = new HashSet<AbstractFolder>();

    public MultipleCheckFoldersTree(MVCController parentController, String userGuid, List<AbstractFolder> selectedFolderList) {
        super(parentController, userGuid);
        this.setCellRenderer(new TreeRenderrer());
        this.addMouseListener(new CheckedTreeMouseListener());
        this.selectedFolderList = selectedFolderList;
        this.originalFolderSet = MultipleCheckFoldersTree.createFolderSet(selectedFolderList);
        GWFoldersTreeCellEditor ed = new GWFoldersTreeCellEditor(this, this.renderer);
        this.setCellEditor(ed);
        this.addTreeSelectionListener(new PlainFoldersTree.TreeSetEditableListener(this));
    }

    @Override
    protected MultipleCheckFoldersTreeController createFolderTreeController(MVCController parentController) {
        return new MultipleCheckFoldersTreeController(this, parentController);
    }

    protected static boolean canSelectFolder(AbstractFolder folder) {
        return true;
    }

    @Override
    public AbstractFolder getSelectedFolder() {
        if (this.selectedFolder == null) {
            this.selectedFolder = super.getSelectedFolder();
        }
        return this.selectedFolder;
    }

    @Override
    public void selectFolder(AbstractFolder theFolder) {
        this.selectedFolder = theFolder;
        this.repaint();
        super.selectFolder(this.selectedFolder);
    }

    public List<AbstractFolder> getSelectedFolderList() {
        return this.selectedFolderList;
    }

    public boolean isFolderListChanged() {
        Set<AbstractFolder> set = MultipleCheckFoldersTree.createFolderSet(this.selectedFolderList);
        return !((Object)this.originalFolderSet).equals(set);
    }

    private static Set<AbstractFolder> createFolderSet(List<AbstractFolder> folderList) {
        HashSet<AbstractFolder> set = new HashSet<AbstractFolder>();
        for (AbstractFolder folder : folderList) {
            set.add(folder);
        }
        return set;
    }

    private static class TreeLabel
    extends OrientableLabel {
        boolean isSelected;
        boolean hasFocus;

        private TreeLabel() {
        }

        public void paint(Graphics g) {
            String str = this.getText();
            if (str != null && 0 < str.length()) {
                if (this.isSelected) {
                    g.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    g.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension d = this.getPreferredSize();
                int imageOffset = 0;
                Icon currentI = this.getIcon();
                if (currentI != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
            }
            super.paint(g);
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }
    }

    private class CheckedTreeMouseListener
    extends MouseAdapter {
        private CheckedTreeMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = MultipleCheckFoldersTree.this.getRowForLocation(x, y = e.getY());
            TreePath path = MultipleCheckFoldersTree.this.getPathForRow(row);
            if (path != null) {
                boolean pressedOnCheck;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                AbstractFolder folder = (AbstractFolder)node.getUserObject();
                TreeRenderrer treeRenderrer = (TreeRenderrer)MultipleCheckFoldersTree.this.getCellRenderer();
                Rectangle pathBounds = MultipleCheckFoldersTree.this.getPathBounds(path);
                if (UIUtils.getComponentOrientation().isLeftToRight()) {
                    pressedOnCheck = x > pathBounds.x && x < pathBounds.x + treeRenderrer.CHECK_WIDTH;
                } else {
                    int startX = pathBounds.x + pathBounds.width;
                    boolean bl = pressedOnCheck = x > startX - treeRenderrer.CHECK_WIDTH && x < startX;
                }
                if (pressedOnCheck) {
                    if (MultipleCheckFoldersTree.this.getSelectedFolderList().contains(folder)) {
                        MultipleCheckFoldersTree.this.getSelectedFolderList().remove(folder);
                    } else {
                        MultipleCheckFoldersTree.this.getSelectedFolderList().add(folder);
                    }
                }
                treeRenderrer.check.setSelected(!treeRenderrer.check.isSelected());
                ((DefaultTreeModel)MultipleCheckFoldersTree.this.getModel()).nodeChanged(node);
            }
        }
    }

    private class TreeRenderrer
    extends OrientablePanel
    implements TreeCellRenderer,
    TextTreeRenderer {
        private JCheckBox check = new OrientableCheckBox();
        private final TreeLabel label = new TreeLabel();
        public final int CHECK_WIDTH;
        private int rowHeight;

        public TreeRenderrer() {
            this.CHECK_WIDTH = this.check.getPreferredSize().width;
            this.rowHeight = PLAFChanger.getTreeRowHeight();
            this.setLayout(new FlowLayout(3, 0, 0));
            this.add(this.check);
            this.add(this.label);
            this.label.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.check = new OrientableCheckBox();
            this.remove(0);
            this.add((Component)this.check, 0);
            AbstractFolder folder = (AbstractFolder)((DefaultMutableTreeNode)value).getUserObject();
            this.check.setOpaque(!LookAndFeelManager.isGtkLookAndFeel());
            this.check.setPreferredSize(new Dimension(this.CHECK_WIDTH, this.rowHeight));
            this.label.setSelected(selected);
            this.check.setSelected(MultipleCheckFoldersTree.this.selectedFolderList.contains(folder));
            if (selected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(tree.getBackground());
                this.label.setForeground(UIManager.getColor("Tree.foreground"));
            }
            this.check.setBackground(tree.getBackground());
            this.label.setText(value.toString() + ' ');
            this.label.setFont(tree.getFont());
            if (tree.getRowHeight() != 0) {
                this.rowHeight = tree.getRowHeight();
            }
            if (folder != null) {
                this.label.setIcon(ControlsUtils.getImageForFolder(folder));
            }
            return this;
        }

        public Component getComponent() {
            return this;
        }

        public int getTextX() {
            return this.CHECK_WIDTH + this.label.getIcon().getIconWidth() + this.label.getIconTextGap();
        }
    }
}

