/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import javax.swing.Action;
import javax.swing.ImageIcon;

public class NavBarButton
extends ToolBarToggleButton {
    protected NavBarPanel masterPanel = null;
    private boolean firstButton = false;
    private NavBarButton nextButton = null;
    private static final Insets NAVBARBUTTON_INSETS = new Insets(4, 11, 4, 11);

    public NavBarButton(Action a, NavBarPanel navBarPanel) {
        super(a);
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.BACKGROUND_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.BACK_TOP_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_START_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_START_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_BORDER_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEPARATOR_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.NAVBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.NAVBAR_FONT_SIZE, ComponentProperty.FONT_SIZE);
        this.masterPanel = navBarPanel;
        this.setBorderPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setOpaque(false);
    }

    public NavBarButton(ImageIcon icon, NavBarPanel navBarPanel) {
        super(icon);
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.BACKGROUND_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.BACK_TOP_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_START_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_START_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_BORDER_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEPARATOR_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.NAVBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.NAVBAR_FONT_SIZE, ComponentProperty.FONT_SIZE);
        this.masterPanel = navBarPanel;
        this.setBorderPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setOpaque(false);
    }

    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        Rectangle stringBounds = g.getFontMetrics(this.getFont()).getStringBounds(this.getText(), g).getBounds();
        Insets i = NAVBARBUTTON_INSETS;
        int w = stringBounds.width + i.left + i.right;
        int h = stringBounds.height + i.top + i.bottom;
        return new Dimension(w, h);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Insets getInsets() {
        return NAVBARBUTTON_INSETS;
    }

    public void paint(Graphics g) {
        int deltaW;
        Graphics2D g2D = (Graphics2D)UIUtils.enableAntialiasing(g);
        Color highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.BACK_TOP_END_COLOR);
        Color highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.BACKGROUND_COLOR);
        Color lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.BACK_TOP_END_COLOR);
        Color lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.BACKGROUND_COLOR);
        Color textColor = (Color)this.getClientProperty((Object)SkinProperty.NAVBAR_TEXT_COLOR);
        Color borderColor = null;
        boolean paintSegments = true;
        if (this.getModel().isRollover() && !this.getModel().isSelected()) {
            highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
            highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
            lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
            lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
            textColor = (Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR);
            borderColor = (Color)this.getClientProperty((Object)SkinProperty.HILITE_BORDER_COLOR);
        } else if (this.getModel().isSelected()) {
            highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.SEL_START_COLOR);
            highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.SEL_END_COLOR);
            lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.SEL_START_COLOR);
            lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.SEL_END_COLOR);
            textColor = (Color)this.getClientProperty((Object)SkinProperty.TOOLBAR_TEXT_COLOR);
            borderColor = (Color)this.getClientProperty((Object)SkinProperty.SEL_BORDER_COLOR);
        } else {
            paintSegments = false;
        }
        int n = deltaW = this.firstButton ? 1 : 0;
        if (paintSegments) {
            int w = this.getPreferredSize().width;
            int h = this.getSize().height;
            GeneralPath border = new GeneralPath();
            border.moveTo(4 + deltaW, 1.0f);
            border.lineTo(3 + deltaW, 1.0f);
            border.lineTo(1 + deltaW, 3.0f);
            border.lineTo(1 + deltaW, 4.0f);
            border.lineTo(0 + deltaW, 5.0f);
            border.lineTo(0 + deltaW, h - 1);
            border.lineTo(w - 1, h - 1);
            border.lineTo(w - 1, 5.0f);
            border.lineTo(w - 2, 4.0f);
            border.lineTo(w - 2, 3.0f);
            border.lineTo(w - 4, 1.0f);
            border.lineTo(w - 5, 1.0f);
            border.lineTo(w - 6, 0.0f);
            border.lineTo(5 + deltaW, 0.0f);
            GradientPaint paintHigherSegment = new GradientPaint(deltaW, 0.0f, highSegmentColorFrom, deltaW, (int)((double)this.getHeight() * 0.3), highSegmentColorTo);
            g2D.setPaint(paintHigherSegment);
            g2D.fill(border);
            GradientPaint paintLowerSegment = new GradientPaint(deltaW, (int)((double)this.getHeight() * 0.3), lowSegmentColorFrom, deltaW, this.getHeight(), lowSegmentColorTo);
            g2D.setPaint(paintLowerSegment);
            g2D.fillRect(deltaW, (int)((double)this.getHeight() * 0.3), w, this.getHeight());
            if (borderColor != null) {
                g2D.setColor(borderColor);
                g2D.draw(border);
            }
        }
        g2D.setColor(textColor);
        if (this.getText() != null) {
            g2D.drawString(this.getText(), NavBarButton.NAVBARBUTTON_INSETS.left + deltaW, this.getHeight() - NavBarButton.NAVBARBUTTON_INSETS.bottom - this.getFontMetrics(g2D.getFont()).getDescent());
        }
        if (this.getIcon() != null) {
            Dimension btnSize = this.getSize();
            int iw = this.getIcon().getIconWidth();
            int ih = this.getIcon().getIconHeight();
            g2D.drawImage(((ImageIcon)this.getIcon()).getImage(), (btnSize.width - iw) / 2 + deltaW, (btnSize.height - ih) / 2, this);
        }
        if (!paintSegments) {
            this.paintSeparator(g2D);
        }
    }

    protected void paintSeparator(Graphics2D g2D) {
        if (this.masterPanel.isSeparatorVisible()) {
            int w = this.getPreferredSize().width - 1;
            int h = this.getSize().height;
            g2D.setColor((Color)this.getClientProperty((Object)SkinProperty.SEPARATOR_COLOR));
            if (this.firstButton) {
                g2D.drawLine(0, 6, 0, h - 3);
            }
            if (this.nextButton == null || !this.nextButton.getModel().isSelected()) {
                g2D.drawLine(w, 6, w, h - 3);
            }
        }
    }

    public boolean isFirstButton() {
        return this.firstButton;
    }

    public void setFirstButton(boolean firstButton) {
        this.firstButton = firstButton;
    }

    public NavBarButton getNextButton() {
        return this.nextButton;
    }

    public void setNextButton(NavBarButton nextButton) {
        this.nextButton = nextButton;
    }
}

