/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.navigation;

import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButton;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarButtonTransferData;
import com.novell.gw.jclient.application.controls.toolbars.navigation.NavBarPanel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

class NavBarButtonTransferable
implements Transferable {
    private static Logger logger = Logger.getLogger(NavBarButtonTransferable.class);
    public static final DataFlavor navBarButtonFlavor = new DataFlavor(NavBarButtonFlavor.class, "NavBarButtonFlavor");
    private Set<DataFlavor> flavors = new HashSet<DataFlavor>();
    private NavBarButtonTransferData transferData;

    public NavBarButtonTransferable(NavBarButtonTransferData transferData) {
        this.transferData = transferData;
        this.flavors.add(navBarButtonFlavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.flavors.contains(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavor.equals(navBarButtonFlavor)) {
            return this.transferData;
        }
        throw new AssertionError((Object)("unpredictable flavor: " + flavor));
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[this.flavors.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavors.contains(flavor);
    }

    private static class NavBarButtonFlavor
    extends NavBarButton {
        public NavBarButtonFlavor(Action a, NavBarPanel navBarPanel) {
            super(a, navBarPanel);
        }

        public NavBarButtonFlavor(ImageIcon icon, NavBarPanel navBarPanel) {
            super(icon, navBarPanel);
        }
    }
}

