/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.folder.INntpFolder;
import com.novell.gw.jclient.application.controls.addressbook.SimpleSelectorDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.search.FrameItemSearch;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public class SearchOnTheNntpServerDialog
extends OkCancelDialog {
    private OrientableComboBox cmbFind;
    private GWTextField tfSearchString;
    private MVCController parentController;
    private INntpFolder folder;
    private OrientableButton btnViewAddressBook;
    private String[] items = new String[]{StringResources.SUBJECT, StringResources.FROM};

    public SearchOnTheNntpServerDialog(JFrame frame, MVCController parentController, INntpFolder folder) {
        super(frame);
        this.parentController = parentController;
        this.folder = folder;
        this.initUI();
        this.buildDialogUI();
        this.tfSearchString.requestFocusInWindow();
    }

    private void initUI() {
        this.cmbFind = new OrientableComboBox(this.items);
        this.cmbFind.addActionListener(new CmbFindActionListener());
        this.tfSearchString = new GWTextField(22);
        this.btnViewAddressBook = new OrientableButton(new ViewAddressBookAction());
        this.btnViewAddressBook.setPreferredSize(new Dimension(23, 23));
        this.btnViewAddressBook.setVisible(false);
    }

    private void buildDialogUI() {
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        OrientableLabel lbl = new OrientableLabel(StringResources.FIND_HEADERS_WHERE_C);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 0, 5, 0);
        gbc.anchor = 21;
        pnl.add((Component)lbl, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 0, 0);
        pnl.add((Component)this.buildSearchpanel(), gbc);
        OrientablePanel pnltemp = new OrientablePanel(new BorderLayout(5, 5));
        pnltemp.add((Component)this.getBtnOk(), "First");
        pnltemp.add((Component)this.getBtnCancel(), "Last");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        pnl.add((Component)pnltemp, gbc);
        this.setTitle(StringResources.SEARCH_HEADERS_ON_NNTP_SERVER);
        pnl.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(pnl);
    }

    private OrientablePanel buildSearchpanel() {
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 5);
        pnl.add((Component)this.cmbFind, gbc);
        OrientableLabel lbl = new OrientableLabel(StringResources.CONTAINS);
        ++gbc.gridx;
        pnl.add((Component)lbl, gbc);
        ++gbc.gridx;
        pnl.add((Component)this.tfSearchString, gbc);
        ++gbc.gridx;
        pnl.add((Component)this.btnViewAddressBook, gbc);
        return pnl;
    }

    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        IFolder resultFolder = this.cmbFind.getSelectedIndex() == 0 ? this.folder.find("", this.tfSearchString.getText()) : this.folder.find(this.tfSearchString.getText(), "");
        String userGuid = EngineCommandManager.getUserGuid();
        FrameItemSearch frame = new FrameItemSearch(userGuid, (QueryFolder)EngineCommandManager.getInstance(userGuid).getGWFolder(resultFolder));
        frame.showMe();
    }

    private class CmbFindActionListener
    implements ActionListener {
        private CmbFindActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SearchOnTheNntpServerDialog.this.cmbFind.getSelectedIndex() == 0) {
                SearchOnTheNntpServerDialog.this.btnViewAddressBook.setVisible(false);
            } else {
                SearchOnTheNntpServerDialog.this.btnViewAddressBook.setVisible(true);
            }
            SearchOnTheNntpServerDialog.this.pack();
        }
    }

    protected class ViewAddressBookAction
    extends AbstractAction {
        public ViewAddressBookAction() {
            super("", ImageResources.ICON_ACT_VIEW_ADDRESS_SELECTOR);
        }

        public void actionPerformed(ActionEvent e) {
            SimpleSelectorDialog selectorDialog = new SimpleSelectorDialog(SearchOnTheNntpServerDialog.this, SearchOnTheNntpServerDialog.this.parentController);
            selectorDialog.setVisible(true);
            if (selectorDialog.isOkActionProcessed()) {
                IContact iContact = selectorDialog.getSelectedEntry();
                SearchOnTheNntpServerDialog.this.tfSearchString.setText(iContact == null ? "" : iContact.getDisplayName());
            }
        }
    }
}

