/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.resources.GWIcons;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.NewsgroupMessageMode;
import com.novell.gw.jclient.application.dialogs.SelectNewsgroupDialogModel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectNewsgroupDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(SelectNewsgroupDialog.class);
    private OrientableList listAvaliableNews;
    private OrientableList listSelectedNews;
    private OrientableButton btnAdd;
    private OrientableButton btnRemove;
    private OrientableRadioButton rbtnListSubscribed;
    private OrientableRadioButton rbtnListAll;
    private OrientableRadioButton rbtnNewsgroups;
    private OrientableRadioButton rbtnFollowup;
    private OrientableButton btnOk;
    private OrientableButton btnCancel;
    private AvalibleNewsListModel avalibleNewsListModel;
    private SelectedNewsListModel selectedNewsListModel;
    private SelectNewsgroupDialogModel model;

    public SelectNewsgroupDialog(JFrame parentFrame, NntpAccount account, List<String> newsgroupFolders, List<String> followFolders, boolean isNewsgroupSelected) {
        super(parentFrame);
        NewsgroupMessageMode mode = isNewsgroupSelected ? NewsgroupMessageMode.NEWSGROUP : NewsgroupMessageMode.FOLLOWUP;
        this.model = new SelectNewsgroupDialogModel(this, mode, true, account, followFolders, newsgroupFolders);
        this.initUI(isNewsgroupSelected);
        this.buildNewsgroupsUI();
    }

    private SelectNewsgroupDialogModel getModel() {
        return this.model;
    }

    private void buildNewsgroupsUI() {
        OrientablePanel contentPane = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        OrientablePanel leftPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel midPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel rightPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel midButtonsPnl = new OrientablePanel(new GridLayout(2, 1, 5, 5));
        OrientablePanel leftDownPnlBL = new OrientablePanel(new BorderLayout());
        OrientablePanel leftDownPnlGL = new OrientablePanel(new GridLayout(2, 1));
        OrientablePanel rightDownPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel rightDownCheckBoxPnlBL = new OrientablePanel(new BorderLayout());
        OrientablePanel rightDownCheckBoxPnlGL = new OrientablePanel(new GridLayout(2, 1));
        OrientablePanel rightDownButtonPnlGL = new OrientablePanel(new GridLayout(2, 1, 5, 5));
        OrientablePanel rightDownButtonPnlBL = new OrientablePanel(new BorderLayout());
        OrientableLabel leftLbl = new OrientableLabel(StringResources.AVALIABLE_NEWSGROUPS);
        OrientableLabel rightLbl = new OrientableLabel(StringResources.SELECTED_NEWSGRUPS);
        OrientableScrollPane rightListScroll = new OrientableScrollPane(this.listSelectedNews);
        OrientableScrollPane leftListScroll = new OrientableScrollPane(this.listAvaliableNews);
        leftListScroll.setPreferredSize(new Dimension(250, 150));
        rightListScroll.setPreferredSize(new Dimension(250, 150));
        leftPnl.add((Component)leftListScroll, "Center");
        rightPnl.add((Component)rightListScroll, "Center");
        midButtonsPnl.add(this.btnAdd);
        midButtonsPnl.add(this.btnRemove);
        midPnl.add((Component)midButtonsPnl, "North");
        leftDownPnlGL.add(this.rbtnListSubscribed);
        leftDownPnlGL.add(this.rbtnListAll);
        leftDownPnlBL.add((Component)leftDownPnlGL, "North");
        rightDownCheckBoxPnlGL.add(this.rbtnNewsgroups);
        rightDownCheckBoxPnlGL.add(this.rbtnFollowup);
        rightDownCheckBoxPnlBL.add((Component)rightDownCheckBoxPnlGL, "North");
        rightDownButtonPnlGL.add(this.btnOk);
        rightDownButtonPnlGL.add(this.btnCancel);
        rightDownButtonPnlBL.add((Component)rightDownButtonPnlGL, "North");
        rightDownPnl.add((Component)rightDownCheckBoxPnlBL, "Before");
        rightDownPnl.add((Component)rightDownButtonPnlBL, "After");
        gbc.anchor = 23;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contentPane.add((Component)leftLbl, gbc);
        gbc.insets = new Insets(10, 5, 5, 10);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contentPane.add((Component)rightLbl, gbc);
        gbc.insets = new Insets(0, 10, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        contentPane.add((Component)leftPnl, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 19;
        contentPane.add((Component)midPnl, gbc);
        gbc.insets = new Insets(0, 5, 5, 10);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        contentPane.add((Component)rightPnl, gbc);
        gbc.insets = new Insets(0, 10, 10, 5);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        contentPane.add((Component)leftDownPnlBL, gbc);
        gbc.insets = new Insets(0, 5, 10, 10);
        gbc.gridx = 2;
        gbc.gridy = 2;
        contentPane.add((Component)rightDownPnl, gbc);
        this.setContentPane(contentPane);
        this.pack();
    }

    private void initUI(boolean isNewsgroupSelected) {
        RemoveAction removeAction = new RemoveAction();
        AddAction addAction = new AddAction();
        this.listAvaliableNews = new OrientableList();
        this.avalibleNewsListModel = new AvalibleNewsListModel();
        this.listAvaliableNews.setModel(this.avalibleNewsListModel);
        this.listAvaliableNews.addListSelectionListener(addAction);
        this.listAvaliableNews.setCellRenderer(new Renderer());
        this.listSelectedNews = new OrientableList();
        this.selectedNewsListModel = new SelectedNewsListModel();
        this.listSelectedNews.setModel(this.selectedNewsListModel);
        this.listSelectedNews.addListSelectionListener(removeAction);
        this.listSelectedNews.setCellRenderer(new Renderer());
        this.btnAdd = new OrientableButton(addAction);
        this.btnRemove = new OrientableButton(removeAction);
        ActionListener a = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectNewsgroupDialog.this.getModel().setShowSubscribedOnly(SelectNewsgroupDialog.this.rbtnListSubscribed.isSelected());
                SelectNewsgroupDialog.this.getModel().setMode(SelectNewsgroupDialog.this.rbtnNewsgroups.isSelected() ? NewsgroupMessageMode.NEWSGROUP : NewsgroupMessageMode.FOLLOWUP);
            }
        };
        this.rbtnListSubscribed = new OrientableRadioButton(StringResources.LIST_SUBSCRIBED);
        this.rbtnListSubscribed.addActionListener(a);
        this.rbtnListAll = new OrientableRadioButton(StringResources.LIST_ALL);
        this.rbtnListAll.addActionListener(a);
        this.rbtnNewsgroups = new OrientableRadioButton(StringResources.NEWSGROUPS);
        this.rbtnNewsgroups.addActionListener(a);
        this.rbtnFollowup = new OrientableRadioButton(StringResources.FOLLOWUP_TO);
        this.rbtnFollowup.addActionListener(a);
        this.btnOk = new OrientableButton(new OKAction());
        this.btnCancel = new OrientableButton(new CancelAction());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbtnNewsgroups);
        bg.add(this.rbtnFollowup);
        bg = new ButtonGroup();
        bg.add(this.rbtnListAll);
        bg.add(this.rbtnListSubscribed);
        if (isNewsgroupSelected) {
            this.rbtnNewsgroups.setSelected(true);
        } else {
            this.rbtnFollowup.setSelected(true);
        }
        this.rbtnListSubscribed.setSelected(true);
    }

    void handleAvailableListChanged() {
        this.avalibleNewsListModel.fireRefresh();
        this.listAvaliableNews.getSelectionModel().clearSelection();
    }

    void handleSelectedListChanged() {
        this.selectedNewsListModel.fireRefresh();
        this.listSelectedNews.getSelectionModel().clearSelection();
    }

    public List<String> getFollowupFolders() {
        return this.model.getFollowupList();
    }

    public List<String> getNewsgroupFolders() {
        return this.model.getNewsgroupList();
    }

    private class Renderer
    extends JLabel
    implements ListCellRenderer {
        public Renderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String folderName = (String)value;
            if (SelectNewsgroupDialog.this.getModel().isFolderSubscribed(folderName)) {
                this.setIcon(ImageResources.FLD_NNTP_NEWSGROUPS);
            } else {
                this.setIcon(GWIcons.EMPTY_ICON);
            }
            this.setText(folderName);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class SelectedNewsListModel
    extends DefaultListModel {
        private SelectedNewsListModel() {
        }

        public int getSize() {
            return SelectNewsgroupDialog.this.getModel().getSelectedList().size();
        }

        public String getElementAt(int index) {
            return SelectNewsgroupDialog.this.getModel().getSelectedList().get(index);
        }

        public void fireRefresh() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private class AvalibleNewsListModel
    extends DefaultListModel {
        private AvalibleNewsListModel() {
        }

        public int getSize() {
            return SelectNewsgroupDialog.this.getModel().getAvailableList().size();
        }

        public String getElementAt(int index) {
            return SelectNewsgroupDialog.this.getModel().getAvailableList().get(index);
        }

        public void fireRefresh() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private class RemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveAction() {
            super("<< " + StringResources.REMOVE + " <<");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SelectNewsgroupDialog.this.getModel().removeSelectedFolders(SelectNewsgroupDialog.this.listSelectedNews.getSelectedIndices());
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.setEnabled(SelectNewsgroupDialog.this.listSelectedNews.getSelectedIndex() >= 0);
        }
    }

    private class AddAction
    extends AbstractAction
    implements ListSelectionListener {
        public AddAction() {
            super(">> " + StringResources.ADD + " >>");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SelectNewsgroupDialog.this.getModel().addAvailableFolders(SelectNewsgroupDialog.this.listAvaliableNews.getSelectedIndices());
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.setEnabled(SelectNewsgroupDialog.this.listAvaliableNews.getSelectedIndex() >= 0);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            SelectNewsgroupDialog.this.setActionCompleteSuccessfully(false);
            SelectNewsgroupDialog.this.dispose();
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            SelectNewsgroupDialog.this.setActionCompleteSuccessfully(true);
            SelectNewsgroupDialog.this.dispose();
        }
    }
}

