/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.resources.GWIcons;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.Account;
import com.novell.gw.account.AccountFolderEvent;
import com.novell.gw.account.AccountFolderList;
import com.novell.gw.account.AccountFolderListener;
import com.novell.gw.account.ImapAccount;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class SubscribeNewsgroupDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(SubscribeNewsgroupDialog.class);
    private static final int MAX_ROWS = 9;
    private static final int NEWSGROUP_COLUMN_WIDTH_SCALE_FACTOR = 4;
    private OrientableButton btnClose = new OrientableButton(new ActionClose());
    private OrientableButton btnSub = new OrientableButton(new ActionSubscribe());
    private OrientableButton btnUnsub = new OrientableButton(new ActionUnSubscribe());
    private OrientableButton btnRefresh = new OrientableButton(new ActionRefreshList());
    private OrientableButton btnSerch = new OrientableButton(new ActionSearch());
    private static final String TAB1_NAME = StringResources.ALL;
    private static final String TAB2_NAME = StringResources.SUBSCRIBED;
    private static final String TAB3_NAME = StringResources.NEW;
    private static final String TAB3_NAME_IMAP = StringResources.SHARED_FOLDERS;
    private static final String TAB4_NAME_IMAP = StringResources.PUBLIC_FOLDERS;
    private GWTextField tfSearch = new GWTextField(20);
    private OrientableTabbedPane tabPane = new OrientableTabbedPane();
    private GWTable tableAll = new GWTable();
    private GWTable tableSub = new GWTable();
    private GWTable tableNew = new GWTable();
    private GWTable tableShared = new GWTable();
    private GWTable tablePublic = new GWTable();
    private Account account;
    private JTable selectedTable = this.tableAll;
    private IconTableRenderer iconTableRenderer;

    public SubscribeNewsgroupDialog(JFrame frame, Account theAccount) {
        super(frame);
        if (theAccount instanceof NntpAccount) {
            this.setTitle(StringResources.SUBSCRIBE_UNSUBSCRIBE_TO_NEWSGROUPS);
            this.iconTableRenderer = new IconTableRenderer(ImageResources.FLD_NNTP_NEWSGROUPS);
        } else {
            this.setTitle(StringResources.SUBSCRIBE_UNSUBSCRIBE_TO_FOLDERS);
            this.iconTableRenderer = new IconTableRenderer(ImageResources.FLD_IMAP);
        }
        this.account = theAccount;
        this.buildPanelUI();
        this.initUI();
        this.initNewsgroupColumnWidth();
    }

    private void initNewsgroupColumnWidth() {
        if (this.tableAll.getColumnModel().getColumnCount() > 0) {
            Enumeration<TableColumn> columns = this.tableAll.getColumnModel().getColumns();
            while (columns.hasMoreElements()) {
                TableColumn column = columns.nextElement();
                if (!column.getHeaderValue().equals(StringResources.NEWSGROUP)) continue;
                column.setPreferredWidth(column.getWidth() * 4);
            }
        }
    }

    private void initUI() {
        if (this.account instanceof NntpAccount) {
            this.tableAll.setModel(new FoldersModel(((NntpAccount)this.account).getAllNNTPFolders()));
            AccountFolderList foldersList = ((NntpAccount)this.account).getSubscribedNNTPFolders();
            logger.debug((Object)("number of subscribed folders: " + foldersList.getNumFolders()));
            this.tableSub.setModel(new SubscribedOnlyFoldersModel(foldersList));
            this.tableNew.setModel(new FoldersModel(((NntpAccount)this.account).getNewNNTPFolders()));
            this.tableAll.getSelectionModel().addListSelectionListener(new SelectionListener());
            this.tableSub.getSelectionModel().addListSelectionListener(new SelectionListener());
            this.tableNew.getSelectionModel().addListSelectionListener(new SelectionListener());
            this.tableNew.getColumnModel().getColumn(0).setCellRenderer(this.iconTableRenderer);
            ((FoldersModel)this.tableNew.getModel()).fireTableDataChanged();
        } else {
            this.tableAll.setModel(new IMAPFoldersModel(((ImapAccount)this.account).getAllIMAPFolders()));
            AccountFolderList accountFolderList = ((ImapAccount)this.account).getSubscribedIMAPFolders();
            logger.debug((Object)("number of subscribed folders: " + accountFolderList.getNumFolders()));
            this.tableSub.setModel(new SubscribedOnlyFoldersModel(accountFolderList));
            this.tablePublic.setModel(new NullColumnNameFoldersModel(((ImapAccount)this.account).getPublicIMAPFolders()));
            this.tableShared.setModel(new NullColumnNameFoldersModel(((ImapAccount)this.account).getSharedIMAPFolders()));
            this.tableAll.getSelectionModel().addListSelectionListener(new SelectionListener());
            this.tableSub.getSelectionModel().addListSelectionListener(new SelectionListener());
            this.tablePublic.getSelectionModel().addListSelectionListener(new SelectionListener());
            this.tablePublic.getColumnModel().getColumn(0).setCellRenderer(this.iconTableRenderer);
            this.tableShared.getSelectionModel().addListSelectionListener(new SelectionListener());
            this.tableShared.getColumnModel().getColumn(0).setCellRenderer(this.iconTableRenderer);
            ((FoldersModel)this.tableShared.getModel()).fireTableDataChanged();
            ((FoldersModel)this.tablePublic.getModel()).fireTableDataChanged();
        }
        this.tableAll.getColumnModel().getColumn(0).setCellRenderer(this.iconTableRenderer);
        this.tableSub.getColumnModel().getColumn(0).setCellRenderer(this.iconTableRenderer);
        this.tableAll.setAutoCreateColumnsFromModel(false);
        ((FoldersModel)this.tableSub.getModel()).fireTableDataChanged();
        ((FoldersModel)this.tableAll.getModel()).fireTableDataChanged();
        this.tfSearch.setText("");
    }

    private void buildPanelUI() {
        OrientablePanel pnlbtnSerch = new OrientablePanel(new BorderLayout());
        OrientablePanel contentPane = new OrientablePanel(new BorderLayout());
        OrientablePanel btnMainPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel btnUpPnl = new OrientablePanel(new GridLayout(3, 1, 10, 10));
        OrientablePanel searchPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel leftPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel tabPnl = new OrientablePanel(new BorderLayout());
        OrientablePanel tab1Pnl = new OrientablePanel(new BorderLayout());
        OrientablePanel tab2Pnl = new OrientablePanel(new BorderLayout());
        OrientablePanel tab3Pnl = new OrientablePanel(new BorderLayout());
        OrientablePanel tab3PnlImap = new OrientablePanel(new BorderLayout());
        OrientablePanel tab4PnlImap = new OrientablePanel(new BorderLayout());
        OrientableLabel searchLbl = new OrientableLabel(StringResources.SEARCH_FOR_FOLDERS_CONTAINING_C);
        OrientablePanel pnlAll = new OrientablePanel(new BorderLayout());
        pnlAll.add((Component)this.tableAll, "Center");
        if (this.account instanceof NntpAccount) {
            tab1Pnl.add((Component)this.tableAll.getTableHeader(), "North");
        }
        OrientablePanel pnlSub = new OrientablePanel(new BorderLayout());
        pnlSub.add((Component)this.tableSub, "Center");
        OrientablePanel pnlNew = new OrientablePanel(new BorderLayout());
        pnlNew.add((Component)this.tableNew, "Center");
        tab3Pnl.add((Component)this.tableNew.getTableHeader(), "North");
        OrientablePanel pnlPublic = new OrientablePanel(new BorderLayout());
        pnlPublic.add((Component)this.tablePublic, "Center");
        OrientablePanel pnlShared = new OrientablePanel(new BorderLayout());
        pnlShared.add((Component)this.tableShared, "Center");
        CurrentScrollPane tableScrollAll = new CurrentScrollPane(this.tableAll, pnlAll);
        CurrentScrollPane tableScrollSub = new CurrentScrollPane(this.tableSub, pnlSub);
        CurrentScrollPane tableScrollNew = new CurrentScrollPane(this.tableNew, pnlNew);
        CurrentScrollPane tableScrollPublic = new CurrentScrollPane(this.tablePublic, pnlPublic);
        CurrentScrollPane tableScrollShared = new CurrentScrollPane(this.tableShared, pnlShared);
        pnlbtnSerch.add((Component)this.btnSerch, "Center");
        if (UIUtils.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            pnlbtnSerch.setBorder(new EmptyBorder(0, 10, 0, 0));
        } else {
            pnlbtnSerch.setBorder(new EmptyBorder(0, 0, 0, 10));
        }
        searchPnl.add((Component)searchLbl, "North");
        searchPnl.add((Component)this.tfSearch, "Center");
        searchPnl.add((Component)pnlbtnSerch, "After");
        searchPnl.setBorder(new EmptyBorder(0, 0, 10, 0));
        tab1Pnl.add((Component)tableScrollAll, "Center");
        tab2Pnl.add((Component)tableScrollSub, "Center");
        tab3Pnl.add((Component)tableScrollNew, "Center");
        tab3PnlImap.add((Component)tableScrollShared, "Center");
        tab4PnlImap.add((Component)tableScrollPublic, "Center");
        this.tabPane.addTab(TAB1_NAME, tab1Pnl);
        this.tabPane.addTab(TAB2_NAME, tab2Pnl);
        if (this.account instanceof NntpAccount) {
            this.tabPane.addTab(TAB3_NAME, tab3Pnl);
        } else {
            this.tabPane.addTab(TAB3_NAME_IMAP, tab3PnlImap);
            this.tabPane.addTab(TAB4_NAME_IMAP, tab4PnlImap);
        }
        tabPnl.add((Component)this.tabPane, "Center");
        leftPnl.add((Component)searchPnl, "North");
        leftPnl.add((Component)tabPnl, "Center");
        btnUpPnl.add(this.btnClose);
        btnUpPnl.add(this.btnSub);
        btnUpPnl.add(this.btnUnsub);
        btnMainPnl.add((Component)btnUpPnl, "North");
        btnMainPnl.add((Component)this.btnRefresh, "South");
        btnMainPnl.setBorder(new EmptyBorder(0, 10, 0, 10));
        contentPane.add((Component)leftPnl, "Center");
        contentPane.add((Component)btnMainPnl, "After");
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.tabPane.setTabLayoutPolicy(1);
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == null) {
                    return;
                }
                if (((OrientableTabbedPane)e.getSource()).getSelectedIndex() == 0) {
                    SubscribeNewsgroupDialog.this.selectedTable = SubscribeNewsgroupDialog.this.tableAll;
                } else if (((OrientableTabbedPane)e.getSource()).getSelectedIndex() == 1) {
                    SubscribeNewsgroupDialog.this.selectedTable = SubscribeNewsgroupDialog.this.tableSub;
                } else if (((OrientableTabbedPane)e.getSource()).getSelectedIndex() == 2 && SubscribeNewsgroupDialog.this.account instanceof NntpAccount) {
                    SubscribeNewsgroupDialog.this.selectedTable = SubscribeNewsgroupDialog.this.tableNew;
                } else if (((OrientableTabbedPane)e.getSource()).getSelectedIndex() == 2 && SubscribeNewsgroupDialog.this.account instanceof ImapAccount) {
                    SubscribeNewsgroupDialog.this.selectedTable = SubscribeNewsgroupDialog.this.tableShared;
                } else if (((OrientableTabbedPane)e.getSource()).getSelectedIndex() == 3) {
                    SubscribeNewsgroupDialog.this.selectedTable = SubscribeNewsgroupDialog.this.tablePublic;
                }
                SubscribeNewsgroupDialog.this.updateButtons();
            }
        });
        this.setContentPane(contentPane);
        this.updateButtons();
        this.setDefaultButton(this.btnSerch);
    }

    private void updateButtons() {
        if (this.selectedTable.getSelectedRow() == -1) {
            this.setBtnStatus(false, false);
            return;
        }
        TableModel model = this.selectedTable.getModel();
        if (this.selectedTable.getSelectedRowCount() == 1) {
            if (((FoldersModel)model).isSubscribed(this.selectedTable.getSelectedRow())) {
                this.setBtnStatus(false, true);
            } else {
                this.setBtnStatus(true, false);
            }
        } else {
            boolean allSub = true;
            boolean allUnsub = true;
            for (int selRow : this.selectedTable.getSelectedRows()) {
                if (!((FoldersModel)model).isSubscribed(selRow)) {
                    allSub = false;
                }
                if (((FoldersModel)model).isSubscribed(selRow)) {
                    allUnsub = false;
                }
                if (!allUnsub && !allSub) break;
            }
            if (!allUnsub && !allSub) {
                this.setBtnStatus(true, true);
                return;
            }
            if (allSub) {
                this.setBtnStatus(false, true);
                return;
            }
            this.setBtnStatus(true, false);
        }
    }

    private void setBtnStatus(boolean btnSubIsEnabled, boolean btnUnsubIsEnabled) {
        this.btnSub.setEnabled(btnSubIsEnabled);
        this.btnUnsub.setEnabled(btnUnsubIsEnabled);
    }

    public static void showDialog(JFrame frame, Account theAcount) {
        SubscribeNewsgroupDialog dialog = new SubscribeNewsgroupDialog(frame, theAcount);
        dialog.showMe();
    }

    private class CurrentScrollPane
    extends OrientableScrollPane
    implements AdjustmentListener {
        private JTable table;

        public CurrentScrollPane(JTable table) {
            super(table, 22, 31);
            this.table = table;
            this.getVerticalScrollBar().addAdjustmentListener(this);
        }

        public CurrentScrollPane(JTable table, JPanel panel) {
            super(panel, 22, 31);
            this.table = table;
            this.getVerticalScrollBar().addAdjustmentListener(this);
        }

        public Dimension getPreferredSize() {
            int rowCount;
            Dimension preferredSize = super.getPreferredSize();
            if (this.table != null && (rowCount = this.table.getRowCount()) > 0 && this.table.getColumnCount() > 0) {
                Rectangle region = this.table.getCellRect(rowCount - 1, 0, true);
                double difference = preferredSize.getHeight() - this.table.getPreferredSize().getHeight();
                preferredSize = new Dimension((int)preferredSize.getWidth(), (int)(region.getHeight() * 9.0 + difference * 2.0));
            }
            return preferredSize;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            logger.debug((Object)("e: " + e));
            if (e.getValueIsAdjusting()) {
                return;
            }
            int x = this.getViewport().getViewRect().x;
            int y = this.getViewport().getViewRect().y;
            int height = this.getViewport().getViewRect().height;
            int leadRow = this.table.rowAtPoint(new Point(x, y));
            int trailingRow = this.table.rowAtPoint(new Point(x, y + height));
            if (leadRow != -1 && trailingRow != -1) {
                ((FoldersModel)this.table.getModel()).setVisibleRange(leadRow, trailingRow - leadRow);
            }
        }
    }

    private class ActionSearch
    extends AbstractAction {
        public ActionSearch() {
            super(StringResources.SEARCH);
        }

        public void actionPerformed(ActionEvent e) {
            TableModel model = SubscribeNewsgroupDialog.this.selectedTable.getModel();
            ((FoldersModel)model).setSearchString(SubscribeNewsgroupDialog.this.tfSearch.getText());
            ((DefaultTableModel)model).fireTableDataChanged();
        }
    }

    private class ActionRefreshList
    extends AbstractAction {
        public ActionRefreshList() {
            super(StringResources.REFRESH_LIST);
        }

        public void actionPerformed(ActionEvent e) {
            SubscribeNewsgroupDialog.this.initUI();
        }
    }

    private class ActionUnSubscribe
    extends AbstractAction {
        public ActionUnSubscribe() {
            super(StringResources.UNSUBSCRIBE);
        }

        public void actionPerformed(ActionEvent e) {
            int[] sr1 = SubscribeNewsgroupDialog.this.tableAll.getSelectedRows();
            int[] sr2 = SubscribeNewsgroupDialog.this.tableNew.getSelectedRows();
            int[] sr3 = SubscribeNewsgroupDialog.this.tableSub.getSelectedRows();
            int[] sr3Imap = SubscribeNewsgroupDialog.this.tableShared.getSelectedRows();
            int[] sr4Imap = SubscribeNewsgroupDialog.this.tablePublic.getSelectedRows();
            if (sr1.length > 0 && SubscribeNewsgroupDialog.this.tableAll.isShowing()) {
                for (int aSr1 : sr1) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tableAll.getModel()).unsubscribeTo(aSr1);
                }
            }
            if (sr2.length > 0 && SubscribeNewsgroupDialog.this.tableNew.isShowing()) {
                for (int aSr2 : sr2) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tableNew.getModel()).unsubscribeTo(aSr2);
                }
            }
            if (sr3.length > 0 && SubscribeNewsgroupDialog.this.tableSub.isShowing()) {
                for (int aSr3 : sr3) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tableSub.getModel()).unsubscribeTo(aSr3);
                }
            }
            if (sr3Imap.length > 0 && SubscribeNewsgroupDialog.this.tableShared.isShowing()) {
                for (int aSr3Imap : sr3Imap) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tableShared.getModel()).unsubscribeTo(aSr3Imap);
                }
            }
            if (sr4Imap.length > 0 && SubscribeNewsgroupDialog.this.tablePublic.isShowing()) {
                for (int aSr4Imap : sr4Imap) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tablePublic.getModel()).unsubscribeTo(aSr4Imap);
                }
            }
            SubscribeNewsgroupDialog.this.initUI();
        }
    }

    private class ActionSubscribe
    extends AbstractAction {
        public ActionSubscribe() {
            super(StringResources.SUBSCRIBE);
        }

        public void actionPerformed(ActionEvent e) {
            int[] sr1 = SubscribeNewsgroupDialog.this.tableAll.getSelectedRows();
            int[] sr2 = SubscribeNewsgroupDialog.this.tableSub.getSelectedRows();
            int[] sr3 = SubscribeNewsgroupDialog.this.tableNew.getSelectedRows();
            int[] sr3Imap = SubscribeNewsgroupDialog.this.tableShared.getSelectedRows();
            int[] sr4Imap = SubscribeNewsgroupDialog.this.tablePublic.getSelectedRows();
            if (sr1.length > 0 && SubscribeNewsgroupDialog.this.tableAll.isShowing()) {
                for (int aSr1 : sr1) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tableAll.getModel()).subscribeTo(aSr1);
                }
            }
            if (sr2.length > 0 && SubscribeNewsgroupDialog.this.tableSub.isShowing()) {
                for (int aSr2 : sr2) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tableSub.getModel()).subscribeTo(aSr2);
                }
            }
            if (sr3.length > 0 && SubscribeNewsgroupDialog.this.tableNew.isShowing()) {
                for (int aSr3 : sr3) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tableNew.getModel()).subscribeTo(aSr3);
                }
            }
            if (sr3Imap.length > 0 && SubscribeNewsgroupDialog.this.tableShared.isShowing()) {
                for (int aSr3Imap : sr3Imap) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tableShared.getModel()).subscribeTo(aSr3Imap);
                }
            }
            if (sr4Imap.length > 0 && SubscribeNewsgroupDialog.this.tablePublic.isShowing()) {
                for (int aSr4Imap : sr4Imap) {
                    ((FoldersModel)SubscribeNewsgroupDialog.this.tablePublic.getModel()).subscribeTo(aSr4Imap);
                }
            }
            SubscribeNewsgroupDialog.this.initUI();
        }
    }

    private class ActionClose
    extends AbstractAction {
        public ActionClose() {
            super(StringResources.CLOSE);
        }

        public void actionPerformed(ActionEvent e) {
            SubscribeNewsgroupDialog.this.dispose();
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SubscribeNewsgroupDialog.this.updateButtons();
        }
    }

    private class IconTableRenderer
    extends OrientableLabel
    implements TableCellRenderer {
        ImageIcon icon;

        public IconTableRenderer(ImageIcon theIcon) {
            this.icon = theIcon;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setIcon(((FoldersModel)table.getModel()).isSubscribed(row) ? this.icon : GWIcons.EMPTY_ICON);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setText((String)value);
            return this;
        }
    }

    private class SubscribedOnlyFoldersModel
    extends NullColumnNameFoldersModel {
        public SubscribedOnlyFoldersModel(AccountFolderList list) {
            super(list);
            this.initSearchList();
        }

        protected void initSearchList() {
            this.searchList.clear();
            for (int i = 0; i < this.folderList.getNumFolders(); ++i) {
                if (!this.folderList.isSubscribed(i) || !this.folderList.getFolderName(i).contains(this.searchString)) continue;
                this.searchList.add(i);
            }
        }

        protected boolean isFiltered() {
            return true;
        }
    }

    private class IMAPFoldersModel
    extends FoldersModel {
        public IMAPFoldersModel(AccountFolderList list) {
            super(list);
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            return "";
        }
    }

    private class NullColumnNameFoldersModel
    extends FoldersModel {
        public NullColumnNameFoldersModel(AccountFolderList list) {
            super(list);
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            return null;
        }
    }

    private class FoldersModel
    extends DefaultTableModel {
        protected AccountFolderList folderList;
        protected String searchString = "";
        protected List<Integer> searchList = new LinkedList<Integer>();

        public FoldersModel(AccountFolderList list) {
            this.folderList = list;
            this.folderList.addAccountFolderListener(new AccountFolderListener(){

                public void updateSize(AccountFolderEvent e) {
                    logger.debug((Object)("size updated: " + e));
                    int[] rows = SubscribeNewsgroupDialog.this.selectedTable.getSelectedRows();
                    FoldersModel.this.fireTableDataChanged();
                    for (int row : rows) {
                        SubscribeNewsgroupDialog.this.selectedTable.addRowSelectionInterval(row, row);
                    }
                }
            });
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return StringResources.NEWSGROUP;
            }
            if (column == 1) {
                return StringResources.MESSAGES;
            }
            if (column == 2) {
                return StringResources.POST_Q;
            }
            return "";
        }

        public int getRowCount() {
            if (this.searchString == null) {
                return 0;
            }
            if (this.isFiltered()) {
                return this.searchList.size();
            }
            return this.folderList != null ? this.folderList.getNumFolders() : 0;
        }

        public boolean isSubscribed(int row) {
            return this.folderList.isSubscribed(this.getAbsoluteIndex(row));
        }

        public String getSearchString() {
            return this.searchString;
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString;
            this.initSearchList();
        }

        protected void initSearchList() {
            this.searchList.clear();
            for (int i = 0; i < this.folderList.getNumFolders(); ++i) {
                if (!this.folderList.getFolderName(i).contains(this.searchString)) continue;
                this.searchList.add(i);
            }
        }

        public Object getValueAt(int row, int column) {
            int absoluteIndex = this.getAbsoluteIndex(row);
            if (column == 0) {
                return this.folderList.getFolderName(absoluteIndex);
            }
            if (column == 1) {
                int size = this.folderList.getSize(absoluteIndex);
                if (size == -1) {
                    return "";
                }
                return size;
            }
            if (column == 2) {
                return this.folderList.isPostingAllowed(absoluteIndex) ? StringResources.YES : StringResources.NO;
            }
            return "";
        }

        protected boolean isFiltered() {
            return !this.searchString.equals("");
        }

        private int getAbsoluteIndex(int relativeIndex) {
            return this.isFiltered() ? this.searchList.get(relativeIndex) : relativeIndex;
        }

        public boolean subscribeTo(int index) {
            int absoluteIndex = this.getAbsoluteIndex(index);
            boolean result = this.folderList.subscribe(absoluteIndex, 0);
            logger.debug((Object)("folder #" + absoluteIndex + (result ? " subscribed" : " NOT subscribed")));
            return result;
        }

        public boolean unsubscribeTo(int index) {
            int absoluteIndex = this.getAbsoluteIndex(index);
            boolean result = this.folderList.unsubscribe(absoluteIndex);
            logger.debug((Object)("folder #" + absoluteIndex + (result ? " unsubscribed" : " NOT unsubscribed")));
            return result;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void setVisibleRange(int leadRow, int size) {
            this.folderList.setVisibleRange(leadRow, size);
        }
    }
}

