/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.advancedfilter;

import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.log4j.Logger;

public class ConditionButton
extends JButton {
    public static Logger logger = Logger.getLogger(ConditionButton.class);
    private static int RIGTH_ICON_WIDTH = 16;
    BufferedImage bi;
    private ImageIcon imageIcon;
    private String text = "";
    private int width = 40;

    public ConditionButton() {
        this((ImageIcon)null);
    }

    public ConditionButton(ImageIcon theImageIcon) {
        this.setIcon(theImageIcon);
        this.addAncestorListener(new BtnSizeListener());
        this.setMargin(new Insets(0, 6, 0, 6));
        this.setHorizontalTextPosition(4);
    }

    public void setIcon(ImageIcon theImageIcon) {
        this.imageIcon = theImageIcon;
        int imWidth = this.width - this.getMargin().left - this.getMargin().right;
        this.bi = new BufferedImage(imWidth, RIGTH_ICON_WIDTH, 2);
        Graphics g = this.bi.getGraphics();
        if (this.imageIcon != null) {
            g.drawImage(theImageIcon.getImage(), 0, 0, this);
        }
        g.drawImage(ImageResources.ADV_FILTER_UP_DOWN.getImage(), imWidth - RIGTH_ICON_WIDTH, 0, this);
        super.setIcon(new ImageIcon(this.bi));
    }

    public void setText(String theText) {
        this.imageIcon = null;
        this.text = theText;
        int imWidth = this.width - this.getMargin().left - this.getMargin().right;
        this.bi = new BufferedImage(imWidth, RIGTH_ICON_WIDTH, 2);
        Graphics g = this.bi.getGraphics();
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        g.drawString(theText, 0, this.getFontMetrics(this.getFont()).getAscent());
        g.drawImage(ImageResources.ADV_FILTER_UP_DOWN.getImage(), imWidth - RIGTH_ICON_WIDTH, 0, this);
        super.setIcon(new ImageIcon(this.bi));
    }

    public String getButtonText() {
        return this.text;
    }

    public String getText() {
        return null;
    }

    class BtnSizeListener
    implements AncestorListener {
        BtnSizeListener() {
        }

        public void ancestorAdded(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }

        public void ancestorMoved(AncestorEvent event) {
            ConditionButton.this.width = ConditionButton.this.getSize().width;
            if (ConditionButton.this.imageIcon == null) {
                ConditionButton.this.setText(ConditionButton.this.text);
            } else {
                ConditionButton.this.setIcon(ConditionButton.this.imageIcon);
            }
        }
    }
}

