/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.backup;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePasswordField;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class RestorePathDialog
extends GWDialog {
    private JTextField tfFilePath = new GWTextField();
    private JPasswordField tfPassword = new OrientablePasswordField();

    public RestorePathDialog(String theDefaultPath) {
        super((JFrame)null, true);
        this.tfPassword.enableInputMethods(true);
        this.setTitle(StringResources.GROUPWISE_RESTORE_PATH);
        this.buildUI();
        this.tfFilePath.setColumns(25);
        this.tfFilePath.setText(theDefaultPath);
        if (GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).isOnlineDataStore()) {
            this.tfPassword.setEnabled(false);
            this.tfPassword.setEditable(false);
        }
    }

    public String getPassword() {
        return new String(this.tfPassword.getPassword());
    }

    public String getFilePath() {
        return this.tfFilePath.getText();
    }

    private void buildUI() {
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        pnlContent.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.insets.bottom = 5;
        pnlContent.add((Component)new JMnemonicLabel(StringResources.RESTORE_FROM_C, this.tfFilePath), constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        pnlContent.add((Component)this.tfFilePath, constraints);
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        constraints.anchor = 22;
        constraints.fill = 0;
        constraints.insets.left = 0;
        ToolBarButton btnSelectFolder = new ToolBarButton(new SelectFolderAction());
        GWToolBar toolBar = new GWToolBar();
        toolBar.add(btnSelectFolder);
        toolBar.setBorder(null);
        pnlContent.add((Component)toolBar, constraints);
        constraints.insets.left = 5;
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.anchor = 21;
        pnlContent.add((Component)new JMnemonicLabel(StringResources.PASSWORD_C, this.tfPassword), constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        pnlContent.add((Component)this.tfPassword, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 24;
        constraints.gridwidth = 3;
        constraints.insets.right = 0;
        pnlContent.add((Component)this.buildButtonsPane(), constraints);
        pnlContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private Container buildButtonsPane() {
        OrientablePanel pnlResult = new OrientablePanel();
        OS.addButtons(pnlResult, this.btnOK, this.btnCancel);
        return pnlResult;
    }

    private class SelectFolderAction
    extends AbstractAction {
        public SelectFolderAction() {
            super("", ImageResources.ICON_FOLDER);
        }

        public void actionPerformed(ActionEvent e) {
            if (OS.isMacOS()) {
                File f;
                boolean isOK;
                String dialogCaption = StringResources.SELECT_DIRECTORY;
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(RestorePathDialog.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser fileChoser = new GWMacFileChooser(frame, dialogCaption, null, 0);
                fileChoser.setVisible(true);
                String selectedFile = fileChoser.getFile();
                String selecteddirectory = fileChoser.getDirectory();
                if (selectedFile != null && (isOK = (f = new File(selecteddirectory + selectedFile)).isDirectory())) {
                    RestorePathDialog.this.tfFilePath.setText(f.getPath());
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                GWFileChooser fileChooser = new GWFileChooser(RestorePathDialog.this, StringResources.OPEN, null, 1, 0, false);
                fileChooser.setVisible(true);
                String[] fileNames = fileChooser.getResult();
                if (fileNames != null) {
                    File selectedFile = fileChooser.getChooser().getSelectedFile();
                    RestorePathDialog.this.tfFilePath.setText(selectedFile.getPath());
                }
            }
        }
    }
}

