/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.calendars;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.filechoser.FileChooserPanel;
import com.novell.gw.jclient.application.controls.filechoser.FileSelectedListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.calendars.ImportCalendarDialogController;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportCalendarDialog
extends ApplicationDialog<ImportCalendarDialogController> {
    private static final String CALENDAR_FILE_EXTENSION_ICS = ".ics";
    private static final String CALENDAR_FILE_EXTENSION_VCS = ".vcs";
    private static final int CALENDAR_NAME_INDEX = 0;
    private static final int CALENDAR_DESCRIPTION_INDEX = 1;
    private FileChooserPanel fileChooserPanel;
    private OrientableTextField tfCalendarName;
    private OrientableTextArea taCalendarDescription;
    private ButtonGroup radioButtonsGroup;
    private String calendarFilePath;
    private IDataStore dataStore;
    private JRadioButton rbReplaceExisting;

    public ImportCalendarDialog(ApplicationFrame theFrame) {
        super((Frame)theFrame, theFrame.getController(), true);
        this.initDataStore();
        this.setTitle(StringResources.IMPORT_CALENDAR);
        this.buildUI();
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
    }

    private JRadioButton addRadioButton(String text, boolean isSelected) {
        OrientableRadioButton button = new OrientableRadioButton(text);
        button.setSelected(isSelected);
        this.radioButtonsGroup.add(button);
        return button;
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlButtons);
        adapter.setColumnCount(2);
        adapter.setRowCount(1);
        JButton btnOK = this.getBtnOk();
        btnOK.setEnabled(false);
        if (OS.isMacOS()) {
            adapter.addComponent(this.getBtnCancel());
            adapter.addComponent(btnOK);
        } else {
            adapter.addComponent(btnOK);
            adapter.addComponent(this.getBtnCancel());
        }
        OrientablePanel pnlWrapper = new OrientablePanel(new BorderLayout());
        pnlWrapper.add((Component)pnlButtons, "East");
        return pnlWrapper;
    }

    private void buildConstraints(GridBagConstraints gbc, int x, int y, int w, int h, int wx, int wy, int fill, int anchor) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.fill = fill;
        gbc.anchor = anchor;
    }

    private void buildInButtonsPanel(JPanel pnlContent, GridBagConstraints constraints) {
        JPanel pnlButtons = this.buildButtonsPanel();
        this.buildConstraints(constraints, 0, 6, 1, 1, 1, 0, 0, 26);
        pnlContent.add((Component)pnlButtons, constraints);
    }

    private void buildInCalendarDescriptionArea(JPanel pnlContent, GridBagConstraints constraints) {
        this.taCalendarDescription = new OrientableTextArea(4, 1);
        this.taCalendarDescription.setEnabled(false);
        this.buildConstraints(constraints, 0, 4, 1, 1, 1, 1, 1, 23);
        OrientableScrollPane pnlScrollWrapper = new OrientableScrollPane(this.taCalendarDescription, 22, 31);
        pnlContent.add((Component)pnlScrollWrapper, constraints);
    }

    private void buildInCalendarLabel(JPanel pnlContent, GridBagConstraints constraints) {
        OrientableLabel lbCalendarName = new OrientableLabel(StringResources.CALENDAR_NAME_C);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 0, 0, 23);
        pnlContent.add((Component)lbCalendarName, constraints);
    }

    private void buildInCalendarTextField(JPanel pnlContent, GridBagConstraints constraints) {
        this.tfCalendarName = new OrientableTextField();
        this.tfCalendarName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ImportCalendarDialog.this.onCalendarNameTextChanged(ImportCalendarDialog.this.tfCalendarName.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                ImportCalendarDialog.this.onCalendarNameTextChanged(ImportCalendarDialog.this.tfCalendarName.getText());
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.buildConstraints(constraints, 0, 2, 1, 1, 1, 0, 2, 23);
        pnlContent.add((Component)this.tfCalendarName, constraints);
    }

    private void buildInDescriptionLabel(JPanel pnlContent, GridBagConstraints constraints) {
        OrientableLabel lbDescription = new OrientableLabel(StringResources.DESCRIPTION_C);
        this.buildConstraints(constraints, 0, 3, 1, 1, 0, 0, 0, 23);
        pnlContent.add((Component)lbDescription, constraints);
    }

    private void buildInFileChooser(JPanel pnlContent, GridBagConstraints constraints) {
        this.fileChooserPanel = new FileChooserPanel(StringResources.FILE_NAME_C, "", 0);
        this.fileChooserPanel.addFileSelectedListener((FileSelectedListener)this.getController());
        this.buildConstraints(constraints, 0, 0, 1, 1, 1, 0, 2, 23);
        pnlContent.add((Component)this.fileChooserPanel, constraints);
    }

    private void buildInRadioButtonsPanel(JPanel pnlContent, GridBagConstraints constraints) {
        JPanel pnlRadioButtons = this.buildRadioButtonsPanel();
        this.buildConstraints(constraints, 0, 5, 1, 1, 0, 0, 0, 23);
        pnlContent.add((Component)pnlRadioButtons, constraints);
    }

    private JPanel buildRadioButtonsPanel() {
        OrientablePanel pnlRadioButtons = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.radioButtonsGroup = new ButtonGroup();
        this.rbReplaceExisting = this.addRadioButton(StringResources.REPLACE_EXISTING_CONTENTS, true);
        this.rbReplaceExisting.setEnabled(false);
        this.buildConstraints(gbc, 0, 0, 1, 1, 0, 0, 0, 21);
        pnlRadioButtons.add((Component)this.rbReplaceExisting, gbc);
        JRadioButton rbAddToExisting = this.addRadioButton(StringResources.ADD_TO_EXISTING_CONTENTS, false);
        rbAddToExisting.setEnabled(false);
        this.buildConstraints(gbc, 0, 1, 1, 1, 0, 0, 0, 21);
        pnlRadioButtons.add((Component)rbAddToExisting, gbc);
        return pnlRadioButtons;
    }

    private void buildUI() {
        Container container = this.getContentPane();
        OrientablePanel pnlContent = new OrientablePanel();
        container.add(pnlContent);
        GridBagLayout gridBagLayout = new GridBagLayout();
        pnlContent.setLayout(gridBagLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        this.buildInFileChooser(pnlContent, constraints);
        this.buildInCalendarLabel(pnlContent, constraints);
        this.buildInCalendarTextField(pnlContent, constraints);
        this.buildInDescriptionLabel(pnlContent, constraints);
        this.buildInCalendarDescriptionArea(pnlContent, constraints);
        this.buildInRadioButtonsPanel(pnlContent, constraints);
        this.buildInButtonsPanel(pnlContent, constraints);
    }

    private boolean calendarNameExists(String name) {
        return this.getDataStore().isCalendarFolderNameAlreadyExist(name);
    }

    private String getCalendarDescription(String[] calendarNameAndDescription) {
        String calendarDescription = null;
        if (calendarNameAndDescription != null && calendarNameAndDescription.length > 1) {
            calendarDescription = calendarNameAndDescription[1];
        }
        return calendarDescription;
    }

    private String getCalendarName(String[] calendarNameAndDescription) {
        String calendarName = null;
        if (calendarNameAndDescription != null && calendarNameAndDescription.length > 0) {
            calendarName = calendarNameAndDescription[0];
        }
        return calendarName;
    }

    private String[] getCalendarNameAndDescriptionFromFile(File file) {
        String[] calendarNameAndDescription = null;
        if (file != null) {
            calendarNameAndDescription = this.getDataStore().getIcalNameAndDescription(file.getPath());
        }
        return calendarNameAndDescription;
    }

    private IDataStore getDataStore() {
        if (this.dataStore == null) {
            this.initDataStore();
        }
        return this.dataStore;
    }

    private File getSelectedFileFromFileChooser() {
        File selectedFile = null;
        String pathname = this.fileChooserPanel.getText();
        if (!Utils.isNullOrEmpty(pathname)) {
            selectedFile = new File(pathname);
        }
        return selectedFile;
    }

    private void initDataStore() {
        GWCommandManager commandManager = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController()));
        this.dataStore = commandManager.getCurrentDataStore();
    }

    private boolean isCalendarFile(File file) {
        boolean isCalendarFile = false;
        if (file != null && file.exists() && file.isFile()) {
            String filename = file.getName();
            isCalendarFile = filename.endsWith(CALENDAR_FILE_EXTENSION_ICS) || filename.endsWith(CALENDAR_FILE_EXTENSION_VCS);
        }
        return isCalendarFile;
    }

    private void onCalendarNameTextChanged(String text) {
        if (!Utils.isNullOrEmpty(text) && text.trim().length() > 0) {
            boolean nameExists = this.calendarNameExists(text);
            this.setGroupButtomsEnable(nameExists);
            this.getBtnOk().setEnabled(!Utils.isNullOrEmpty(this.calendarFilePath));
        } else {
            this.getBtnOk().setEnabled(false);
        }
    }

    private void setCalendarNameAndDescription(File selectedFile) {
        this.calendarFilePath = selectedFile.getPath();
        String[] calendarNameAndDescription = this.getCalendarNameAndDescriptionFromFile(selectedFile);
        String calendarName = this.getCalendarName(calendarNameAndDescription);
        if (Utils.isNullOrEmpty(calendarName)) {
            String fileName = selectedFile.getName();
            int nExtensionIndex = fileName.lastIndexOf(".");
            if (nExtensionIndex < 0) {
                this.tfCalendarName.setText(fileName);
            } else {
                this.tfCalendarName.setText(fileName.substring(0, nExtensionIndex));
            }
        } else {
            this.tfCalendarName.setText(calendarName);
        }
        String calendarDescription = this.getCalendarDescription(calendarNameAndDescription);
        if (!Utils.isNullOrEmpty(calendarDescription)) {
            this.taCalendarDescription.setText(calendarDescription);
        }
    }

    private void setGroupButtomsEnable(boolean isEnable) {
        Enumeration<AbstractButton> buttons = this.radioButtonsGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.setEnabled(isEnable);
        }
    }

    private void showInvalidCalendarFileMessageDialog(String invalidCalendarFilePath) {
        JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.IS_NOT_A_VALID_CALENDAR_FILE_TO_IMPORT, invalidCalendarFilePath), StringResources.IMPORT_CALENDAR, 2);
    }

    @Override
    protected ImportCalendarDialogController createController(MVCController parentController) {
        return new ImportCalendarDialogController(this, parentController);
    }

    @Override
    protected void processCancelAction(ActionEvent event) {
        super.processCancelAction(event);
        this.dispose();
    }

    @Override
    protected void processCloseAction(WindowEvent event) {
        super.processCloseAction(event);
        this.dispose();
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        File selectedFile = this.getSelectedFileFromFileChooser();
        if (this.isCalendarFile(selectedFile)) {
            if (!selectedFile.getPath().equals(this.calendarFilePath)) {
                this.setCalendarNameAndDescription(selectedFile);
            }
            super.processOkAction(event);
            EngineCommandManager commandManager = (EngineCommandManager)EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController()));
            if (commandManager != null) {
                commandManager.importCalendar(this.calendarFilePath, this.tfCalendarName.getText(), this.taCalendarDescription.getText(), this.rbReplaceExisting.isSelected());
            }
            this.dispose();
        } else {
            this.showInvalidCalendarFileMessageDialog(selectedFile.getPath());
        }
    }

    public void onFileSelected(File selectedFile) {
        if (this.isCalendarFile(selectedFile)) {
            this.setCalendarNameAndDescription(selectedFile);
        } else {
            this.fileChooserPanel.setText(null);
            this.showInvalidCalendarFileMessageDialog(selectedFile.getPath());
        }
    }

    public void setChoosenFile(String filePath) {
        this.fileChooserPanel.setText(filePath);
    }
}

