/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.categories;

import com.novell.gw.jclient.api.enums.CategoryListRecordStatusType;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CategoriesTableModel
extends AbstractTableModel {
    private ICategoryList categories;
    private int itemsCount;
    private List<ICategory> changedCategories = new ArrayList<ICategory>();
    private String userGuid;

    public CategoriesTableModel(ICategoryList categories, String userGuid) {
        this.categories = categories;
        this.itemsCount = categories.getItemCount();
        this.userGuid = userGuid;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return CategoryUtils.getCategoryCount(this.userGuid);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public boolean isArmed(ICategory category) {
        if (this.categories.findCategoryIndex(category) == -1) {
            return false;
        }
        if (this.categories.getUseCnt(this.categories.findCategoryIndex(category)) != this.itemsCount) {
            return !this.changedCategories.contains(category);
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        ICategory category = CategoryUtils.getCategory(rowIndex, this.userGuid);
        if (columnIndex == 0) {
            Boolean b = (Boolean)value;
            this.changedCategories.add(category);
            if (b.booleanValue()) {
                this.categories.addCategory(category, CategoryListRecordStatusType.ADD);
            } else {
                this.categories.addCategory(category, CategoryListRecordStatusType.REMOVE);
                this.categories.resetState();
            }
            this.fireTableDataChanged();
        } else {
            String text = (String)value;
            if (CategoryUtils.getCategory(text, this.userGuid) == null) {
                CategoryUtils.getCategory(rowIndex, this.userGuid).setName(text);
                this.changedCategories.add(category);
            }
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return CategoryUtils.getCategory(rowIndex, this.userGuid);
    }

    public void setPrimary(int rowIndex) {
        for (int i = 0; i < CategoryUtils.getCategoryCount(this.userGuid); ++i) {
            ICategory category = CategoryUtils.getCategory(i, this.userGuid);
            int index = this.categories.findCategoryIndex(category);
            if (index == -1 || !this.categories.isPrimary(index)) continue;
            this.changedCategories.add(category);
            this.categories.setPrimary(category, false, CategoryListRecordStatusType.NONE);
        }
        ICategory category = CategoryUtils.getCategory(rowIndex, this.userGuid);
        this.changedCategories.add(category);
        CategoryListRecordStatusType recordStatusType = CategoryListRecordStatusType.NONE;
        if (this.categories.findCategoryIndex(category) == -1) {
            recordStatusType = CategoryListRecordStatusType.ADD;
            this.categories.addCategory(category, recordStatusType);
        }
        this.categories.setPrimary(category, true, recordStatusType);
        this.categories.resetState();
        this.fireTableDataChanged();
    }

    public void deleteCategory(int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            CategoryUtils.removeCategory(rows[i], this.userGuid);
        }
        this.fireTableDataChanged();
    }

    public void renameCategory(int rowIndex, String name) {
        CategoryUtils.getCategory(rowIndex, this.userGuid).setName(name);
        this.fireTableDataChanged();
    }

    public void setTextColor(int rowIndex, Color color) {
        ICategory category = CategoryUtils.getCategory(rowIndex, this.userGuid);
        category.setTextColor(color);
        this.changedCategories.add(category);
        this.fireTableDataChanged();
    }

    public void setBackgroundColor(int rowIndex, Color color) {
        ICategory category = CategoryUtils.getCategory(rowIndex, this.userGuid);
        category.setBackgroundColor(color);
        this.changedCategories.add(category);
        this.fireTableDataChanged();
    }

    public void addCategory(String name) {
        ICategory category = CategoryUtils.createCategory(name, this.userGuid);
        this.getCategories().addCategory(category, CategoryListRecordStatusType.ADD);
        this.fireTableDataChanged();
    }

    public ICategoryList getCategories() {
        return this.categories;
    }

    public List<ICategory> getChangedCategories() {
        return this.changedCategories;
    }

    public void setCategories(ICategoryList categories) {
        this.categories = categories;
        this.fireTableDataChanged();
    }
}

