/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.error;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.IconedDialog;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class ExErrorDialog
extends IconedDialog {
    private static final int DEFAULT_WIDTH = 570;
    private static final int DETAILS_HEIGHT = 250;
    private static final int TOP = 10;
    private static final int LEFT = 10;
    private static final int RIGHT = 10;
    private static final int BOTTOM = 10;
    private static final String GO_LEFT = " <<<";
    private static final String GO_RIGHT = " >>>";
    private JScrollPane scrollExplanation;
    private JPanel panelMessage;
    Window parentWindow;
    JLabel lbImage = new OrientableLabel();
    JTextArea taMessage = new JTextArea();
    JTextArea taDetails;
    JButton btnDetails;
    JButton btnClose = new JMnemonicButton(new CloseAction());
    String message;
    String explanation;
    Icon icon;
    private boolean detailsVisible;
    private int unexpandedWidth;
    private int unexpandedHeight;
    private int expandedWidth;
    private int expandedHeight;
    private JPanel pnlButtons;

    public ExErrorDialog(String theTitle, String theMessage, String theExplanation, Icon theIcon, Dialog parent) {
        super(parent);
        this.init(theTitle, theMessage, theExplanation, theIcon);
    }

    public ExErrorDialog(String theTitle, String theMessage, String theExplanation, Icon theIcon, Frame parent) {
        super(parent);
        this.init(theTitle, theMessage, theExplanation, theIcon);
    }

    public ExErrorDialog(String theTitle, String theMessage, String theExplanation, Icon theIcon) {
        this.init(theTitle, theMessage, theExplanation, theIcon);
    }

    private void init(String theTitle, String theMessage, String theExplanation, Icon theIcon) {
        this.setTitle(theTitle);
        this.message = theMessage;
        this.explanation = theExplanation;
        this.icon = theIcon;
        this.build();
    }

    private void build() {
        this.lbImage.setIcon(this.icon);
        this.taMessage.setText(this.message);
        this.taMessage.setBorder(null);
        this.taMessage.setBackground(this.getBackground());
        this.taMessage.setAlignmentY(0.0f);
        this.taMessage.setEditable(false);
        this.taMessage.setFocusable(false);
        this.taMessage.setWrapStyleWord(true);
        this.taMessage.setLineWrap(true);
        this.panelMessage = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 11;
        c.insets = new Insets(5, 5, 0, 0);
        this.panelMessage.add((Component)this.lbImage, c);
        c.gridx = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 10, 0, 10);
        this.panelMessage.add((Component)this.taMessage, c);
        if (this.explanation != null && this.explanation.length() > 0) {
            this.btnDetails = new JMnemonicButton(new DetailsAction());
        }
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(10, 0, 17, 10);
        this.pnlButtons = this.createButtonsPanel();
        this.panelMessage.add((Component)this.pnlButtons, c);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.panelMessage);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ExErrorDialog.this.updateSizes();
            }
        });
        this.pack();
        this.setSize(570, this.getHeight());
        this.updateSizes();
        this.setResizable(false);
        UIUtils.centerWindowOnScreen(this);
    }

    private void updateSizes() {
        if (this.detailsVisible) {
            this.expandedWidth = this.getWidth();
            this.expandedHeight = this.getHeight();
            this.unexpandedWidth = this.expandedWidth;
        } else {
            this.unexpandedHeight = this.getHeight();
            this.expandedWidth = this.unexpandedWidth = this.getWidth();
            this.expandedHeight = this.unexpandedHeight + 250;
        }
    }

    private JPanel createButtonsPanel() {
        JPanel content = new JPanel();
        if (this.btnDetails != null) {
            content.setLayout(new BoxLayout(content, 0));
            content.add(Box.createHorizontalGlue());
            content.add(this.btnClose);
            content.add(Box.createRigidArea(new Dimension(10, 1)));
            content.add(this.btnDetails);
            UIUtils.setFocusTraversalKeys(this.btnClose);
            UIUtils.setFocusTraversalKeys(this.btnDetails);
            this.updateHandleButton();
        } else {
            content.add(this.btnClose);
        }
        this.getRootPane().setDefaultButton(this.btnClose);
        return content;
    }

    private void switchDetailsVisibility() {
        if (this.detailsVisible) {
            this.getContentPane().remove(this.getDetailsComponent());
            this.setSize(this.unexpandedWidth, this.unexpandedHeight);
        } else {
            this.getContentPane().add(this.getDetailsComponent());
            this.setSize(this.expandedWidth, this.expandedHeight);
        }
        this.detailsVisible = !this.detailsVisible;
        this.updateHandleButton();
    }

    private Component getDetailsComponent() {
        if (this.taDetails == null) {
            this.taDetails = new JTextArea();
            this.taDetails.setText(this.explanation);
            this.taDetails.setEditable(false);
            this.taDetails.setBackground(this.getBackground());
            this.scrollExplanation = new OrientableScrollPane(this.taDetails);
            Border outBorder = BorderFactory.createEmptyBorder(0, 10, 10, 10);
            Border inBorder = BorderFactory.createLineBorder(Color.GRAY);
            this.scrollExplanation.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        }
        return this.scrollExplanation;
    }

    private void updateHandleButton() {
        this.btnDetails.setText(this.detailsVisible ? StringResources.DETAILS + GO_LEFT : StringResources.DETAILS + GO_RIGHT);
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(StringResources.CLOSE);
        }

        public void actionPerformed(ActionEvent e) {
            ExErrorDialog.this.dispose();
        }
    }

    private class DetailsAction
    extends AbstractAction {
        public DetailsAction() {
            super(StringResources.ACTION_DETAILS);
        }

        public void actionPerformed(ActionEvent e) {
            ExErrorDialog.this.switchDetailsVisibility();
        }
    }
}

